/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.OggPacketWriter;
import org.gagravarr.ogg.OggPage;

public class TestBasicWrite
extends TestCase {
    public void testOpen() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OggFile ogg = new OggFile((OutputStream)baos);
        try {
            ogg.getPacketReader();
            TestBasicWrite.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        OggPacketWriter w = ogg.getPacketWriter(1234);
        w.close();
        ogg.close();
    }

    public void testEmptyPages() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OggFile ogg = new OggFile((OutputStream)baos);
        OggPacketWriter w = ogg.getPacketWriter(1234);
        w.close();
        TestBasicWrite.assertEquals((int)28, (int)baos.size());
        ByteArrayInputStream inp = new ByteArrayInputStream(baos.toByteArray());
        ((InputStream)inp).read();
        ((InputStream)inp).read();
        ((InputStream)inp).read();
        ((InputStream)inp).read();
        OggPage page = new OggPage((InputStream)inp);
        TestBasicWrite.assertEquals((int)1, (int)page.getNumLVs());
        OggFile opened = new OggFile((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        OggPacketReader r = opened.getPacketReader();
        OggPacket p = r.getNextPacket();
        TestBasicWrite.assertNotNull((Object)p);
        TestBasicWrite.assertEquals((boolean)true, (boolean)p.isBeginningOfStream());
        TestBasicWrite.assertEquals((boolean)true, (boolean)p.isEndOfStream());
        TestBasicWrite.assertEquals((int)1234, (int)p.getSid());
        TestBasicWrite.assertEquals((int)0, (int)p.getSequenceNumber());
        TestBasicWrite.assertEquals((int)0, (int)p.getData().length);
        TestBasicWrite.assertNull((Object)r.getNextPacket());
        w = ogg.getPacketWriter(54321);
        w.flush();
        p = new OggPacket(new byte[0]);
        w.bufferPacket(p);
        w.flush();
        p = new OggPacket(new byte[]{22});
        w.bufferPacket(p);
        w.close();
        opened = new OggFile((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        r = opened.getPacketReader();
        p = r.getNextPacket();
        TestBasicWrite.assertNotNull((Object)p);
        TestBasicWrite.assertEquals((boolean)true, (boolean)p.isBeginningOfStream());
        TestBasicWrite.assertEquals((boolean)true, (boolean)p.isEndOfStream());
        TestBasicWrite.assertEquals((int)1234, (int)p.getSid());
        TestBasicWrite.assertEquals((int)0, (int)p.getSequenceNumber());
        TestBasicWrite.assertEquals((int)0, (int)p.getData().length);
        p = r.getNextPacket();
        TestBasicWrite.assertNotNull((Object)p);
        TestBasicWrite.assertEquals((boolean)true, (boolean)p.isBeginningOfStream());
        TestBasicWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicWrite.assertEquals((int)54321, (int)p.getSid());
        TestBasicWrite.assertEquals((int)0, (int)p.getSequenceNumber());
        TestBasicWrite.assertEquals((int)0, (int)p.getData().length);
        p = r.getNextPacket();
        TestBasicWrite.assertNotNull((Object)p);
        TestBasicWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicWrite.assertEquals((boolean)true, (boolean)p.isEndOfStream());
        TestBasicWrite.assertEquals((int)54321, (int)p.getSid());
        TestBasicWrite.assertEquals((int)1, (int)p.getSequenceNumber());
        TestBasicWrite.assertEquals((int)1, (int)p.getData().length);
        TestBasicWrite.assertNull((Object)r.getNextPacket());
    }

    public void testInterleaved() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OggFile ogg = new OggFile((OutputStream)baos);
        OggPacketWriter w1 = ogg.getPacketWriter(1234);
        OggPacketWriter w2 = ogg.getPacketWriter(4321);
        OggPacket p = new OggPacket(new byte[]{1});
        w1.bufferPacket(p, true);
        p = new OggPacket(new byte[]{2});
        w2.bufferPacket(p, true);
        p = new OggPacket(new byte[]{1, 1});
        w1.bufferPacket(p);
        p = new OggPacket(new byte[]{1, 2});
        w1.bufferPacket(p, false);
        p = new OggPacket(new byte[]{2, 2});
        w2.bufferPacket(p);
        w2.close();
        w1.close();
        OggFile opened = new OggFile((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        OggPacketReader r = opened.getPacketReader();
        p = r.getNextPacket();
        TestBasicWrite.assertEquals((int)1234, (int)p.getSid());
        TestBasicWrite.assertEquals((int)0, (int)p.getSequenceNumber());
        TestBasicWrite.assertEquals((boolean)true, (boolean)p.isBeginningOfStream());
        TestBasicWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicWrite.assertEquals((int)1, (int)p.getData().length);
        TestBasicWrite.assertEquals((int)1, (int)p.getData()[0]);
        p = r.getNextPacket();
        TestBasicWrite.assertEquals((int)4321, (int)p.getSid());
        TestBasicWrite.assertEquals((int)0, (int)p.getSequenceNumber());
        TestBasicWrite.assertEquals((boolean)true, (boolean)p.isBeginningOfStream());
        TestBasicWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicWrite.assertEquals((int)1, (int)p.getData().length);
        TestBasicWrite.assertEquals((int)2, (int)p.getData()[0]);
        p = r.getNextPacket();
        TestBasicWrite.assertEquals((int)4321, (int)p.getSid());
        TestBasicWrite.assertEquals((int)1, (int)p.getSequenceNumber());
        TestBasicWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicWrite.assertEquals((boolean)true, (boolean)p.isEndOfStream());
        TestBasicWrite.assertEquals((int)2, (int)p.getData().length);
        TestBasicWrite.assertEquals((int)2, (int)p.getData()[0]);
        TestBasicWrite.assertEquals((int)2, (int)p.getData()[1]);
        p = r.getNextPacket();
        TestBasicWrite.assertEquals((int)1234, (int)p.getSid());
        TestBasicWrite.assertEquals((int)1, (int)p.getSequenceNumber());
        TestBasicWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicWrite.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestBasicWrite.assertEquals((int)2, (int)p.getData().length);
        TestBasicWrite.assertEquals((int)1, (int)p.getData()[0]);
        TestBasicWrite.assertEquals((int)1, (int)p.getData()[1]);
        p = r.getNextPacket();
        TestBasicWrite.assertEquals((int)1234, (int)p.getSid());
        TestBasicWrite.assertEquals((int)1, (int)p.getSequenceNumber());
        TestBasicWrite.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestBasicWrite.assertEquals((boolean)true, (boolean)p.isEndOfStream());
        TestBasicWrite.assertEquals((int)2, (int)p.getData().length);
        TestBasicWrite.assertEquals((int)1, (int)p.getData()[0]);
        TestBasicWrite.assertEquals((int)2, (int)p.getData()[1]);
        TestBasicWrite.assertEquals(null, (Object)r.getNextPacket());
    }
}

