/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.impl;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.api.settings.FeaturePlugin;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;

@Managed
@ManagedDescription(value="eXo Feature Service")
@NameTemplate(value={@Property(key="service", value="feature"), @Property(key="view", value="ExoFeatureService")})
@RESTEndpoint(path="featureservice")
public class ExoFeatureServiceImpl
implements ExoFeatureService {
    private static final String NAME_SPACES = "exo:";
    private SettingService settingService;
    private Map<String, Boolean> featuresProperties = new HashMap<String, Boolean>();
    private Map<String, FeaturePlugin> plugins = new HashMap<String, FeaturePlugin>();

    public ExoFeatureServiceImpl(SettingService settingService) {
        this.settingService = settingService;
    }

    @Managed
    @ManagedDescription(value="Determine if the feature is active")
    @Impact(value=ImpactType.READ)
    public boolean isActiveFeature(@ManagedDescription(value="Feature name") @ManagedName(value="featureName") String featureName) {
        SettingValue sValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), NAME_SPACES + featureName);
        Boolean active = sValue != null ? Boolean.valueOf(sValue.getValue().toString()) : this.getFeaturePropertyValue(featureName);
        return active == null ? true : active;
    }

    private Boolean getFeaturePropertyValue(String featureName) {
        String propertyName = "exo.feature." + featureName + ".enabled";
        if (this.featuresProperties.containsKey(propertyName)) {
            return this.featuresProperties.get(propertyName);
        }
        String propertyValue = System.getProperty(propertyName);
        Boolean active = propertyValue != null ? Boolean.valueOf(propertyValue) : null;
        this.featuresProperties.put(propertyName, active);
        return active;
    }

    public void saveActiveFeature(String featureName, boolean isActive) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(null), NAME_SPACES + featureName, SettingValue.create((Boolean)isActive));
    }

    @Managed
    @ManagedDescription(value="Activate/Deactivate feature")
    @Impact(value=ImpactType.WRITE)
    public void changeFeatureActivation(@ManagedDescription(value="Feature name") @ManagedName(value="featureName") String featureName, @ManagedDescription(value="Is active") @ManagedName(value="isActive") String isActive) {
        boolean isActiveBool = Boolean.parseBoolean(isActive);
        this.saveActiveFeature(featureName, isActiveBool);
    }

    public void addFeaturePlugin(FeaturePlugin featurePlugin) {
        this.plugins.put(featurePlugin.getName(), featurePlugin);
    }

    public boolean isFeatureActiveForUser(String featureName, String username) {
        if (!this.isActiveFeature(featureName)) {
            return false;
        }
        FeaturePlugin featurePlugin = this.plugins.get(featureName);
        return featurePlugin != null && featurePlugin.isFeatureActiveForUser(featureName, username);
    }
}

