/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.search;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.search.SearchService;

@Path(value="v1/social/search")
@Api(tags={"v1/social/search"}, value="v1/social/search", description="Operations on search connectors")
public class SearchRestResourcesV1
implements ResourceContainer {
    private SearchService searchService;

    public SearchRestResourcesV1(SearchService searchService) {
        this.searchService = searchService;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets search connectors", httpMethod="GET", response=Response.class, produces="application/json", notes="This returns a list of search connectors")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response getConnectors() {
        return Response.ok((Object)this.searchService.getConnectors()).build();
    }

    @PUT
    @Path(value="{connectorName}")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Changes status of search connector", httpMethod="PUT", response=Response.class, notes="This changes the status of a specific search connector")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Not authorized"), @ApiResponse(code=500, message="Internal server error")})
    public Response changeConnectorStatus(@ApiParam(value="Search connector name", required=false) @PathParam(value="connectorName") String connectorName, @ApiParam(value="Search connector status enabled/disabled. possible values: true for enabled, else false", required=true, defaultValue="false") @QueryParam(value="enable") boolean enable) {
        this.searchService.setConnectorAsEnabled(connectorName, enable);
        return Response.noContent().build();
    }
}

