/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.annotation.XmlRootElement;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;

@XmlRootElement
public class IdentityNameList {
    private List<Option> options;

    public List<Option> getOptions() {
        return this.options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public void addOption(Option opt) {
        if (opt == null) {
            throw new IllegalArgumentException("Option can not be NULL");
        }
        if (this.options == null) {
            this.options = new ArrayList<Option>();
        }
        this.options.add(opt);
    }

    public void addToNameList(Locale locale, Identity ... identities) {
        for (Identity identity : identities) {
            String fullName = identity.getProfile().getFullName();
            if (Util.isExternal(identity.getId())) {
                fullName = fullName + " (" + Util.getResourceBundleLabel(locale, "external.label.tag") + ")";
            }
            Option opt = new Option();
            opt.setType("user");
            opt.setText(fullName);
            opt.setValue(identity.getRemoteId());
            opt.setAvatarUrl(identity.getProfile() == null ? null : identity.getProfile().getAvatarUrl());
            this.addOption(opt);
        }
    }

    public static class Option {
        private String type;
        private String value;
        private String text;
        private String avatarUrl;
        private int order;
        private boolean isInvalid;

        public boolean isInvalid() {
            return this.isInvalid;
        }

        public void setInvalid(boolean isInvalid) {
            this.isInvalid = isInvalid;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public void setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
        }
    }
}

