/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.RowType;

public class ExpressionAggregate
extends Expression {
    ArrayType arrayType;

    ExpressionAggregate(int n, boolean bl, Expression expression) {
        super(n);
        this.nodes = new Expression[2];
        this.isDistinctAggregate = bl;
        this.nodes[0] = expression;
        this.nodes[1] = Expression.EXPR_TRUE;
    }

    @Override
    boolean isSelfAggregate() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer(64);
        String string = ExpressionAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 71: {
                stringBuffer.append(' ').append("COUNT").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 72: {
                stringBuffer.append(' ').append("SUM").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 73: {
                stringBuffer.append(' ').append("MIN").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 74: {
                stringBuffer.append(' ').append("MAX").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 75: {
                stringBuffer.append(' ').append("AVG").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 76: {
                stringBuffer.append(' ').append("EVERY").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 77: {
                stringBuffer.append(' ').append("SOME").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 78: {
                stringBuffer.append(' ').append("STDDEV_POP").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 79: {
                stringBuffer.append(' ').append("STDDEV_SAMP").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 80: {
                stringBuffer.append(' ').append("VAR_POP").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 81: {
                stringBuffer.append(' ').append("VAR_SAMP").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        switch (this.opType) {
            case 71: {
                stringBuffer.append("COUNT").append(' ');
                break;
            }
            case 72: {
                stringBuffer.append("SUM").append(' ');
                break;
            }
            case 73: {
                stringBuffer.append("MIN").append(' ');
                break;
            }
            case 74: {
                stringBuffer.append("MAX").append(' ');
                break;
            }
            case 75: {
                stringBuffer.append("AVG").append(' ');
                break;
            }
            case 76: {
                stringBuffer.append("EVERY").append(' ');
                break;
            }
            case 77: {
                stringBuffer.append("SOME").append(' ');
                break;
            }
            case 78: {
                stringBuffer.append("STDDEV_POP").append(' ');
                break;
            }
            case 79: {
                stringBuffer.append("STDDEV_SAMP").append(' ');
                break;
            }
            case 80: {
                stringBuffer.append("VAR_POP").append(' ');
                break;
            }
            case 81: {
                stringBuffer.append("VAR_SAMP").append(' ');
                break;
            }
        }
        if (this.getLeftNode() != null) {
            stringBuffer.append(" arg=[");
            stringBuffer.append(this.nodes[0].describe(session, n + 1));
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, HsqlList hsqlList, boolean bl) {
        HsqlList hsqlList2 = this.nodes[1].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, null, false);
        if (hsqlList2 != null) {
            ExpressionColumn.checkColumnsResolved(hsqlList2);
        }
        if (hsqlList == null) {
            hsqlList = new ArrayListIdentity();
        }
        hsqlList.add(this);
        if (rangeGroup.getRangeVariables().length > 0) {
            this.rangeGroups = rangeGroupArray;
            this.rangeGroup = rangeGroup;
        }
        return hsqlList;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].getDegree() > 1) {
            this.nodes[0].dataType = new RowType(this.nodes[0].nodeDataTypes);
        }
        if (this.nodes[0].isUnresolvedParam()) {
            throw Error.error(5567);
        }
        if (this.isDistinctAggregate) {
            if (this.nodes[0].dataType.isLobType()) {
                throw Error.error(5534);
            }
            if (this.nodes[0].dataType.isCharacterType()) {
                this.arrayType = new ArrayType(this.nodes[0].dataType, Integer.MAX_VALUE);
            }
        }
        this.dataType = SetFunction.getType(session, this.opType, this.nodes[0].dataType);
        this.nodes[1].resolveTypes(session, null);
    }

    @Override
    public boolean equals(Expression expression) {
        if (expression instanceof ExpressionAggregate) {
            ExpressionAggregate expressionAggregate = (ExpressionAggregate)expression;
            return super.equals(expression) && this.isDistinctAggregate == expressionAggregate.isDistinctAggregate;
        }
        return false;
    }

    @Override
    public Object updateAggregatingValue(Session session, Object object) {
        if (!this.nodes[1].testCondition(session)) {
            return object;
        }
        if (object == null) {
            object = new SetFunction(session, this.opType, this.nodes[0].dataType, this.dataType, this.isDistinctAggregate, this.arrayType);
        }
        Integer n = this.nodes[0].opType == 11 ? ValuePool.INTEGER_1 : this.nodes[0].getValue(session);
        ((SetFunction)object).add(session, n);
        return object;
    }

    @Override
    public Object getAggregatedValue(Session session, Object object) {
        if (object == null) {
            return this.opType == 71 ? Long.valueOf(0L) : null;
        }
        return ((SetFunction)object).getValue(session);
    }

    @Override
    public Expression getCondition() {
        return this.nodes[1];
    }

    @Override
    public boolean hasCondition() {
        return !this.nodes[1].isTrue();
    }

    @Override
    public void setCondition(Expression expression) {
        this.nodes[1] = expression;
    }
}

