/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model.textproperties;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hslf.model.textproperties.BitMaskTextProp;
import org.apache.poi.hslf.model.textproperties.CharFlagsTextProp;
import org.apache.poi.hslf.model.textproperties.FontAlignmentProp;
import org.apache.poi.hslf.model.textproperties.ParagraphFlagsTextProp;
import org.apache.poi.hslf.model.textproperties.TabStopPropCollection;
import org.apache.poi.hslf.model.textproperties.TextAlignmentProp;
import org.apache.poi.hslf.model.textproperties.TextProp;
import org.apache.poi.hslf.model.textproperties.WrapFlagsTextProp;
import org.apache.poi.hslf.record.StyleTextPropAtom;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class TextPropCollection {
    public static final TextProp[] paragraphTextPropTypes = new TextProp[]{new ParagraphFlagsTextProp(), new TextProp(2, 128, "bullet.char"), new TextProp(2, 16, "bullet.font"), new TextProp(2, 64, "bullet.size"), new TextProp(4, 32, "bullet.color"), new TextAlignmentProp(), new TextProp(2, 4096, "linespacing"), new TextProp(2, 8192, "spacebefore"), new TextProp(2, 16384, "spaceafter"), new TextProp(2, 256, "text.offset"), new TextProp(2, 1024, "bullet.offset"), new TextProp(2, 32768, "defaultTabSize"), new TabStopPropCollection(), new FontAlignmentProp(), new WrapFlagsTextProp(), new TextProp(2, 0x200000, "textDirection"), new TextProp(0, 0x800000, "bullet.blip"), new TextProp(0, 0x1000000, "bullet.scheme"), new TextProp(0, 0x2000000, "hasBulletScheme")};
    public static final TextProp[] characterTextPropTypes = new TextProp[]{new TextProp(0, 0x100000, "pp10ext"), new TextProp(0, 0x1000000, "newAsian.font.index"), new TextProp(0, 0x2000000, "cs.font.index"), new TextProp(0, 0x4000000, "pp11ext"), new CharFlagsTextProp(), new TextProp(2, 65536, "font.index"), new TextProp(2, 0x200000, "asian.font.index"), new TextProp(2, 0x400000, "ansi.font.index"), new TextProp(2, 0x800000, "symbol.font.index"), new TextProp(2, 131072, "font.size"), new TextProp(4, 262144, "font.color"), new TextProp(2, 524288, "superscript")};
    private int charactersCovered;
    private short indentLevel = 0;
    private final List<TextProp> textPropList = new ArrayList<TextProp>();
    private int maskSpecial = 0;
    private final TextPropType textPropType;

    public TextPropCollection(int charactersCovered, TextPropType textPropType) {
        this.charactersCovered = charactersCovered;
        this.textPropType = textPropType;
    }

    public int getSpecialMask() {
        return this.maskSpecial;
    }

    public int getCharactersCovered() {
        return this.charactersCovered;
    }

    public List<TextProp> getTextPropList() {
        return this.textPropList;
    }

    public TextProp findByName(String textPropName) {
        for (TextProp prop : this.textPropList) {
            if (!prop.getName().equals(textPropName)) continue;
            return prop;
        }
        return null;
    }

    public TextProp removeByName(String name) {
        Iterator<TextProp> iter = this.textPropList.iterator();
        TextProp tp = null;
        while (iter.hasNext()) {
            tp = iter.next();
            if (!tp.getName().equals(name)) continue;
            iter.remove();
            break;
        }
        return tp;
    }

    public TextProp addWithName(String name) {
        TextProp existing = this.findByName(name);
        if (existing != null) {
            return existing;
        }
        TextProp base = null;
        for (TextProp tp : this.getPotentialProperties()) {
            if (!tp.getName().equals(name)) continue;
            base = tp;
            break;
        }
        if (base == null) {
            throw new IllegalArgumentException("No TextProp with name " + name + " is defined to add from. " + "Character and paragraphs have their own properties/names.");
        }
        TextProp textProp = base.clone();
        this.addProp(textProp);
        return textProp;
    }

    public TextPropType getTextPropType() {
        return this.textPropType;
    }

    private TextProp[] getPotentialProperties() {
        return this.textPropType == TextPropType.paragraph ? paragraphTextPropTypes : characterTextPropTypes;
    }

    public void addProp(TextProp textProp) {
        assert (textProp != null);
        int pos = 0;
        boolean found = false;
        for (TextProp curProp : this.getPotentialProperties()) {
            String potName = curProp.getName();
            if (pos == this.textPropList.size() || potName.equals(textProp.getName())) {
                if (this.textPropList.size() > pos && potName.equals(this.textPropList.get(pos).getName())) {
                    this.textPropList.set(pos, textProp);
                } else {
                    this.textPropList.add(pos, textProp);
                }
                found = true;
                break;
            }
            if (!potName.equals(this.textPropList.get(pos).getName())) continue;
            ++pos;
        }
        if (!found) {
            String err = "TextProp with name " + textProp.getName() + " doesn't belong to this collection.";
            throw new IllegalArgumentException(err);
        }
    }

    public int buildTextPropList(int containsField, byte[] data, int dataOffset) {
        int bytesPassed = 0;
        for (TextProp tp : this.getPotentialProperties()) {
            if ((containsField & tp.getMask()) == 0) continue;
            if (dataOffset + bytesPassed >= data.length) {
                this.maskSpecial |= tp.getMask();
                return bytesPassed;
            }
            TextProp prop = tp.clone();
            int val = 0;
            if (prop instanceof TabStopPropCollection) {
                ((TabStopPropCollection)prop).parseProperty(data, dataOffset + bytesPassed);
            } else if (prop.getSize() == 2) {
                val = LittleEndian.getShort((byte[])data, (int)(dataOffset + bytesPassed));
            } else if (prop.getSize() == 4) {
                val = LittleEndian.getInt((byte[])data, (int)(dataOffset + bytesPassed));
            } else if (prop.getSize() == 0) {
                this.maskSpecial |= tp.getMask();
                continue;
            }
            if (prop instanceof BitMaskTextProp) {
                ((BitMaskTextProp)prop).setValueWithMask(val, containsField);
            } else {
                prop.setValue(val);
            }
            bytesPassed += prop.getSize();
            this.addProp(prop);
        }
        return bytesPassed;
    }

    public void copy(TextPropCollection other) {
        if (this == other) {
            return;
        }
        this.charactersCovered = other.charactersCovered;
        this.indentLevel = other.indentLevel;
        this.maskSpecial = other.maskSpecial;
        this.textPropList.clear();
        for (TextProp tp : other.textPropList) {
            TextProp tpCopy = tp instanceof BitMaskTextProp ? ((BitMaskTextProp)tp).cloneAll() : tp.clone();
            this.addProp(tpCopy);
        }
    }

    public void updateTextSize(int textSize) {
        this.charactersCovered = textSize;
    }

    public void writeOut(OutputStream o) throws IOException {
        StyleTextPropAtom.writeLittleEndian(this.charactersCovered, o);
        if (this.textPropType == TextPropType.paragraph && this.indentLevel > -1) {
            StyleTextPropAtom.writeLittleEndian(this.indentLevel, o);
        }
        int mask = this.maskSpecial;
        for (TextProp textProp : this.textPropList) {
            mask |= textProp.getWriteMask();
        }
        StyleTextPropAtom.writeLittleEndian(mask, o);
        for (TextProp potProp : this.getPotentialProperties()) {
            for (TextProp textProp : this.textPropList) {
                if (!textProp.getName().equals(potProp.getName())) continue;
                int val = textProp.getValue();
                if (textProp instanceof BitMaskTextProp && textProp.getWriteMask() == 0) continue;
                if (textProp.getSize() == 2) {
                    StyleTextPropAtom.writeLittleEndian((short)val, o);
                    continue;
                }
                if (textProp.getSize() != 4) continue;
                StyleTextPropAtom.writeLittleEndian(val, o);
            }
        }
    }

    public short getIndentLevel() {
        return this.indentLevel;
    }

    public void setIndentLevel(short indentLevel) {
        if (this.textPropType == TextPropType.character) {
            throw new RuntimeException("trying to set an indent on a character collection.");
        }
        this.indentLevel = indentLevel;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.charactersCovered;
        result = 31 * result + this.maskSpecial;
        result = 31 * result + this.indentLevel;
        result = 31 * result + (this.textPropList == null ? 0 : ((Object)this.textPropList).hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        TextPropCollection o = (TextPropCollection)other;
        if (o.maskSpecial != this.maskSpecial || o.indentLevel != this.indentLevel) {
            return false;
        }
        if (this.textPropList == null) {
            return o.textPropList == null;
        }
        HashMap<String, TextProp> m = new HashMap<String, TextProp>();
        for (TextProp tp : o.textPropList) {
            m.put(tp.getName(), tp);
        }
        for (TextProp tp : this.textPropList) {
            TextProp otp;
            if (tp.equals(otp = (TextProp)m.get(tp.getName()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("  chars covered: " + this.getCharactersCovered());
        out.append("  special mask flags: 0x" + HexDump.toHex((int)this.getSpecialMask()) + "\n");
        if (this.textPropType == TextPropType.paragraph) {
            out.append("  indent level: " + this.getIndentLevel() + "\n");
        }
        for (TextProp p : this.getTextPropList()) {
            out.append("    " + p.getName() + " = " + p.getValue());
            out.append(" (0x" + HexDump.toHex((int)p.getValue()) + ")\n");
            if (!(p instanceof BitMaskTextProp)) continue;
            BitMaskTextProp bm = (BitMaskTextProp)p;
            int i = 0;
            for (String s : bm.getSubPropNames()) {
                if (bm.getSubPropMatches()[i]) {
                    out.append("          " + s + " = " + bm.getSubValue(i) + "\n");
                }
                ++i;
            }
        }
        out.append("  bytes that would be written: \n");
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeOut(baos);
            byte[] b = baos.toByteArray();
            out.append(HexDump.dump((byte[])b, (long)0L, (int)0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    public static enum TextPropType {
        paragraph,
        character;

    }
}

