/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.diff;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ecs.filter.CharacterFilter;
import org.exoplatform.commons.diff.DiffResult;
import org.suigeneris.jrcs.diff.Diff;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;
import org.suigeneris.jrcs.diff.Revision;
import org.suigeneris.jrcs.diff.delta.ChangeDelta;
import org.suigeneris.jrcs.diff.delta.Chunk;
import org.suigeneris.jrcs.diff.delta.Delta;
import org.suigeneris.jrcs.util.ToString;

public class DiffService {
    public List<?> getDifferencesAsList(String text1, String text2) throws DifferentiationFailedException {
        if (text1 == null) {
            text1 = "";
        }
        if (text2 == null) {
            text2 = "";
        }
        return this.getDeltas(Diff.diff((Object[])ToString.stringToArray((String)text1), (Object[])ToString.stringToArray((String)text2)));
    }

    public List<?> getWordDifferencesAsList(String text1, String text2) throws DifferentiationFailedException {
        text1 = text1.replaceAll(" ", "\n");
        text2 = text2.replaceAll(" ", "\n");
        return this.getDeltas(Diff.diff((Object[])ToString.stringToArray((String)text1), (Object[])ToString.stringToArray((String)text2)));
    }

    public DiffResult getWordDifferencesAsHTML(String text1, String text2) throws DifferentiationFailedException {
        int changes = 0;
        text1 = "~~PLACEHOLDER~~" + text1 + "~~PLACEHOLDER~~";
        text2 = "~~PLACEHOLDER~~" + text2 + "~~PLACEHOLDER~~";
        StringBuffer html = new StringBuffer("<div class=\"diffmodifiedline\">");
        List<?> list = this.getWordDifferencesAsList(text1, text2);
        String[] words = StringUtils.splitPreserveAllTokens((String)text1, (char)' ');
        int cursor = 0;
        boolean addSpace = false;
        for (int i = 0; i < list.size(); ++i) {
            Chunk rev;
            if (addSpace) {
                html.append(" ");
                addSpace = false;
            }
            Delta delta = (Delta)list.get(i);
            boolean isChangeDelta = delta instanceof ChangeDelta;
            int position = delta.getOriginal().anchor();
            while (cursor < position) {
                html.append(this.escape(words[cursor]));
                html.append(" ");
                ++cursor;
            }
            Chunk orig = delta.getOriginal();
            if (orig.size() > 0) {
                html.append("<span class=\"diffremoveword\">");
                List chunks = orig.chunk();
                for (int j = 0; j < chunks.size(); ++j) {
                    if (j > 0) {
                        html.append(" ");
                    }
                    html.append(this.escape((String)chunks.get(j)));
                    ++cursor;
                }
                ++changes;
                html.append("</span>");
                addSpace = true;
            }
            if ((rev = delta.getRevised()).size() <= 0) continue;
            html.append("<span class=\"diffaddword\">");
            List chunks = rev.chunk();
            for (int j = 0; j < chunks.size(); ++j) {
                if (j > 0) {
                    html.append(" ");
                }
                html.append(this.escape((String)chunks.get(j)));
            }
            if (!isChangeDelta) {
                ++changes;
            }
            html.append("</span>");
            addSpace = true;
        }
        while (cursor < words.length) {
            if (addSpace) {
                html.append(" ");
            }
            html.append(this.escape(words[cursor]));
            addSpace = true;
            ++cursor;
        }
        html.append("</div>");
        return new DiffResult(html.toString().replaceAll("~~PLACEHOLDER~~", ""), changes);
    }

    public DiffResult getDifferencesAsHTML(String text1, String text2, boolean allDoc) throws DifferentiationFailedException {
        StringBuffer html = new StringBuffer("<div class=\"diff\">");
        int changes = 0;
        if (text1 == null) {
            text1 = "";
        }
        if (text2 == null) {
            text2 = "";
        }
        List<?> list = this.getDifferencesAsList(text1, text2);
        String[] lines = ToString.stringToArray((String)text1);
        int cursor = 0;
        boolean addBR = false;
        for (int i = 0; i < list.size(); ++i) {
            List chunks;
            if (addBR) {
                addBR = false;
            }
            Delta delta = (Delta)list.get(i);
            int position = delta.getOriginal().anchor();
            while (cursor < position) {
                if (allDoc) {
                    html.append("<div class=\"diffunmodifiedline\">");
                    String text = this.escape(lines[cursor]);
                    if (text.equals("")) {
                        text = "&nbsp;";
                    }
                    html.append(text);
                    html.append("</div>");
                }
                ++cursor;
            }
            Chunk orig = delta.getOriginal();
            Chunk rev = delta.getRevised();
            if (orig.size() > 0) {
                chunks = orig.chunk();
                int j2 = 0;
                for (int j = 0; j < chunks.size(); ++j) {
                    String origline = (String)chunks.get(j);
                    List revchunks = rev.chunk();
                    String revline = "";
                    while ("".equals(revline)) {
                        revline = j2 >= revchunks.size() ? null : (String)revchunks.get(j2);
                        ++j2;
                    }
                    if (revline != null) {
                        DiffResult diffLine = this.getWordDifferencesAsHTML(origline, revline);
                        html.append(diffLine.getDiffHTML());
                        rev.chunk().remove(revline);
                        changes += diffLine.getChanges();
                    } else {
                        html.append("<div class=\"diffmodifiedline\">");
                        if (origline.equals("")) {
                            html.append("<pre class=\"diffremoveword\">");
                            html.append("&nbsp;");
                            html.append("</pre>");
                        } else {
                            html.append("<span class=\"diffremoveword\">");
                            html.append(this.escape(origline));
                            html.append("</span>");
                        }
                        html.append("</div>");
                        ++changes;
                    }
                    addBR = true;
                    ++cursor;
                }
            }
            if (rev.size() <= 0) continue;
            chunks = rev.chunk();
            for (int j = 0; j < chunks.size(); ++j) {
                String revline = (String)chunks.get(j);
                html.append("<div class=\"diffmodifiedline\">");
                if (revline.equals("")) {
                    html.append("<pre class=\"diffaddword\">");
                    html.append("</pre>");
                } else {
                    html.append("<span class=\"diffaddword\">");
                    html.append(this.escape(revline));
                    html.append("</span>");
                }
                html.append("</div>");
                ++changes;
            }
            addBR = true;
        }
        if (allDoc) {
            while (cursor < lines.length) {
                html.append("<div class=\"diffunmodifiedline\">");
                String text = this.escape(lines[cursor]);
                if (text.equals("")) {
                    text = "&nbsp;";
                }
                html.append(text);
                html.append("</div>");
                ++cursor;
            }
        }
        html.append("</div>");
        return new DiffResult(html.toString(), changes);
    }

    protected List<?> getDeltas(Revision rev) {
        ArrayList<Delta> list = new ArrayList<Delta>();
        for (int i = 0; i < rev.size(); ++i) {
            list.add(rev.getDelta(i));
        }
        return list;
    }

    protected String escape(String text) {
        CharacterFilter filter = new CharacterFilter();
        String scontent = filter.process(text);
        return scontent;
    }
}

