/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.data;

import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.data.OwnerKey;

public class PageKey
extends OwnerKey {
    private final String name;

    public PageKey(String type, String id, String name) {
        super(type, id);
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PageKey) {
            PageKey that = (PageKey)obj;
            return super.equals(that) && this.name.equals(that.name);
        }
        return false;
    }

    public static PageKey create(String compositeId) {
        if (compositeId == null) {
            throw new NullPointerException();
        }
        String[] components = Utils.split("::", compositeId);
        if (components.length != 3) {
            throw new IllegalArgumentException("Wrong page id key format " + compositeId);
        }
        return new PageKey(components[0], components[1], components[2]);
    }

    public String toString() {
        return "PageKey[type=" + this.getType() + ",id=" + this.getId() + ",name=" + this.name + "]";
    }
}

