/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model.textproperties;

public class TextProp
implements Cloneable {
    protected int sizeOfDataBlock;
    protected String propName;
    protected int dataValue;
    protected int maskInHeader;

    public TextProp(int sizeOfDataBlock, int maskInHeader, String propName) {
        this.sizeOfDataBlock = sizeOfDataBlock;
        this.maskInHeader = maskInHeader;
        this.propName = propName;
        this.dataValue = 0;
    }

    public TextProp(TextProp other) {
        this.sizeOfDataBlock = other.sizeOfDataBlock;
        this.maskInHeader = other.maskInHeader;
        this.propName = other.propName;
        this.dataValue = other.dataValue;
    }

    public String getName() {
        return this.propName;
    }

    public int getSize() {
        return this.sizeOfDataBlock;
    }

    public int getMask() {
        return this.maskInHeader;
    }

    public int getWriteMask() {
        return this.getMask();
    }

    public int getValue() {
        return this.dataValue;
    }

    public void setValue(int val) {
        this.dataValue = val;
    }

    public TextProp clone() {
        try {
            return (TextProp)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dataValue;
        result = 31 * result + this.maskInHeader;
        result = 31 * result + (this.propName == null ? 0 : this.propName.hashCode());
        result = 31 * result + this.sizeOfDataBlock;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextProp other = (TextProp)obj;
        if (this.dataValue != other.dataValue) {
            return false;
        }
        if (this.maskInHeader != other.maskInHeader) {
            return false;
        }
        if (this.propName == null ? other.propName != null : !this.propName.equals(other.propName)) {
            return false;
        }
        return this.sizeOfDataBlock == other.sizeOfDataBlock;
    }
}

