/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.cache.future.FutureMap;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.controller.QualifiedName;
import org.gatein.common.io.IOTools;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.ScriptKey;
import org.gatein.portal.controller.resource.ScriptLoader;
import org.gatein.portal.controller.resource.ScriptResult;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;

public class ResourceRequestHandler
extends WebRequestHandler
implements WebAppListener {
    public static final String HANDLER_NAME = "script";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String SUPPORT_GATEIN_RESOURCES = "org.gatein.supports.gatein-resources.";
    private static String PATH = "META-INF/maven/org.exoplatform.gatein.portal/exo.portal.component.web.resources/pom.properties";
    private static final Logger log = LoggerFactory.getLogger(ResourceRequestHandler.class);
    public static final String VERSION;
    public static final long MAX_AGE;
    public static final QualifiedName VERSION_QN;
    public static final QualifiedName RESOURCE_QN;
    public static final QualifiedName SCOPE_QN;
    public static final QualifiedName COMPRESS_QN;
    public static final QualifiedName ORIENTATION_QN;
    public static final QualifiedName LANG_QN;
    private final FutureMap<ScriptKey, ScriptResult, ControllerContext> cache;
    private final ScriptLoader loader = new ScriptLoader();

    public ResourceRequestHandler() {
        this.cache = new FutureMap((Loader)this.loader);
    }

    public String getHandlerName() {
        return HANDLER_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ControllerContext context) throws Exception {
        String resourceParam = context.getParameter(RESOURCE_QN);
        String scopeParam = context.getParameter(SCOPE_QN);
        if (scopeParam != null && resourceParam != null) {
            ResourceScope scope;
            String compressParam = context.getParameter(COMPRESS_QN);
            String lang = context.getParameter(LANG_QN);
            Locale locale = null;
            if (lang != null && lang.length() > 0) {
                locale = I18N.parseTagIdentifier((String)lang);
            }
            try {
                scope = ResourceScope.valueOf(ResourceScope.class, scopeParam);
            }
            catch (IllegalArgumentException e) {
                HttpServletResponse response = context.getResponse();
                String msg = "Unrecognized scope " + scopeParam;
                log.error((Object)msg);
                response.sendError(400, msg);
                return true;
            }
            ResourceId resource = new ResourceId(scope, resourceParam);
            ScriptKey key = new ScriptKey(resource, "min".equals(compressParam), locale);
            ScriptResult result = PropertyManager.isDevelopping() ? this.loader.retrieve(context, key) : (ScriptResult)this.cache.get((Object)context, (Object)key);
            HttpServletResponse response = context.getResponse();
            HttpServletRequest request = context.getRequest();
            if (result instanceof ScriptResult.Resolved) {
                ScriptResult.Resolved resolved = (ScriptResult.Resolved)result;
                response.setContentType("text/javascript");
                response.setCharacterEncoding("UTF-8");
                response.setHeader("Cache-Control", "max-age=" + MAX_AGE + ",s-maxage=" + MAX_AGE);
                response.setDateHeader("Expires", System.currentTimeMillis() + MAX_AGE * 1000L);
                response.setContentLength(resolved.bytes.length);
                long ifModifiedSince = request.getDateHeader(IF_MODIFIED_SINCE);
                if (resolved.isModified(ifModifiedSince)) {
                    response.setDateHeader(LAST_MODIFIED, resolved.lastModified);
                    ServletOutputStream out = response.getOutputStream();
                    try {
                        out.write(resolved.bytes);
                    }
                    finally {
                        Safe.close((Closeable)out);
                    }
                } else {
                    response.setStatus(304);
                }
            } else if (result instanceof ScriptResult.Error) {
                ScriptResult.Error error = (ScriptResult.Error)result;
                log.error((Object)("Could not render script " + key + "\n:" + error.message));
                response.sendError(500);
            } else {
                String msg = "Resource " + key + " cannot be found";
                log.error((Object)msg);
                response.sendError(404, msg);
            }
        } else {
            HttpServletResponse response = context.getResponse();
            String msg = "Missing scope or resource param";
            log.error((Object)msg);
            response.sendError(400, msg);
        }
        return true;
    }

    protected boolean getRequiresLifeCycle() {
        return false;
    }

    public void onInit(WebAppController controller, ServletConfig sConfig) throws Exception {
        super.onInit(controller, sConfig);
        log.debug((Object)"Registering ResourceRequestHandler for servlet container events");
        ServletContainerFactory.getServletContainer().addWebAppListener((WebAppListener)this);
    }

    public void onDestroy(WebAppController controller) {
        super.onDestroy(controller);
        log.debug((Object)"Unregistering ResourceRequestHandler for servlet container events");
        ServletContainerFactory.getServletContainer().removeWebAppListener((WebAppListener)this);
    }

    public void onEvent(WebAppEvent event) {
        if (event instanceof WebAppLifeCycleEvent) {
            WebAppLifeCycleEvent lifeCycleEvent = (WebAppLifeCycleEvent)event;
            ServletContext servletContext = lifeCycleEvent.getWebApp().getServletContext();
            if (1 == lifeCycleEvent.getType()) {
                InputStream is = servletContext.getResourceAsStream("/WEB-INF/gatein-resources.xml");
                if (is != null) {
                    servletContext.setAttribute(SUPPORT_GATEIN_RESOURCES, (Object)true);
                }
            } else if (servletContext.getAttribute(SUPPORT_GATEIN_RESOURCES) != null && 0 == lifeCycleEvent.getType()) {
                this.cache.clear();
                servletContext.removeAttribute(SUPPORT_GATEIN_RESOURCES);
            }
        }
    }

    public Collection<String> getJavascriptModules() {
        ArrayList<String> keys = new ArrayList<String>();
        Set cacheKeys = this.cache.getKeys();
        for (ScriptKey scriptKey : cacheKeys) {
            keys.add(scriptKey.id.toString());
        }
        return keys;
    }

    public void reloadJavascriptModules() {
        this.cache.clear();
    }

    public void reloadJavascriptModule(String jsModule) {
        String[] scriptIdParts = jsModule.split("/");
        if (scriptIdParts.length != 2) {
            throw new IllegalArgumentException("js module have to be identified by 'SCOPE/id' like 'SHARED/jquery' ");
        }
        ResourceScope scope = ResourceScope.valueOf(ResourceScope.class, scriptIdParts[0]);
        ResourceId resource = new ResourceId(scope, scriptIdParts[1]);
        LocaleConfigService localeService = (LocaleConfigService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LocaleConfigService.class);
        Collection localConfigs = localeService.getLocalConfigs();
        for (LocaleConfig localeConfig : localConfigs) {
            ScriptKey key = new ScriptKey(resource, true, localeConfig.getLocale());
            this.cache.remove((Serializable)key);
        }
        ScriptKey key = new ScriptKey(resource, true, null);
        this.cache.remove((Serializable)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String version = "";
        String property = PropertyManager.getProperty((String)"gatein.assets.version");
        if (property != null && !property.isEmpty()) {
            version = property;
        } else {
            URL url = ResourceRequestHandler.class.getClassLoader().getResource(PATH);
            if (url != null) {
                log.debug((Object)("Loading resource serving version from " + url));
                InputStream in = null;
                try {
                    in = url.openStream();
                    Properties props = new Properties();
                    props.load(in);
                    version = props.getProperty("version");
                }
                catch (IOException e) {
                    log.error((Object)("Could not read properties from " + url), (Throwable)e);
                }
                finally {
                    IOTools.safeClose((Closeable)in);
                }
            }
        }
        log.info((Object)("Use version \"" + version + "\" for resource serving"));
        VERSION = version;
        long seconds = 604800L;
        String propValue = PropertyManager.getProperty((String)"gatein.assets.script.max-age");
        if (StringUtils.isNotBlank((CharSequence)propValue)) {
            try {
                seconds = Long.valueOf(propValue);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"The gatein.assets.script.max-age property is not set properly.");
            }
        }
        MAX_AGE = seconds;
        VERSION_QN = QualifiedName.create((String)"gtn", (String)"version");
        RESOURCE_QN = QualifiedName.create((String)"gtn", (String)"resource");
        SCOPE_QN = QualifiedName.create((String)"gtn", (String)"scope");
        COMPRESS_QN = QualifiedName.create((String)"gtn", (String)"compress");
        ORIENTATION_QN = QualifiedName.create((String)"gtn", (String)"orientation");
        LANG_QN = QualifiedName.create((String)"gtn", (String)"lang");
    }
}

