/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.MediaQuery;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class Media
extends ASTCssNode
implements BodyOwner<GeneralBody> {
    private List<MediaQuery> mediums;
    private GeneralBody body;

    public Media(HiddenTokenAwareTree token) {
        super(token);
    }

    public void addMediaQuery(MediaQuery medium) {
        if (this.mediums == null) {
            this.mediums = new ArrayList<MediaQuery>();
        }
        this.mediums.add(medium);
    }

    public List<MediaQuery> getMediums() {
        return this.mediums;
    }

    public void setMediums(List<MediaQuery> mediums) {
        this.mediums = mediums;
    }

    public void replaceMediaQueries(List<MediaQuery> result) {
        for (MediaQuery oldMediums : this.mediums) {
            oldMediums.setParent(null);
        }
        this.mediums = new ArrayList<MediaQuery>();
        this.mediums.addAll(result);
    }

    @NotAstProperty
    public List<ASTCssNode> getChilds() {
        ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>();
        childs.addAll(this.mediums);
        childs.add(this.body);
        return childs;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.MEDIA;
    }

    @Override
    public Media clone() {
        Media result = (Media)super.clone();
        result.mediums = ArraysUtils.deeplyClonedList(this.mediums);
        result.body = this.body == null ? null : this.body.clone();
        result.configureParentToAllChilds();
        return result;
    }

    @Override
    public void setBody(GeneralBody body) {
        this.body = body;
    }

    @Override
    public GeneralBody getBody() {
        return this.body;
    }
}

