/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.perkstore.entity.ProductEntity;
import org.exoplatform.perkstore.model.constant.ProductOrderStatus;
import org.exoplatform.perkstore.model.constant.ProductOrderTransactionStatus;

@Entity(name="Order")
@ExoEntity
@Table(name="ADDONS_PERKSTORE_PRODUCT_ORDER")
@NamedQueries(value={@NamedQuery(name="Order.getAllProductOrders", query="SELECT distinct(o) FROM Order o WHERE o.product.id = :productId ORDER BY o.createdDate DESC"), @NamedQuery(name="Order.countOrderedQuantityByProductId", query="SELECT SUM(o.quantity) FROM Order o WHERE o.product.id = :productId"), @NamedQuery(name="Order.countRefundedQuantityByProductId", query="SELECT SUM(o.refundedQuantity) FROM Order o WHERE o.product.id = :productId"), @NamedQuery(name="Order.countOrderedQuantityByProductIdAndStatus", query="SELECT SUM(o.quantity) FROM Order o WHERE o.product.id = :productId AND o.status = :status"), @NamedQuery(name="Order.countRemainingOrdersByProductId", query="SELECT COUNT(o) FROM Order o WHERE o.product.id = :productId AND o.remainingQuantity > 0"), @NamedQuery(name="Order.countRemainingOrdersByIdentityIdAndProductId", query="SELECT COUNT(o) FROM Order o WHERE o.product.id = :productId AND o.senderId = :identityId AND o.remainingQuantity > 0"), @NamedQuery(name="Order.countUserTotalPurchasedQuantity", query="SELECT SUM(o.quantity) FROM Order o WHERE o.product.id = :productId AND o.senderId = :identityId"), @NamedQuery(name="Order.countUserTotalRefundedQuantity", query="SELECT SUM(o.refundedQuantity) FROM Order o WHERE o.product.id = :productId AND o.senderId = :identityId"), @NamedQuery(name="Order.countUserTotalOrderedQuantityByStatus", query="SELECT SUM(o.quantity) FROM Order o WHERE o.product.id = :productId AND o.senderId = :identityId AND o.status = :status"), @NamedQuery(name="Order.countUserPurchasedQuantityInPeriod", query="SELECT SUM(o.quantity) FROM Order o WHERE o.product.id = :productId AND o.senderId = :identityId AND o.createdDate > :from AND o.createdDate < :to"), @NamedQuery(name="Order.countUserRefundedQuantityInPeriod", query="SELECT SUM(o.refundedQuantity) FROM Order o WHERE o.product.id = :productId AND o.senderId = :identityId AND o.createdDate > :from AND o.createdDate < :to"), @NamedQuery(name="Order.countUserOrderedQuantityByStatusInPeriod", query="SELECT SUM(o.quantity) FROM Order o WHERE o.product.id = :productId AND o.senderId = :identityId AND o.status = :status AND o.createdDate > :from AND o.createdDate < :to"), @NamedQuery(name="Order.findOrderByTransactionHash", query="SELECT distinct(o) FROM Order o WHERE o.transactionHash = :hash"), @NamedQuery(name="Order.findOrderByRefundTransactionHash", query="SELECT distinct(o) FROM Order o WHERE o.refundTransactionHash = :hash")})
public class ProductOrderEntity
implements Serializable {
    private static final long serialVersionUID = -592052513482849972L;
    @Id
    @SequenceGenerator(name="SEQ_ADDONS_PERKSTORE_PRODUCT_ORDER_ID", sequenceName="SEQ_ADDONS_PERKSTORE_PRODUCT_ORDER_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_ADDONS_PERKSTORE_PRODUCT_ORDER_ID")
    @Column(name="ORDER_ID")
    private Long id;
    @Column(name="TRANSACTION_HASH", nullable=true)
    private String transactionHash;
    @Column(name="REFUND_TRANSACTION_HASH", nullable=true)
    private String refundTransactionHash;
    @Column(name="QUANTITY", nullable=false)
    private double quantity;
    @Column(name="AMOUNT", nullable=true)
    private double amount;
    @Column(name="REFUNDED_AMOUNT", nullable=true)
    private double refundedAmount;
    @Column(name="SENDER_ID", nullable=false)
    private long senderId;
    @Column(name="RECEIVER_ID", nullable=false)
    private long receiverId;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="STATUS", nullable=false)
    private ProductOrderStatus status;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="TX_STATUS", nullable=false)
    private ProductOrderTransactionStatus transactionStatus;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="REFUND_TX_STATUS", nullable=false)
    private ProductOrderTransactionStatus refundTransactionStatus;
    @Column(name="DELIVERED_QUANTITY", nullable=true)
    private double deliveredQuantity;
    @Column(name="REFUNDED_QUANTITY", nullable=true)
    private double refundedQuantity;
    @Column(name="REMAINING_QUANTITY", nullable=true)
    private double remainingQuantity;
    @Column(name="CREATED_DATE", nullable=false)
    private long createdDate;
    @Column(name="DELIVERED_DATE", nullable=true)
    private long deliveredDate;
    @Column(name="REFUNDED_DATE", nullable=true)
    private long refundedDate;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @JoinColumn(name="PRODUCT_ID", referencedColumnName="PRODUCT_ID")
    private ProductEntity product;
    @Column(name="ERROR_CODE")
    private int errorCode;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public double getRefundedAmount() {
        return this.refundedAmount;
    }

    public void setRefundedAmount(double refundedAmount) {
        this.refundedAmount = refundedAmount;
    }

    public long getSenderId() {
        return this.senderId;
    }

    public void setSenderId(long senderId) {
        this.senderId = senderId;
    }

    public long getReceiverId() {
        return this.receiverId;
    }

    public void setReceiverId(long receiverId) {
        this.receiverId = receiverId;
    }

    public ProductOrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProductOrderStatus status) {
        this.status = status;
    }

    public double getDeliveredQuantity() {
        return this.deliveredQuantity;
    }

    public void setDeliveredQuantity(double deliveredQuantity) {
        this.deliveredQuantity = deliveredQuantity;
    }

    public double getRefundedQuantity() {
        return this.refundedQuantity;
    }

    public String getRefundTransactionHash() {
        return this.refundTransactionHash;
    }

    public void setRefundTransactionHash(String refundTransactionHash) {
        this.refundTransactionHash = refundTransactionHash;
    }

    public ProductOrderTransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(ProductOrderTransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public ProductOrderTransactionStatus getRefundTransactionStatus() {
        return this.refundTransactionStatus;
    }

    public void setRefundTransactionStatus(ProductOrderTransactionStatus refundTransactionStatus) {
        this.refundTransactionStatus = refundTransactionStatus;
    }

    public void setRefundedQuantity(double refundedQuantity) {
        this.refundedQuantity = refundedQuantity;
    }

    public double getRemainingQuantity() {
        return this.remainingQuantity;
    }

    public void setRemainingQuantity(double remainingQuantity) {
        this.remainingQuantity = remainingQuantity;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(long createdDate) {
        this.createdDate = createdDate;
    }

    public long getDeliveredDate() {
        return this.deliveredDate;
    }

    public void setDeliveredDate(long deliveredDate) {
        this.deliveredDate = deliveredDate;
    }

    public long getRefundedDate() {
        return this.refundedDate;
    }

    public void setRefundedDate(long refundedDate) {
        this.refundedDate = refundedDate;
    }

    public ProductEntity getProduct() {
        return this.product;
    }

    public void setProduct(ProductEntity product) {
        this.product = product;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }
}

