/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.j2ee;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.plus.jaas.callback.ObjectCallback;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.j2ee.JettyLoginModule;

public class DigestAuthenticationJettyLoginModule
extends JettyLoginModule {
    private Callback[] objectCallback = new Callback[]{new ObjectCallback()};

    @Override
    public boolean login() throws LoginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"In login of JettyLoginModule.");
        }
        try {
            if (this.sharedState.containsKey("exo.security.identity")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Use Identity from previous LoginModule");
                }
                this.identity = (Identity)this.sharedState.get("exo.security.identity");
            } else {
                Authenticator authenticator;
                if (!this.digestAuthenticationIsUsed()) {
                    return super.login();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Try create identity");
                }
                if ((authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class)) == null) {
                    throw new LoginException("No Authenticator component found, check your configuration");
                }
                String userId = authenticator.validateUser(this.getCredentials());
                this.identity = authenticator.createIdentity(userId);
                this.sharedState.put("javax.security.auth.login.name", userId);
                this.subject.getPrivateCredentials().add(this.getPassword());
                this.subject.getPublicCredentials().add(this.getUsername());
            }
            return true;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new LoginException(e.getMessage());
        }
    }

    private boolean digestAuthenticationIsUsed() throws IOException, UnsupportedCallbackException {
        this.callbackHandler.handle(this.objectCallback);
        return !(((ObjectCallback)this.objectCallback[0]).getObject() instanceof String);
    }

    private Credential[] getCredentials() {
        String password;
        String username;
        HashMap<String, String> passwordContext;
        block10: {
            passwordContext = new HashMap<String, String>();
            HashSet<String> contextElements = new HashSet<String>();
            Object objectFromCallback = ((ObjectCallback)this.objectCallback[0]).getObject();
            username = null;
            password = null;
            Class<?> digestAuthenticatorClazz = DigestAuthenticator.class.getDeclaredClasses()[0];
            contextElements.add("cnonce");
            contextElements.add("method");
            contextElements.add("nc");
            contextElements.add("nonce");
            contextElements.add("qop");
            contextElements.add("realm");
            contextElements.add("uri");
            try {
                Field field;
                for (String element : contextElements) {
                    field = digestAuthenticatorClazz.getDeclaredField(element);
                    field.setAccessible(true);
                    passwordContext.put(element, (String)field.get(objectFromCallback));
                }
                field = digestAuthenticatorClazz.getDeclaredField("username");
                field.setAccessible(true);
                username = (String)field.get(objectFromCallback);
                field = digestAuthenticatorClazz.getDeclaredField("response");
                field.setAccessible(true);
                password = (String)field.get(objectFromCallback);
            }
            catch (IllegalArgumentException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Could not get credentials.", (Throwable)e);
                }
            }
            catch (NoSuchFieldException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Could not get credentials.", (Throwable)e);
                }
            }
            catch (SecurityException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Could not get credentials.", (Throwable)e);
                }
            }
            catch (IllegalAccessException e) {
                if (!LOG.isErrorEnabled()) break block10;
                LOG.error((Object)"Could not get credentials.", (Throwable)e);
            }
        }
        if (username == null || password == null) {
            return null;
        }
        return new Credential[]{new UsernameCredential(username), new PasswordCredential(password, passwordContext)};
    }

    private UsernameCredential getUsername() {
        String username;
        block8: {
            username = null;
            Class<?> digestAuthenticatorClazz = DigestAuthenticator.class.getDeclaredClasses()[0];
            try {
                Field field = digestAuthenticatorClazz.getDeclaredField("username");
                field.setAccessible(true);
                username = (String)field.get(((ObjectCallback)this.objectCallback[0]).getObject());
            }
            catch (IllegalArgumentException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Could not get username.", (Throwable)e);
                }
            }
            catch (IllegalAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Could not get username.", (Throwable)e);
                }
            }
            catch (NoSuchFieldException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Could not get username.", (Throwable)e);
                }
            }
            catch (SecurityException e) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error((Object)"Could not get username.", (Throwable)e);
            }
        }
        return new UsernameCredential(username);
    }

    private String getPassword() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String password;
        block8: {
            password = null;
            Class<?> digestAuthenticatorClazz = DigestAuthenticator.class.getDeclaredClasses()[0];
            try {
                Field field = digestAuthenticatorClazz.getDeclaredField("response");
                field.setAccessible(true);
                password = (String)field.get(((ObjectCallback)this.objectCallback[0]).getObject());
            }
            catch (IllegalArgumentException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Could not get password.", (Throwable)e);
                }
            }
            catch (IllegalAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Could not get password.", (Throwable)e);
                }
            }
            catch (NoSuchFieldException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Could not get password.", (Throwable)e);
                }
            }
            catch (SecurityException e) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error((Object)"Could not get password.", (Throwable)e);
            }
        }
        return password;
    }
}

