/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.NodeVisitor;

public class Nodes {
    private static final NodeVisitor NONE = new DepthVisitor(0);
    private static final NodeVisitor CHILDREN = new DepthVisitor(1);
    public static final NodeVisitor ALL = new DepthVisitor(-1);

    public static List<Node> asList(Node node) {
        ArrayList<Node> l = new ArrayList<Node>(node.getChildCount());
        for (Node c : node) {
            l.add(c);
        }
        return Collections.unmodifiableList(l);
    }

    public static NodeVisitor visitNone() {
        return Nodes.visitNodes(0);
    }

    public static NodeVisitor visitChildren() {
        return Nodes.visitNodes(1);
    }

    public static NodeVisitor visitAll() {
        return Nodes.visitNodes(-1);
    }

    public static NodeVisitor visitNodes(int depth) {
        if (depth == 0) {
            return NONE;
        }
        if (depth == 1) {
            return CHILDREN;
        }
        if (depth < 0) {
            return ALL;
        }
        return new DepthVisitor(depth);
    }

    public static NodeVisitor visitNodes(NodePath path) {
        return Nodes.visitNodes(path, Nodes.visitNodes(0));
    }

    public static NodeVisitor visitNodes(NodePath path, NodeVisitor visitor) {
        return new DelegatingPathVisitor(path, visitor);
    }

    private Nodes() {
    }

    private static class DelegatingPathVisitor
    implements NodeVisitor {
        private final NodePath path;
        private final NodeVisitor visitor;

        public DelegatingPathVisitor(NodePath path, NodeVisitor visitor) {
            this.path = path;
            this.visitor = visitor;
        }

        @Override
        public boolean visit(int depth, String name, NodeVisitor.NodeDetails details) {
            if (depth < this.path.size()) {
                return depth == 0 || this.path.getSegment(depth - 1).equals(name);
            }
            if (depth == this.path.size()) {
                if (depth == 0 || this.path.getSegment(depth - 1).equals(name)) {
                    return this.visitor.visit(0, name, details);
                }
                return false;
            }
            return this.visitor.visit(depth - this.path.size(), name, details);
        }
    }

    private static class DepthVisitor
    implements NodeVisitor {
        private final int height;

        public DepthVisitor(int height) {
            this.height = height;
        }

        @Override
        public boolean visit(int depth, String name, NodeVisitor.NodeDetails details) {
            return this.height < 0 || depth < this.height;
        }
    }
}

