/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.dlp.job;

import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.dlp.processor.DlpOperationProcessor;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

@DisallowConcurrentExecution
public class DlpJob
implements InterruptableJob {
    private static final Log LOGGER = ExoLogger.getExoLogger(DlpJob.class);
    private DlpOperationProcessor dlpOperationProcessor;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoFeatureService featureService = (ExoFeatureService)CommonsUtils.getService(ExoFeatureService.class);
        if (featureService.isActiveFeature("dlp")) {
            LOGGER.debug((Object)"Running dlp job");
            this.getDlpOperationProcessor().process();
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        LOGGER.debug((Object)"Interrupting dlp job");
        this.getDlpOperationProcessor().interrupt();
    }

    private DlpOperationProcessor getDlpOperationProcessor() {
        if (this.dlpOperationProcessor == null) {
            this.dlpOperationProcessor = (DlpOperationProcessor)CommonsUtils.getService(DlpOperationProcessor.class);
        }
        return this.dlpOperationProcessor;
    }
}

