/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.dlp.processor;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.dlp.connector.DlpServiceConnector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class DlpOperationProcessor {
    private static final Log LOGGER = ExoLogger.getExoLogger(DlpOperationProcessor.class);
    public static final String DLP_FEATURE = "dlp";
    private Map<String, DlpServiceConnector> connectors = new HashMap<String, DlpServiceConnector>();

    public void addConnector(DlpServiceConnector dlpServiceConnector) {
        this.addConnector(dlpServiceConnector, false);
    }

    public void addConnector(DlpServiceConnector dlpServiceConnector, Boolean override) {
        if (this.connectors.containsKey(dlpServiceConnector.getType()) && override.equals(false)) {
            LOGGER.error("Impossible to add connector {}. A connector with the same name has already been registered.", new Object[]{dlpServiceConnector.getType()});
        } else {
            this.connectors.put(dlpServiceConnector.getType(), dlpServiceConnector);
            LOGGER.info("A Dlp Connector has been added: {}", new Object[]{dlpServiceConnector.getType()});
        }
    }

    public Map<String, DlpServiceConnector> getConnectors() {
        return this.connectors;
    }

    public abstract void process();

    public abstract void interrupt();
}

