/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.htmlcleaner.AttributeTransformation;
import org.htmlcleaner.AttributeTransformationPatternImpl;
import org.htmlcleaner.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagTransformation {
    public static String VAR_START = "${";
    public static String VAR_END = "}";
    private String sourceTag;
    private String destTag;
    private boolean preserveSourceAttributes;
    private Map<String, String> attributeTransformations = new LinkedHashMap<String, String>();
    private List<AttributeTransformation> attributePatternTransformations = new ArrayList<AttributeTransformation>();

    public TagTransformation() {
        this.preserveSourceAttributes = true;
    }

    public TagTransformation(String sourceTag, String destTag, boolean preserveSourceAttributes) {
        this.sourceTag = sourceTag.toLowerCase();
        this.destTag = destTag == null ? null : (Utils.isValidXmlIdentifier(destTag) ? destTag.toLowerCase() : sourceTag);
        this.preserveSourceAttributes = preserveSourceAttributes;
    }

    public TagTransformation(String sourceTag, String destTag) {
        this(sourceTag, destTag, true);
    }

    public TagTransformation(String sourceTag) {
        this(sourceTag, null);
    }

    public void addAttributeTransformation(String targetAttName, String transformationDesc) {
        this.attributeTransformations.put(targetAttName.toLowerCase(), transformationDesc);
    }

    public void addAttributePatternTransformation(Pattern attNamePattern, String transformationDesc) {
        this.attributePatternTransformations.add(new AttributeTransformationPatternImpl(attNamePattern, null, transformationDesc));
    }

    public void addAttributePatternTransformation(Pattern attNamePattern, Pattern attValuePattern, String transformationDesc) {
        this.addAttributePatternTransformation(new AttributeTransformationPatternImpl(attNamePattern, attValuePattern, transformationDesc));
    }

    public void addAttributePatternTransformation(AttributeTransformation attributeTransformation) {
        if (this.attributePatternTransformations == null) {
            this.attributePatternTransformations = new ArrayList<AttributeTransformation>();
        }
        this.attributePatternTransformations.add(attributeTransformation);
    }

    public void addAttributeTransformation(String targetAttName) {
        this.addAttributeTransformation(targetAttName, null);
    }

    boolean hasAttributeTransformations() {
        return this.attributeTransformations != null || this.attributePatternTransformations != null;
    }

    String getSourceTag() {
        return this.sourceTag;
    }

    String getDestTag() {
        return this.destTag;
    }

    boolean isPreserveSourceAttributes() {
        return this.preserveSourceAttributes;
    }

    Map<String, String> getAttributeTransformations() {
        return this.attributeTransformations;
    }

    public Map<String, String> applyTagTransformations(Map<String, String> attributes) {
        boolean isPreserveSourceAtts = this.isPreserveSourceAttributes();
        boolean hasAttTransforms = this.hasAttributeTransformations();
        if (hasAttTransforms || !isPreserveSourceAtts) {
            LinkedHashMap<String, String> newAttributes;
            LinkedHashMap<String, String> linkedHashMap = newAttributes = isPreserveSourceAtts ? new LinkedHashMap<String, String>(attributes) : new LinkedHashMap();
            if (hasAttTransforms) {
                Map<String, String> map = this.getAttributeTransformations();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String attName = entry.getKey();
                    String template = entry.getValue();
                    if (template == null) {
                        newAttributes.remove(attName);
                        continue;
                    }
                    String attValue = this.evaluateTemplate(template, attributes);
                    newAttributes.put(attName, attValue);
                }
                for (AttributeTransformation attributeTransformation : this.attributePatternTransformations) {
                    for (Map.Entry<String, String> entry1 : attributes.entrySet()) {
                        String attName = entry1.getKey();
                        if (!attributeTransformation.satisfy(attName, entry1.getValue())) continue;
                        String template = attributeTransformation.getTemplate();
                        if (template == null) {
                            newAttributes.remove(attName);
                            continue;
                        }
                        String attValue = this.evaluateTemplate(template, attributes);
                        newAttributes.put(attName, attValue);
                    }
                }
            }
            return newAttributes;
        }
        return attributes;
    }

    public String evaluateTemplate(String template, Map<String, String> variables) {
        if (template == null) {
            return template;
        }
        StringBuffer result = new StringBuffer();
        int startIndex = template.indexOf(VAR_START);
        int endIndex = -1;
        while (startIndex >= 0 && startIndex < template.length()) {
            result.append(template.substring(endIndex + 1, startIndex));
            endIndex = template.indexOf(VAR_END, startIndex);
            if (endIndex > startIndex) {
                String varName = template.substring(startIndex + VAR_START.length(), endIndex);
                String resultObj = variables != null ? variables.get(varName.toLowerCase()) : "";
                result.append(resultObj == null ? "" : resultObj.toString());
            }
            startIndex = template.indexOf(VAR_START, Math.max(endIndex + VAR_END.length(), startIndex + 1));
        }
        result.append(template.substring(endIndex + 1));
        return result.toString();
    }
}

