/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.verifytest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.sdk.verifytest.OutputFormat;
import liquibase.sdk.verifytest.TestPermutation;
import liquibase.sdk.verifytest.VerifiedTest;
import liquibase.util.StringUtils;

public class VerifiedTestReader {
    public VerifiedTest read(Reader ... readers) throws IOException {
        VerifiedTest results = null;
        Pattern permutationStartPattern = Pattern.compile("## Permutation: (.*) ##");
        Pattern permutationGroupStartPattern = Pattern.compile("## Permutation Group for (.*?): (.*) ##");
        Pattern internalKeyValuePattern = Pattern.compile("\\- _(.+):_ (.+)");
        Pattern keyValuePattern = Pattern.compile("\\- \\*\\*(.+):\\*\\* (.*)");
        Pattern multiLineKeyValuePattern = Pattern.compile("\\- \\*\\*(.+) =>\\*\\*");
        Pattern dataDetailsMatcher = Pattern.compile("\\*\\*(.*?)\\*\\*: (.*)");
        Pattern notesDetailsMatcher = Pattern.compile("__(.*?)__: (.*)");
        for (Reader reader : readers) {
            String line;
            BufferedReader bufferedReader = new BufferedReader(reader);
            TestPermutation currentPermutation = null;
            HashMap<String, String> currentPermutationGroup = null;
            ArrayList<String> permutationColumns = null;
            String permutationDefinitionKey = null;
            int lineNumber = 0;
            Section section = null;
            String multiLineKey = null;
            String multiLineValue = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (++lineNumber == 1) {
                    String testName;
                    String testClass;
                    Matcher groupMatcher = Pattern.compile("# Test: (\\S*) \"(.*)\" Group \"(.*)\" #").matcher(line);
                    Matcher nonGroupMatcher = Pattern.compile("# Test: (\\S*) \"(.*)\" #").matcher(line);
                    if (groupMatcher.matches()) {
                        if (results != null) continue;
                        testClass = groupMatcher.group(1);
                        testName = groupMatcher.group(2);
                        results = new VerifiedTest(testClass, testName);
                        continue;
                    }
                    if (nonGroupMatcher.matches()) {
                        if (results != null) continue;
                        testClass = nonGroupMatcher.group(1);
                        testName = nonGroupMatcher.group(2);
                        results = new VerifiedTest(testClass, testName);
                        continue;
                    }
                    throw new IOException("Invalid header: " + line);
                }
                if (multiLineKey != null) {
                    if (line.equals("") || line.startsWith("    ")) {
                        multiLineValue = multiLineValue + line.replaceFirst("    ", "") + "\n";
                        continue;
                    }
                    multiLineValue = multiLineValue.trim();
                    if (section.equals((Object)Section.DEFINITION)) {
                        currentPermutation.describe(multiLineKey, multiLineValue, OutputFormat.FromFile);
                    } else if (section.equals((Object)Section.GROUP_DEFINITION)) {
                        currentPermutationGroup.put(multiLineKey, multiLineValue);
                    } else if (section.equals((Object)Section.NOTES)) {
                        currentPermutation.note(multiLineKey, multiLineValue, OutputFormat.FromFile);
                    } else if (section.equals((Object)Section.DATA)) {
                        currentPermutation.data(multiLineKey, multiLineValue, OutputFormat.FromFile);
                    } else {
                        throw new UnexpectedLiquibaseException("Unknown multiline section on line " + lineNumber + ": " + (Object)((Object)section));
                    }
                    multiLineKey = null;
                    multiLineValue = null;
                }
                if (StringUtils.trimToEmpty(line).equals("")) continue;
                if (line.equals("#### Notes ####")) {
                    section = Section.NOTES;
                    continue;
                }
                if (line.equals("#### Data ####")) {
                    section = Section.DATA;
                    continue;
                }
                Matcher permutationStartMatcher = permutationStartPattern.matcher(line);
                if (permutationStartMatcher.matches()) {
                    currentPermutation = new TestPermutation(results);
                    section = Section.DEFINITION;
                    continue;
                }
                Matcher permutationGroupStartMatcher = permutationGroupStartPattern.matcher(line);
                if (permutationGroupStartMatcher.matches()) {
                    currentPermutation = null;
                    currentPermutationGroup = new HashMap<String, String>();
                    permutationDefinitionKey = permutationGroupStartMatcher.group(1);
                    permutationColumns = new ArrayList<String>();
                    section = Section.GROUP_DEFINITION;
                    continue;
                }
                Matcher internalKeyValueMatcher = internalKeyValuePattern.matcher(line);
                if (internalKeyValueMatcher.matches()) {
                    String key = internalKeyValueMatcher.group(1);
                    String value = internalKeyValueMatcher.group(2);
                    if (key.equals("VERIFIED")) {
                        this.setVerifiedFromString(currentPermutation, value);
                        continue;
                    }
                    throw new UnexpectedLiquibaseException("Unknown internal parameter " + key);
                }
                Matcher keyValueMatcher = keyValuePattern.matcher(line);
                if (keyValueMatcher.matches()) {
                    String key = keyValueMatcher.group(1);
                    String value = keyValueMatcher.group(2);
                    if (section.equals((Object)Section.DEFINITION)) {
                        currentPermutation.describe(key, value, OutputFormat.FromFile);
                        continue;
                    }
                    if (section.equals((Object)Section.GROUP_DEFINITION)) {
                        currentPermutationGroup.put(key, value);
                        continue;
                    }
                    if (section.equals((Object)Section.NOTES)) {
                        currentPermutation.note(key, value, OutputFormat.FromFile);
                        continue;
                    }
                    if (section.equals((Object)Section.DATA)) {
                        currentPermutation.data(key, value, OutputFormat.FromFile);
                        continue;
                    }
                    throw new UnexpectedLiquibaseException("Unknown section " + (Object)((Object)section));
                }
                if (line.startsWith("|")) {
                    String unlikelyStringForSplit = "OIPUGAKJNGAOIUWDEGKJASDG";
                    String lineToSplit = line.replaceFirst("\\|", unlikelyStringForSplit).replaceAll("([^\\\\])\\|", "$1" + unlikelyStringForSplit);
                    String[] values = lineToSplit.split("\\s*" + unlikelyStringForSplit + "\\s*");
                    if (line.startsWith("| Permutation ")) {
                        for (int i = 3; i < values.length - 1; ++i) {
                            permutationColumns.add(values[i]);
                        }
                        continue;
                    }
                    if (!values[1].equals("")) {
                        currentPermutation = new TestPermutation(results);
                        for (Map.Entry entry : currentPermutationGroup.entrySet()) {
                            currentPermutation.describe((String)entry.getKey(), entry.getValue(), OutputFormat.FromFile);
                        }
                        this.setVerifiedFromString(currentPermutation, values[2]);
                        int columnNum = 0;
                        HashMap valueDescription = new HashMap();
                        try {
                            for (int i = 3; i < values.length - 1; ++i) {
                                if (!values[i].equals("")) {
                                    valueDescription.put(permutationColumns.get(columnNum), new TestPermutation.Value(this.decode(values[i]), OutputFormat.FromFile));
                                }
                                ++columnNum;
                            }
                        }
                        catch (Throwable e) {
                            throw new UnexpectedLiquibaseException("Error parsing line " + line);
                        }
                        currentPermutation.describeAsTable(permutationDefinitionKey, valueDescription);
                    }
                    String details = values[values.length - 1];
                    Matcher dataMatcher = dataDetailsMatcher.matcher(details);
                    Matcher notesMatcher = notesDetailsMatcher.matcher(details);
                    if (dataMatcher.matches()) {
                        currentPermutation.data(dataMatcher.group(1), this.decode(dataMatcher.group(2)), OutputFormat.FromFile);
                        continue;
                    }
                    if (notesMatcher.matches()) {
                        currentPermutation.note(notesMatcher.group(1), this.decode(notesMatcher.group(2)), OutputFormat.FromFile);
                        continue;
                    }
                    throw new RuntimeException("Unknown details column format: " + details);
                }
                Matcher multiLineKeyValueMatcher = multiLineKeyValuePattern.matcher(line);
                if (multiLineKeyValueMatcher.matches()) {
                    multiLineKey = multiLineKeyValueMatcher.group(1);
                    multiLineValue = "";
                    continue;
                }
                if (currentPermutation == null) continue;
                throw new UnexpectedLiquibaseException("Could not parse line " + lineNumber + ": " + line);
            }
        }
        return results;
    }

    private String decode(String string) {
        return string.replace("<br>", "\n").replace("\\|", "|");
    }

    protected void setVerifiedFromString(TestPermutation currentPermutation, String value) {
        String[] splitValue = value.split("\\s+", 2);
        currentPermutation.setVerified(Boolean.valueOf(splitValue[0]));
        if (splitValue.length > 1) {
            currentPermutation.setNotRanMessage(splitValue[1]);
        }
    }

    private static enum Section {
        GROUP_DEFINITION,
        DEFINITION,
        NOTES,
        DATA;

    }
}

