/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.openid;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.json.JSONException;

abstract class OpenIdRequest<T> {
    private static Logger log = LoggerFactory.getLogger(OpenIdRequest.class);

    OpenIdRequest() {
    }

    protected abstract URL createURL() throws IOException;

    protected abstract T invokeRequest(Map<String, String> var1) throws IOException, JSONException;

    protected abstract T parseResponse(String var1) throws JSONException;

    public T executeRequest(Map<String, String> params) {
        try {
            return this.invokeRequest(params);
        }
        catch (JSONException e) {
            throw new OAuthException(OAuthExceptionCode.IO_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            throw new OAuthException(OAuthExceptionCode.IO_ERROR, (Throwable)e);
        }
    }
}

