/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.Parameter;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.method.ParameterHelper;
import org.exoplatform.services.rest.impl.method.ParameterResolver;
import org.exoplatform.services.rest.method.TypeProducer;

public class FormParameterResolver
extends ParameterResolver<FormParam> {
    private static final Type FORM_TYPE = (ParameterizedType)MultivaluedMapImpl.class.getGenericInterfaces()[0];
    private final FormParam formParam;

    FormParameterResolver(FormParam formParam) {
        this.formParam = formParam;
    }

    @Override
    public Object resolve(Parameter parameter, ApplicationContext context) throws Exception {
        String param = this.formParam.value();
        TypeProducer typeProducer = ParameterHelper.createTypeProducer(parameter.getParameterClass(), parameter.getGenericType());
        MediaType conetentType = context.getHttpHeaders().getMediaType();
        MessageBodyReader<MultivaluedMap> reader = context.getProviders().getMessageBodyReader(MultivaluedMap.class, FORM_TYPE, null, conetentType);
        if (reader == null) {
            throw new IllegalStateException("Can't find appropriate entity reader for entity type " + MultivaluedMap.class.getName() + " and content-type " + conetentType);
        }
        InputStream entityStream = context.getContainerRequest().getEntityStream();
        if (entityStream.available() == 0 && EnvironmentContext.getCurrent() != null && EnvironmentContext.getCurrent().get(HttpServletRequest.class) != null) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)EnvironmentContext.getCurrent().get(HttpServletRequest.class);
            String requestContent = "";
            Enumeration e = httpServletRequest.getParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!requestContent.equals("")) {
                    requestContent = requestContent + "&";
                }
                requestContent = requestContent + key + "=" + httpServletRequest.getParameter(key);
            }
            entityStream = new ByteArrayInputStream(requestContent.getBytes());
        }
        MultivaluedMap form = (MultivaluedMap)reader.readFrom(MultivaluedMap.class, FORM_TYPE, null, conetentType, context.getHttpHeaders().getRequestHeaders(), entityStream);
        return typeProducer.createValue(param, (MultivaluedMap<String, String>)form, parameter.getDefaultValue());
    }
}

