/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;

public class ActivitiesRealtimeListAccess
implements RealtimeListAccess<ExoSocialActivity> {
    private ActivityStorage activityStorage;
    private ActivityType activityType;
    private Identity ownerIdentity;
    private Identity viewerIdentity;
    private String[] activityTypes;

    public ActivitiesRealtimeListAccess(ActivityStorage existingActivityStorage, ActivityType chosenActivityType) {
        this.activityStorage = existingActivityStorage;
        this.activityType = chosenActivityType;
    }

    public ActivitiesRealtimeListAccess(ActivityStorage existingActivityStorage, ActivityType chosenActivityType, Identity chosenOwnerIdentity) {
        this.activityStorage = existingActivityStorage;
        this.activityType = chosenActivityType;
        this.ownerIdentity = chosenOwnerIdentity;
    }

    public ActivitiesRealtimeListAccess(ActivityStorage existingActivityStorage, ActivityType chosenActivityType, Identity chosenOwnerIdentity, String ... activityTypes) {
        this.activityStorage = existingActivityStorage;
        this.activityType = chosenActivityType;
        this.ownerIdentity = chosenOwnerIdentity;
        this.activityTypes = activityTypes;
    }

    public ActivitiesRealtimeListAccess(ActivityStorage existingActivityStorage, ActivityType chosenActivityType, Identity chosenOwnerIdentity, Identity viewerIndentity) {
        this.activityStorage = existingActivityStorage;
        this.activityType = chosenActivityType;
        this.ownerIdentity = chosenOwnerIdentity;
        this.viewerIdentity = viewerIndentity;
    }

    public List<String> loadIdsAsList(int index, int limit) {
        switch (this.activityType) {
            case ACTIVITY_FEED: {
                return this.activityStorage.getActivityIdsFeed(this.ownerIdentity, index, limit);
            }
            case USER_ACTIVITIES: {
                return this.activityStorage.getUserIdsActivities(this.ownerIdentity, index, limit);
            }
            case VIEW_USER_ACTIVITIES: {
                return StorageUtils.getIds(this.activityStorage.getActivities(this.ownerIdentity, this.viewerIdentity, index, limit));
            }
            case CONNECTIONS_ACTIVITIES: {
                return this.activityStorage.getActivityIdsOfConnections(this.ownerIdentity, index, limit);
            }
            case USER_SPACE_ACTIVITIES: {
                return this.activityStorage.getUserSpacesActivityIds(this.ownerIdentity, index, limit);
            }
            case SPACE_ACTIVITIES: {
                return this.activityStorage.getSpaceActivityIds(this.ownerIdentity, index, limit);
            }
        }
        return new LinkedList<String>();
    }

    public List<ExoSocialActivity> loadAsList(int index, int limit) {
        switch (this.activityType) {
            case ACTIVITY_FEED: {
                return this.activityStorage.getActivityFeed(this.ownerIdentity, index, limit);
            }
            case USER_ACTIVITIES: {
                return this.activityStorage.getUserActivities(this.ownerIdentity, index, limit);
            }
            case VIEW_USER_ACTIVITIES: {
                return this.activityStorage.getActivities(this.ownerIdentity, this.viewerIdentity, index, limit);
            }
            case CONNECTIONS_ACTIVITIES: {
                return this.activityStorage.getActivitiesOfConnections(this.ownerIdentity, index, limit);
            }
            case USER_SPACE_ACTIVITIES: {
                return this.activityStorage.getUserSpacesActivities(this.ownerIdentity, index, limit);
            }
            case SPACE_ACTIVITIES: {
                return this.activityStorage.getSpaceActivities(this.ownerIdentity, index, limit);
            }
            case POSTER_ACTIVITIES: {
                return this.activityStorage.getActivitiesByPoster(this.ownerIdentity, index, limit);
            }
            case POSTER_AND_TYPES_ACTIVITIES: {
                return this.activityStorage.getActivitiesByPoster(this.ownerIdentity, index, limit, this.activityTypes);
            }
            case ALL: {
                return this.activityStorage.getAllActivities(index, limit);
            }
        }
        return Collections.emptyList();
    }

    public ExoSocialActivity[] load(int index, int limit) {
        return (ExoSocialActivity[])RealtimeListAccess.convertListToArray(this.loadAsList(index, limit), ExoSocialActivity.class);
    }

    public int getSize() {
        switch (this.activityType) {
            case ACTIVITY_FEED: {
                return this.activityStorage.getNumberOfActivitesOnActivityFeed(this.ownerIdentity);
            }
            case USER_ACTIVITIES: {
                return this.activityStorage.getNumberOfUserActivities(this.ownerIdentity);
            }
            case CONNECTIONS_ACTIVITIES: {
                return this.activityStorage.getNumberOfActivitiesOfConnections(this.ownerIdentity);
            }
            case USER_SPACE_ACTIVITIES: {
                return this.activityStorage.getNumberOfUserSpacesActivities(this.ownerIdentity);
            }
            case SPACE_ACTIVITIES: {
                return this.activityStorage.getNumberOfSpaceActivities(this.ownerIdentity);
            }
            case POSTER_ACTIVITIES: {
                return this.activityStorage.getNumberOfActivitiesByPoster(this.ownerIdentity);
            }
            case POSTER_AND_TYPES_ACTIVITIES: {
                return 0;
            }
            case VIEW_USER_ACTIVITIES: {
                return this.activityStorage.getNumberOfActivitiesByPoster(this.ownerIdentity, this.viewerIdentity);
            }
        }
        return 0;
    }

    public List<ExoSocialActivity> loadNewer(ExoSocialActivity baseActivity, int length) {
        switch (this.activityType) {
            case ACTIVITY_FEED: {
                return this.activityStorage.getNewerOnActivityFeed(this.ownerIdentity, baseActivity, length);
            }
            case USER_ACTIVITIES: {
                return this.activityStorage.getNewerOnUserActivities(this.ownerIdentity, baseActivity, length);
            }
            case CONNECTIONS_ACTIVITIES: {
                return this.activityStorage.getNewerOnActivitiesOfConnections(this.ownerIdentity, baseActivity, length);
            }
            case USER_SPACE_ACTIVITIES: {
                return this.activityStorage.getNewerOnUserSpacesActivities(this.ownerIdentity, baseActivity, length);
            }
            case SPACE_ACTIVITIES: {
                return this.activityStorage.getNewerOnSpaceActivities(this.ownerIdentity, baseActivity, length);
            }
        }
        return Collections.emptyList();
    }

    public int getNumberOfNewer(ExoSocialActivity baseActivity) {
        switch (this.activityType) {
            case ACTIVITY_FEED: {
                return this.activityStorage.getNumberOfNewerOnActivityFeed(this.ownerIdentity, baseActivity);
            }
            case USER_ACTIVITIES: {
                return this.activityStorage.getNumberOfNewerOnUserActivities(this.ownerIdentity, baseActivity);
            }
            case CONNECTIONS_ACTIVITIES: {
                return this.activityStorage.getNumberOfNewerOnActivitiesOfConnections(this.ownerIdentity, baseActivity);
            }
            case USER_SPACE_ACTIVITIES: {
                return this.activityStorage.getNumberOfNewerOnUserSpacesActivities(this.ownerIdentity, baseActivity);
            }
            case SPACE_ACTIVITIES: {
                return this.activityStorage.getNumberOfNewerOnSpaceActivities(this.ownerIdentity, baseActivity);
            }
        }
        return 0;
    }

    public List<ExoSocialActivity> loadOlder(ExoSocialActivity baseActivity, int length) {
        switch (this.activityType) {
            case ACTIVITY_FEED: {
                return this.activityStorage.getOlderOnActivityFeed(this.ownerIdentity, baseActivity, length);
            }
            case USER_ACTIVITIES: {
                return this.activityStorage.getOlderOnUserActivities(this.ownerIdentity, baseActivity, length);
            }
            case CONNECTIONS_ACTIVITIES: {
                return this.activityStorage.getOlderOnActivitiesOfConnections(this.ownerIdentity, baseActivity, length);
            }
            case USER_SPACE_ACTIVITIES: {
                return this.activityStorage.getOlderOnUserSpacesActivities(this.ownerIdentity, baseActivity, length);
            }
            case SPACE_ACTIVITIES: {
                return this.activityStorage.getOlderOnSpaceActivities(this.ownerIdentity, baseActivity, length);
            }
        }
        return Collections.emptyList();
    }

    public int getNumberOfOlder(ExoSocialActivity baseActivity) {
        switch (this.activityType) {
            case ACTIVITY_FEED: {
                return this.activityStorage.getNumberOfOlderOnActivityFeed(this.ownerIdentity, baseActivity);
            }
            case USER_ACTIVITIES: {
                return this.activityStorage.getNumberOfOlderOnUserActivities(this.ownerIdentity, baseActivity);
            }
            case CONNECTIONS_ACTIVITIES: {
                return this.activityStorage.getNumberOfOlderOnActivitiesOfConnections(this.ownerIdentity, baseActivity);
            }
            case USER_SPACE_ACTIVITIES: {
                return this.activityStorage.getNumberOfOlderOnUserSpacesActivities(this.ownerIdentity, baseActivity);
            }
            case SPACE_ACTIVITIES: {
                return this.activityStorage.getNumberOfOlderOnSpaceActivities(this.ownerIdentity, baseActivity);
            }
        }
        return 0;
    }

    public int getNumberOfNewer(Long sinceTime) {
        switch (this.activityType) {
            case ACTIVITY_FEED: {
                return this.activityStorage.getNumberOfNewerOnActivityFeed(this.ownerIdentity, sinceTime);
            }
            case USER_ACTIVITIES: {
                return this.activityStorage.getNumberOfNewerOnUserActivities(this.ownerIdentity, sinceTime);
            }
            case CONNECTIONS_ACTIVITIES: {
                return this.activityStorage.getNumberOfNewerOnActivitiesOfConnections(this.ownerIdentity, sinceTime);
            }
            case USER_SPACE_ACTIVITIES: {
                return this.activityStorage.getNumberOfNewerOnUserSpacesActivities(this.ownerIdentity, sinceTime);
            }
            case SPACE_ACTIVITIES: {
                return this.activityStorage.getNumberOfNewerOnSpaceActivities(this.ownerIdentity, sinceTime);
            }
        }
        return 0;
    }

    public List<ExoSocialActivity> getUpadtedActivities(Long sinceTime, int limit) {
        switch (this.activityType) {
            case ACTIVITY_FEED: {
                return this.activityStorage.getNewerFeedActivities(this.ownerIdentity, sinceTime, limit);
            }
            case USER_ACTIVITIES: {
                return this.activityStorage.getNewerUserActivities(this.ownerIdentity, sinceTime, limit);
            }
            case CONNECTIONS_ACTIVITIES: {
                return this.activityStorage.getNewerActivitiesOfConnections(this.ownerIdentity, sinceTime, limit);
            }
            case USER_SPACE_ACTIVITIES: {
                return this.activityStorage.getNewerUserSpacesActivities(this.ownerIdentity, sinceTime, limit);
            }
            case SPACE_ACTIVITIES: {
                return this.activityStorage.getNewerSpaceActivities(this.ownerIdentity, sinceTime, limit);
            }
        }
        return Collections.emptyList();
    }

    public List<ExoSocialActivity> loadNewer(Long sinceTime, int limit) {
        switch (this.activityType) {
            case ACTIVITY_FEED: {
                return this.activityStorage.getNewerFeedActivities(this.ownerIdentity, sinceTime, limit);
            }
            case USER_ACTIVITIES: {
                return this.activityStorage.getNewerUserActivities(this.ownerIdentity, sinceTime, limit);
            }
            case CONNECTIONS_ACTIVITIES: {
                return this.activityStorage.getNewerActivitiesOfConnections(this.ownerIdentity, sinceTime, limit);
            }
            case USER_SPACE_ACTIVITIES: {
                return this.activityStorage.getNewerUserSpacesActivities(this.ownerIdentity, sinceTime, limit);
            }
            case SPACE_ACTIVITIES: {
                return this.activityStorage.getNewerSpaceActivities(this.ownerIdentity, sinceTime, limit);
            }
        }
        return Collections.emptyList();
    }

    public List<ExoSocialActivity> loadOlder(Long sinceTime, int limit) {
        switch (this.activityType) {
            case ACTIVITY_FEED: {
                return this.activityStorage.getOlderFeedActivities(this.ownerIdentity, sinceTime, limit);
            }
            case USER_ACTIVITIES: {
                return this.activityStorage.getOlderUserActivities(this.ownerIdentity, sinceTime, limit);
            }
            case CONNECTIONS_ACTIVITIES: {
                return this.activityStorage.getOlderActivitiesOfConnections(this.ownerIdentity, sinceTime, limit);
            }
            case USER_SPACE_ACTIVITIES: {
                return this.activityStorage.getOlderUserSpacesActivities(this.ownerIdentity, sinceTime, limit);
            }
            case SPACE_ACTIVITIES: {
                return this.activityStorage.getOlderSpaceActivities(this.ownerIdentity, sinceTime, limit);
            }
        }
        return Collections.emptyList();
    }

    public int getNumberOfOlder(Long sinceTime) {
        switch (this.activityType) {
            case ACTIVITY_FEED: {
                return this.activityStorage.getNumberOfOlderOnActivityFeed(this.ownerIdentity, sinceTime);
            }
            case USER_ACTIVITIES: {
                return this.activityStorage.getNumberOfOlderOnUserActivities(this.ownerIdentity, sinceTime);
            }
            case CONNECTIONS_ACTIVITIES: {
                return this.activityStorage.getNumberOfOlderOnActivitiesOfConnections(this.ownerIdentity, sinceTime);
            }
            case USER_SPACE_ACTIVITIES: {
                return this.activityStorage.getNumberOfOlderOnUserSpacesActivities(this.ownerIdentity, sinceTime);
            }
            case SPACE_ACTIVITIES: {
                return this.activityStorage.getNumberOfOlderOnSpaceActivities(this.ownerIdentity, sinceTime);
            }
        }
        return 0;
    }

    public int getNumberOfUpgrade() {
        switch (this.activityType) {
            case ACTIVITY_FEED: {
                return this.activityStorage.getNumberOfActivitesOnActivityFeedForUpgrade(this.ownerIdentity);
            }
            case USER_ACTIVITIES: {
                return this.activityStorage.getNumberOfUserActivitiesForUpgrade(this.ownerIdentity);
            }
            case CONNECTIONS_ACTIVITIES: {
                return this.activityStorage.getNumberOfActivitiesOfConnectionsForUpgrade(this.ownerIdentity);
            }
            case USER_SPACE_ACTIVITIES: {
                return this.activityStorage.getNumberOfUserSpacesActivitiesForUpgrade(this.ownerIdentity);
            }
            case SPACE_ACTIVITIES: {
                return this.activityStorage.getNumberOfSpaceActivitiesForUpgrade(this.ownerIdentity);
            }
            case POSTER_ACTIVITIES: {
                return this.activityStorage.getNumberOfActivitiesByPoster(this.ownerIdentity);
            }
            case POSTER_AND_TYPES_ACTIVITIES: {
                return 0;
            }
            case VIEW_USER_ACTIVITIES: {
                return this.activityStorage.getNumberOfActivitiesByPoster(this.ownerIdentity, this.viewerIdentity);
            }
        }
        return 0;
    }

    public static enum ActivityType {
        ACTIVITY_FEED,
        USER_ACTIVITIES,
        VIEW_USER_ACTIVITIES,
        CONNECTIONS_ACTIVITIES,
        USER_SPACE_ACTIVITIES,
        SPACE_ACTIVITIES,
        POSTER_ACTIVITIES,
        POSTER_AND_TYPES_ACTIVITIES,
        ALL;

    }
}

