/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.dlp.processor.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.exoplatform.commons.dlp.connector.DlpServiceConnector;
import org.exoplatform.commons.dlp.dao.DlpOperationDAO;
import org.exoplatform.commons.dlp.domain.DlpOperation;
import org.exoplatform.commons.dlp.processor.DlpOperationProcessor;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class DlpOperationProcessorImpl
extends DlpOperationProcessor
implements Startable {
    private static final Log LOGGER = ExoLogger.getExoLogger(DlpOperationProcessorImpl.class);
    private static final Integer BATCH_NUMBER_DEFAULT = 1000;
    private final DlpOperationDAO dlpOperationDAO;
    private Integer batchNumber = BATCH_NUMBER_DEFAULT;
    private ExecutorService executors = Executors.newCachedThreadPool();
    private boolean interrupted = false;
    private boolean initialized = false;

    public DlpOperationProcessorImpl(DlpOperationDAO dlpOperationDAO) {
        this.dlpOperationDAO = dlpOperationDAO;
    }

    public void start() {
        this.initialized = true;
    }

    public void stop() {
        this.executors.shutdownNow();
    }

    @Override
    public synchronized void process() {
        if (!this.initialized) {
            LOGGER.debug((Object)"Skip Dlp queue processing until service is properly initialized");
            return;
        }
        this.interrupted = false;
        try {
            int processedOperations;
            while ((processedOperations = this.processBulk()) >= this.batchNumber) {
            }
        }
        finally {
            if (this.interrupted) {
                LOGGER.debug((Object)"Dlp queue processing interruption done");
            }
        }
    }

    @Override
    public void interrupt() {
        LOGGER.debug((Object)"Dlp queue processing has been interrupted. Please wait until the service exists cleanly...");
        this.interrupted = true;
    }

    private boolean isInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            LOGGER.debug((Object)"Thread running dlp queue processing has been interrupted. Please wait until the service exists cleanly...");
            this.interrupted = true;
        }
        return this.interrupted;
    }

    private int processBulk() {
        HashMap<String, List<DlpOperation>> dlpQueueSorted = new HashMap<String, List<DlpOperation>>();
        long maxDlpOperationId = 0L;
        List<DlpOperation> dlpOperations = this.dlpOperationDAO.findAllFirst(this.batchNumber);
        for (DlpOperation dlpOperation : dlpOperations) {
            this.putDlpOperationInMemoryQueue(dlpOperation, dlpQueueSorted);
            if (maxDlpOperationId >= dlpOperation.getId()) continue;
            maxDlpOperationId = dlpOperation.getId();
        }
        for (String entityType : dlpQueueSorted.keySet()) {
            DlpServiceConnector connector = this.getConnectors().get(entityType);
            List dlpOperationsList = (List)dlpQueueSorted.get(entityType);
            if (dlpOperationsList == null || dlpOperationsList.isEmpty()) continue;
            Iterator dlpOperationsIterator = dlpOperationsList.iterator();
            while (dlpOperationsIterator.hasNext()) {
                if (this.isInterrupted()) {
                    throw new RuntimeException("Dlp queue processing interrupted");
                }
                DlpOperation dlpOperation = (DlpOperation)dlpOperationsIterator.next();
                if (!connector.processItem(dlpOperation.getEntityId())) continue;
                this.dlpOperationDAO.delete(dlpOperation);
            }
        }
        return dlpOperations.size();
    }

    private void putDlpOperationInMemoryQueue(DlpOperation dlpOperation, Map<String, List<DlpOperation>> dlpQueueSorted) {
        if (!dlpQueueSorted.containsKey(dlpOperation.getEntityType())) {
            dlpQueueSorted.put(dlpOperation.getEntityType(), new ArrayList());
        }
        dlpQueueSorted.get(dlpOperation.getEntityType()).add(dlpOperation);
    }
}

