/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExpressionUtil {
    private static final Log LOG = ExoLogger.getLogger("exo.kernel.commons.ExpressionUtil");

    public static String getExpressionValue(ResourceBundle res, String key) {
        String value;
        block4: {
            if (res == null) {
                return key;
            }
            if (!ExpressionUtil.isResourceBindingExpression(key)) {
                return key;
            }
            value = key;
            key = key.substring(2, key.length() - 1);
            try {
                value = res.getString(key);
            }
            catch (MissingResourceException ex) {
                if (!LOG.isTraceEnabled()) break block4;
                LOG.trace("An exception occurred: " + ex.getMessage());
            }
        }
        return value;
    }

    public static boolean isResourceBindingExpression(String key) {
        if (key == null || key.length() < 3) {
            return false;
        }
        return key.charAt(0) == '#' && key.charAt(1) == '{' && key.charAt(key.length() - 1) == '}';
    }

    public static String getValue(ResourceBundle res, String key) {
        try {
            return res.getString(key);
        }
        catch (MissingResourceException ex) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("An exception occurred: " + ex.getMessage());
            }
            return key;
        }
    }

    public static boolean isDataBindingExpression(String key) {
        if (key == null || key.length() < 3) {
            return false;
        }
        return key.charAt(0) == '$' && key.charAt(1) == '{' && key.charAt(key.length() - 1) == '}';
    }

    public static String removeBindingExpression(String key) {
        key = key.substring(2, key.length() - 1);
        return key;
    }
}

