/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.rendering.cache.AttachmentCountData;
import org.exoplatform.wiki.rendering.cache.MarkupData;
import org.exoplatform.wiki.rendering.cache.MarkupKey;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.DataStorage;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.utils.Utils;
import org.gatein.api.EntityNotFoundException;

public class NoteServiceImpl
implements NoteService {
    public static final String CACHE_NAME = "wiki.PageRenderingCache";
    public static final String ATT_CACHE_NAME = "wiki.PageAttachmentCache";
    private static final Log log = ExoLogger.getLogger(NoteServiceImpl.class);
    private final ConfigurationManager configManager;
    private final OrganizationService orgService;
    private final WikiService wikiService;
    private final UserACL userACL;
    private final DataStorage dataStorage;
    private final ExoCache<Integer, MarkupData> renderingCache;
    private final ExoCache<Integer, AttachmentCountData> attachmentCountCache;
    private final Map<WikiPageParams, List<WikiPageParams>> pageLinksMap = new ConcurrentHashMap<WikiPageParams, List<WikiPageParams>>();

    public NoteServiceImpl(ConfigurationManager configManager, UserACL userACL, DataStorage dataStorage, CacheService cacheService, OrganizationService orgService, WikiService wikiService) {
        this.configManager = configManager;
        this.userACL = userACL;
        this.dataStorage = dataStorage;
        this.orgService = orgService;
        this.wikiService = wikiService;
        this.renderingCache = cacheService.getCacheInstance(CACHE_NAME);
        this.attachmentCountCache = cacheService.getCacheInstance(ATT_CACHE_NAME);
    }

    public ExoCache<Integer, MarkupData> getRenderingCache() {
        return this.renderingCache;
    }

    public Map<WikiPageParams, List<WikiPageParams>> getPageLinksMap() {
        return this.pageLinksMap;
    }

    @Override
    public Page createNote(Wiki noteBook, String parentNoteName, Page note, Identity userIdentity) throws WikiException, IllegalAccessException {
        String pageName = TitleResolver.getId(note.getTitle(), false);
        note.setName(pageName);
        if (this.isExisting(noteBook.getType(), noteBook.getOwner(), pageName)) {
            throw new WikiException("Page " + noteBook.getType() + ":" + noteBook.getOwner() + ":" + pageName + " already exists, cannot create it.");
        }
        Page parentPage = this.getNoteOfNoteBookByName(noteBook.getType(), noteBook.getOwner(), parentNoteName);
        if (parentPage != null) {
            List<PermissionEntry> permissions = note.getPermissions();
            if (permissions == null) {
                if (parentPage.getPermissions() != null) {
                    permissions = parentPage.getPermissions();
                } else {
                    Page wikiHomePage = noteBook.getWikiHome();
                    permissions = wikiHomePage.getPermissions();
                }
                note.setPermissions(permissions);
            }
            Page createdPage = this.createNote(noteBook, parentPage, note);
            createdPage.setToBePublished(note.isToBePublished());
            createdPage.setAppName(note.getAppName());
            createdPage.setUrl(Utils.getPageUrl(createdPage));
            this.invalidateCache(parentPage);
            this.invalidateCache(note);
            this.postAddPage(noteBook.getType(), noteBook.getOwner(), note.getName(), createdPage);
            return createdPage;
        }
        throw new EntityNotFoundException("Parent note not foond");
    }

    @Override
    public Page createNote(Wiki noteBook, Page parentPage, Page note) throws WikiException {
        return this.dataStorage.createPage(noteBook, parentPage, note);
    }

    @Override
    public void updateNote(Page note) throws WikiException {
        this.dataStorage.updatePage(note);
    }

    @Override
    public Page updateNote(Page note, PageUpdateType type, Identity userIdentity) throws WikiException, IllegalAccessException, EntityNotFoundException {
        Page note_ = this.getNoteById(note.getId());
        if (note_ == null) {
            throw new EntityNotFoundException("Note to update not found");
        }
        if (note_ != null && !this.hasPermissionOnNote(note_, PermissionType.EDITPAGE, userIdentity)) {
            throw new IllegalAccessException("User does not have edit the note.");
        }
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        ListenerService listenerService = (ListenerService)PortalContainer.getComponent(ListenerService.class);
        if (PageUpdateType.EDIT_PAGE_CONTENT.equals((Object)type) || PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE.equals((Object)type)) {
            note.setUpdatedDate(Calendar.getInstance().getTime());
        }
        this.updateNote(note);
        this.invalidateCache(note);
        if (PageUpdateType.EDIT_PAGE_CONTENT.equals((Object)type) || PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE.equals((Object)type)) {
            try {
                listenerService.broadcast("exo.wiki.edit", (Object)wikiService, (Object)note);
            }
            catch (Exception e) {
                log.error((Object)"Error while broadcasting wiki edition event", (Throwable)e);
            }
        }
        Page updatedPage = this.getNoteById(note.getId());
        updatedPage.setUrl(Utils.getPageUrl(updatedPage));
        updatedPage.setToBePublished(note.isToBePublished());
        updatedPage.setAppName(note.getAppName());
        this.postUpdatePage(updatedPage.getWikiType(), updatedPage.getWikiOwner(), updatedPage.getName(), updatedPage, type);
        return updatedPage;
    }

    @Override
    public boolean deleteNote(String noteType, String noteOwner, String noteName) throws WikiException {
        if ("WikiHome".equals(noteName) || noteName == null) {
            return false;
        }
        try {
            this.dataStorage.deletePage(noteType, noteOwner, noteName);
        }
        catch (WikiException e) {
            log.error((Object)("Can't delete note '" + noteName + "' "), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteNote(String noteType, String noteOwner, String noteName, Identity userIdentity) throws WikiException, IllegalAccessException, EntityNotFoundException {
        block9: {
            if ("WikiHome".equals(noteName) || noteName == null) {
                return false;
            }
            try {
                Page note = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName);
                if (note == null) {
                    log.error((Object)("Can't delete note '" + noteName + "'. This note does not exist."));
                    throw new EntityNotFoundException("Note to update not found");
                }
                if (note != null) {
                    if (!this.hasPermissionOnNote(note, PermissionType.EDITPAGE, userIdentity)) {
                        log.error((Object)("Can't delete note '" + noteName + "'. does not have edit permission on it."));
                        throw new IllegalAccessException("User does not have edit permissions on the note.");
                    }
                    this.invalidateCachesOfPageTree(note);
                    this.invalidateAttachmentCache(note);
                    ArrayList<Page> allChrildrenPages = new ArrayList<Page>();
                    LinkedList<Page> queue = new LinkedList<Page>();
                    queue.add(note);
                    while (!queue.isEmpty()) {
                        Page tempPage = (Page)queue.poll();
                        List<Page> childrenPages = this.getChildrenNoteOf(tempPage);
                        for (Page childPage : childrenPages) {
                            queue.add(childPage);
                            allChrildrenPages.add(childPage);
                        }
                    }
                    this.deleteNote(noteType, noteOwner, noteName);
                    this.postDeletePage(noteType, noteOwner, noteName, note);
                    for (Page childNote : allChrildrenPages) {
                        this.postDeletePage(childNote.getWikiType(), childNote.getWikiOwner(), childNote.getName(), childNote);
                    }
                    break block9;
                }
                log.error((Object)("Can't delete note '" + noteName + "'. This note does not exist."));
                return false;
            }
            catch (WikiException e) {
                log.error((Object)("Can't delete note '" + noteName + "' "), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean renameNote(String noteType, String noteOwner, String noteName, String newName, String newTitle) throws WikiException {
        if ("WikiHome".equals(noteName) || noteName == null) {
            return false;
        }
        if (!noteName.equals(newName) && this.isExisting(noteType, noteOwner, newName)) {
            throw new WikiException("Note " + noteType + ":" + noteOwner + ":" + newName + " already exists, cannot rename it.");
        }
        this.dataStorage.renamePage(noteType, noteOwner, noteName, newName, newTitle);
        Page page = new Page(noteName);
        page.setWikiType(noteType);
        page.setWikiOwner(noteOwner);
        this.invalidateCache(page);
        return true;
    }

    @Override
    public void moveNote(WikiPageParams currentLocationParams, WikiPageParams newLocationParams) throws WikiException {
        this.dataStorage.movePage(currentLocationParams, newLocationParams);
    }

    @Override
    public boolean moveNote(WikiPageParams currentLocationParams, WikiPageParams newLocationParams, Identity userIdentity) throws WikiException, IllegalAccessException, EntityNotFoundException {
        try {
            Page moveNote = this.getNoteOfNoteBookByName(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageName());
            if (moveNote == null) {
                throw new EntityNotFoundException("Note to update not found");
            }
            if (moveNote != null && !this.hasPermissionOnNote(moveNote, PermissionType.EDITPAGE, userIdentity)) {
                throw new IllegalAccessException("User does not have edit the note.");
            }
            this.moveNote(currentLocationParams, newLocationParams);
            Page note = new Page(currentLocationParams.getPageName());
            note.setWikiType(currentLocationParams.getType());
            note.setWikiOwner(currentLocationParams.getOwner());
            this.invalidateCache(note);
            this.invalidateAttachmentCache(note);
            this.postUpdatePage(newLocationParams.getType(), newLocationParams.getOwner(), moveNote.getName(), moveNote, PageUpdateType.MOVE_PAGE);
        }
        catch (WikiException e) {
            log.error((Object)("Can't move note '" + currentLocationParams.getPageName() + "' "), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName) throws WikiException {
        Page page = null;
        page = this.dataStorage.getPageOfWikiByName(noteType, noteOwner, noteName);
        this.checkToRemoveDomainInUrl(page);
        return page;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName, Identity userIdentity, String source) throws IllegalAccessException, WikiException {
        Page page = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName, userIdentity);
        if (StringUtils.isNotEmpty((String)source)) {
            if (source.equals("tree")) {
                this.postOpenByTree(noteType, noteOwner, noteName, page);
            }
            if (source.equals("breadCrumb")) {
                this.postOpenByBreadCrumb(noteType, noteOwner, noteName, page);
            }
        }
        return page;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName, Identity userIdentity) throws IllegalAccessException, WikiException {
        Page page = null;
        page = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName);
        if (page != null) {
            if (!this.hasPermissionOnNote(page, PermissionType.VIEWPAGE, userIdentity)) {
                throw new IllegalAccessException("User does not have view the note.");
            }
            boolean canEdit = this.hasPermissionOnNote(page, PermissionType.EDITPAGE, userIdentity);
            page.setCanEdit(canEdit);
        }
        return page;
    }

    @Override
    public Page getNoteById(String id) throws WikiException {
        if (id == null) {
            return null;
        }
        return this.dataStorage.getPageById(id);
    }

    @Override
    public Page getNoteById(String id, Identity userIdentity) throws IllegalAccessException, WikiException {
        if (id == null) {
            return null;
        }
        Page page = null;
        page = this.getNoteById(id);
        if (page != null) {
            if (!this.hasPermissionOnNote(page, PermissionType.VIEWPAGE, userIdentity)) {
                throw new IllegalAccessException("User does not have view the note.");
            }
            boolean canEdit = this.hasPermissionOnNote(page, PermissionType.EDITPAGE, userIdentity);
            page.setCanEdit(canEdit);
        }
        return page;
    }

    @Override
    public Page getNoteById(String id, Identity userIdentity, String source) throws IllegalAccessException, WikiException {
        if (id == null) {
            return null;
        }
        Page page = null;
        page = this.getNoteById(id);
        if (page != null && !this.hasPermissionOnNote(page, PermissionType.VIEWPAGE, userIdentity)) {
            throw new IllegalAccessException("User does not have view the note.");
        }
        boolean canEdit = this.hasPermissionOnNote(page, PermissionType.EDITPAGE, userIdentity);
        page.setCanEdit(canEdit);
        if (StringUtils.isNotEmpty((String)source)) {
            if (source.equals("tree")) {
                this.postOpenByTree(page.getWikiType(), page.getWikiOwner(), page.getName(), page);
            }
            if (source.equals("breadCrumb")) {
                this.postOpenByBreadCrumb(page.getWikiType(), page.getWikiOwner(), page.getName(), page);
            }
        }
        return page;
    }

    @Override
    public Page getParentNoteOf(Page note) throws WikiException {
        return this.dataStorage.getParentPageOf(note);
    }

    @Override
    public List<Page> getChildrenNoteOf(Page note) throws WikiException {
        return this.dataStorage.getChildrenPageOf(note);
    }

    @Override
    public List<BreadcrumbData> getBreadcumb(String noteType, String noteOwner, String noteName) throws WikiException {
        return this.getBreadcumb(null, noteType, noteOwner, noteName);
    }

    @Override
    public List<Page> getDuplicateNotes(Page parentNote, Wiki targetNoteBook, List<Page> resultList) throws WikiException {
        if (resultList == null) {
            resultList = new ArrayList<Page>();
        }
        if (resultList.size() > 6) {
            return resultList;
        }
        if (this.isExisting(targetNoteBook.getType(), targetNoteBook.getOwner(), parentNote.getName())) {
            resultList.add(parentNote);
        }
        List<Page> childrenNotes = this.getChildrenNoteOf(parentNote);
        for (Page note : childrenNotes) {
            this.getDuplicateNotes(note, targetNoteBook, resultList);
        }
        return resultList;
    }

    @Override
    public void removeDraftOfNote(WikiPageParams param) throws WikiException {
        Page page = this.getNoteOfNoteBookByName(param.getType(), param.getOwner(), param.getPageName());
        this.dataStorage.deleteDraftOfPage(page, Utils.getCurrentUser());
    }

    @Override
    public boolean hasPermissionOnNote(Page note, PermissionType permissionType, Identity user) throws WikiException {
        return this.dataStorage.hasPermissionOnPage(note, permissionType, user);
    }

    @Override
    public boolean hasAdminSpacePermission(String noteBookType, String owner, Identity user) throws WikiException {
        if (user != null) {
            if (this.userACL != null && this.userACL.getSuperUser().equals(user.getUserId())) {
                return true;
            }
        } else {
            user = new Identity(IdentityConstants.ANONIM);
        }
        return this.dataStorage.hasAdminSpacePermission(noteBookType, owner, user);
    }

    @Override
    public boolean hasAdminNotePermission(String noteType, String owner, Identity user) throws WikiException {
        if (user != null) {
            if (this.userACL != null && this.userACL.getSuperUser().equals(user.getUserId())) {
                return true;
            }
        } else {
            user = new Identity(IdentityConstants.ANONIM);
        }
        return this.dataStorage.hasAdminPagePermission(noteType, owner, user);
    }

    @Override
    public boolean canModifyNotePermission(Page currentNote, Identity currentIdentity) throws WikiException {
        Wiki wiki;
        boolean canModifyPage = false;
        String currentUser = currentIdentity.getUserId();
        String owner = currentNote.getOwner();
        boolean isPageOwner = owner != null && owner.equals(currentUser);
        boolean hasEditPagePermissionOnPage = false;
        if (currentNote.getPermissions() != null) {
            for (PermissionEntry permissionEntry : currentNote.getPermissions()) {
                if (permissionEntry.getId().equals(currentUser)) {
                    for (Permission permission : permissionEntry.getPermissions()) {
                        if (!permission.getPermissionType().equals((Object)PermissionType.EDITPAGE) || !permission.isAllowed()) continue;
                        hasEditPagePermissionOnPage = true;
                        break;
                    }
                }
                if (!hasEditPagePermissionOnPage) continue;
                break;
            }
        }
        canModifyPage = isPageOwner && hasEditPagePermissionOnPage ? true : this.hasAdminSpacePermission((wiki = this.wikiService.getWikiByTypeAndOwner(currentNote.getWikiType(), currentNote.getWikiOwner())).getType(), wiki.getOwner(), currentIdentity) || this.hasAdminNotePermission(wiki.getType(), wiki.getOwner(), currentIdentity);
        return canModifyPage;
    }

    @Override
    public boolean canPublicAndRetrictNote(Page currentNote, Identity currentIdentity) throws WikiException {
        Wiki wiki;
        String currentUser = currentIdentity.getUserId();
        if (currentNote.getPermissions() != null) {
            for (PermissionEntry permissionEntry : currentNote.getPermissions()) {
                if (!permissionEntry.getId().equals(currentUser)) continue;
                for (Permission permission : permissionEntry.getPermissions()) {
                    if (!permission.getPermissionType().equals((Object)PermissionType.EDITPAGE) || !permission.isAllowed()) continue;
                    return true;
                }
            }
        }
        return this.hasAdminNotePermission((wiki = this.wikiService.getWikiByTypeAndOwner(currentNote.getWikiType(), currentNote.getWikiOwner())).getType(), wiki.getOwner(), currentIdentity) || this.hasAdminSpacePermission(wiki.getType(), wiki.getOwner(), currentIdentity);
    }

    @Override
    public List<PageVersion> getVersionsOfNote(Page note) throws WikiException {
        List<PageVersion> versions = this.dataStorage.getVersionsOfPage(note);
        if (versions == null || versions.isEmpty()) {
            this.dataStorage.addPageVersion(note);
            versions = this.dataStorage.getVersionsOfPage(note);
        }
        return versions;
    }

    @Override
    public PageVersion getVersionOfNoteByName(String versionName, Page note) throws WikiException {
        List<PageVersion> versions = this.getVersionsOfNote(note);
        PageVersion pageVersion = null;
        if (versions != null) {
            for (PageVersion version : versions) {
                if (!version.getName().equals(versionName)) continue;
                pageVersion = version;
                break;
            }
        }
        return pageVersion;
    }

    @Override
    public void createVersionOfNote(Page note) throws WikiException {
        this.dataStorage.addPageVersion(note);
    }

    @Override
    public void restoreVersionOfNote(String versionName, Page note) throws WikiException {
        this.dataStorage.restoreVersionOfPage(versionName, note);
        this.createVersionOfNote(note);
        this.invalidateCache(note);
    }

    @Override
    public List<String> getPreviousNamesOfNote(Page note) throws WikiException {
        return this.dataStorage.getPreviousNamesOfPage(note);
    }

    @Override
    public List<Page> getNotesOfWiki(String noteType, String noteOwner) {
        return this.dataStorage.getPagesOfWiki(noteType, noteOwner);
    }

    @Override
    public boolean isExisting(String noteBookType, String noteBookOwner, String noteId) throws WikiException {
        return this.getNoteByRootPermission(noteBookType, noteBookOwner, noteId) != null;
    }

    @Override
    public Page getNoteByRootPermission(String noteBookType, String noteBookOwner, String noteId) throws WikiException {
        return this.dataStorage.getPageOfWikiByName(noteBookType, noteBookOwner, noteId);
    }

    protected void invalidateCache(Page page) {
        WikiPageParams params = new WikiPageParams(page.getWikiType(), page.getWikiOwner(), page.getName());
        List<WikiPageParams> linkedPages = this.pageLinksMap.get(params);
        linkedPages = linkedPages == null ? new ArrayList<WikiPageParams>() : new ArrayList<WikiPageParams>(linkedPages);
        linkedPages.add(params);
        for (WikiPageParams wikiPageParams : linkedPages) {
            try {
                MarkupKey key = new MarkupKey(wikiPageParams, false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(wikiPageParams, false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(wikiPageParams, false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
            }
            catch (Exception e) {
                log.warn((Object)String.format("Failed to invalidate cache of page [%s:%s:%s]", wikiPageParams.getType(), wikiPageParams.getOwner(), wikiPageParams.getPageName()));
            }
        }
    }

    protected void invalidateCachesOfPageTree(Page note) throws WikiException {
        LinkedList<Page> queue = new LinkedList<Page>();
        queue.add(note);
        while (!queue.isEmpty()) {
            Page currentPage = (Page)queue.poll();
            this.invalidateCache(currentPage);
            List<Page> childrenPages = this.getChildrenNoteOf(currentPage);
            for (Page child : childrenPages) {
                queue.add(child);
            }
        }
    }

    protected void invalidateAttachmentCache(Page note) {
        WikiPageParams wikiPageParams = new WikiPageParams(note.getWikiType(), note.getWikiOwner(), note.getName());
        List<WikiPageParams> linkedPages = this.pageLinksMap.get(wikiPageParams);
        linkedPages = linkedPages == null ? new ArrayList<WikiPageParams>() : new ArrayList<WikiPageParams>(linkedPages);
        linkedPages.add(wikiPageParams);
        for (WikiPageParams linkedWikiPageParams : linkedPages) {
            try {
                MarkupKey key = new MarkupKey(linkedWikiPageParams, false);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(linkedWikiPageParams, false);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
            }
            catch (Exception e) {
                log.warn((Object)String.format("Failed to invalidate cache of note [%s:%s:%s]", linkedWikiPageParams.getType(), linkedWikiPageParams.getOwner(), linkedWikiPageParams.getPageName()));
            }
        }
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postUpdatePage(wikiType, wikiOwner, pageId, page, wikiUpdateType);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postAddPage(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postDeletePage(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postOpenByTree(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postgetPagefromTree(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postOpenByBreadCrumb(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postgetPagefromBreadCrumb(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    private void checkToRemoveDomainInUrl(Page note) {
        block4: {
            if (note == null) {
                return;
            }
            String url = note.getUrl();
            if (url != null && url.contains("://")) {
                try {
                    URL oldURL = new URL(url);
                    note.setUrl(oldURL.getPath());
                }
                catch (MalformedURLException ex) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("Malformed url " + url), (Throwable)ex);
                }
            }
        }
    }

    private List<BreadcrumbData> getBreadcumb(List<BreadcrumbData> list, String noteType, String noteOwner, String noteName) throws WikiException {
        if (list == null) {
            list = new ArrayList<BreadcrumbData>(5);
        }
        if (noteName == null) {
            return list;
        }
        Page note = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName);
        if (note == null) {
            return list;
        }
        list.add(0, new BreadcrumbData(note.getName(), note.getId(), note.getTitle(), noteType, noteOwner));
        Page parentNote = this.getParentNoteOf(note);
        if (parentNote != null) {
            this.getBreadcumb(list, noteType, noteOwner, parentNote.getName());
        }
        return list;
    }
}

