/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mfa.api;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.mfa.api.MfaSystemService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MfaSystemComponentPlugin
implements ComponentPlugin {
    private String name;
    private String description;
    private MfaSystemService mfaSystemService;
    private static final Log LOG = ExoLogger.getLogger(MfaSystemComponentPlugin.class);

    public MfaSystemComponentPlugin(InitParams initParams) {
        ValueParam serviceValueParam = initParams.getValueParam("service");
        if (serviceValueParam != null) {
            String service = serviceValueParam.getValue();
            try {
                Object o = CommonsUtils.getService(Class.forName(service));
                if (o instanceof MfaSystemService) {
                    this.mfaSystemService = (MfaSystemService)o;
                } else {
                    LOG.error((Object)"Class {} is not instance of MfaSystemService");
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error("Unable to find class {}", new Object[]{service, e});
            }
        }
    }

    public MfaSystemService getMfaSystemService() {
        return this.mfaSystemService;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

