/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mfa.filter;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.mfa.api.MfaService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.filter.Filter;

public class MfaFilter
implements Filter {
    private static String MFA_URI = "/portal/dw/mfa-access";
    private static final Log LOG = ExoLogger.getLogger(MfaFilter.class);
    private List<String> excludedUrls = new ArrayList<String>(Arrays.asList("/portal/skins", "/portal/scripts", "/portal/javascript", "/portal/rest", "/portal/service-worker.js", MFA_URI));

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        HttpSession session = httpServletRequest.getSession();
        PortalContainer container = PortalContainer.getInstance();
        MfaService mfaService = (MfaService)container.getComponentInstanceOfType(MfaService.class);
        String requestUri = httpServletRequest.getRequestURI();
        if (httpServletRequest.getRemoteUser() != null && mfaService.isMfaFeatureActivated() && this.excludedUrls.stream().noneMatch(s -> requestUri.startsWith((String)s)) && (mfaService.isProtectedUri(requestUri) || mfaService.currentUserIsInProtectedGroup(ConversationState.getCurrent().getIdentity())) && this.shouldAuthenticateFromSession(session)) {
            LOG.debug((Object)"Mfa Filter must redirect on page to fill token");
            httpServletResponse.sendRedirect(MFA_URI + "?initialUri=" + requestUri);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean shouldAuthenticateFromSession(HttpSession session) {
        if (session.getAttribute("mfaValidated") == null) {
            return true;
        }
        if (!((Boolean)session.getAttribute("mfaValidated")).booleanValue()) {
            return true;
        }
        Instant expiration = (Instant)session.getAttribute("mfaExpiration");
        return expiration != null && expiration.isBefore(Instant.now());
    }
}

