/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.imageio.ImageIO;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.portal.application.Image;
import org.exoplatform.portal.application.ImageType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.portal.controller.resource.ResourceRequestHandler;

public class ResourceRequestFilter
extends AbstractFilter {
    protected static Log log = ExoLogger.getLogger(ResourceRequestFilter.class);
    private FilterConfig cfg;
    private ImageType[] imageTypes = ImageType.values();
    private ConcurrentMap<String, FutureTask<Image>> mirroredImageCache = new ConcurrentHashMap<String, FutureTask<Image>>();
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String EXPIRES = "Expires";

    public void afterInit(FilterConfig filterConfig) {
        this.cfg = filterConfig;
        log.info((Object)("Cache eXo Resource at client: " + !PropertyManager.isDevelopping()));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        final String uri = URLDecoder.decode(httpRequest.getRequestURI(), "UTF-8");
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        long ifModifiedSince = httpRequest.getDateHeader(IF_MODIFIED_SINCE);
        int len = uri.length();
        if (len >= 7 && uri.charAt(len - 7) == '-' && uri.charAt(len - 6) == 'r' && uri.charAt(len - 5) == 't') {
            for (final ImageType imageType : this.imageTypes) {
                FutureTask<Image> tmp;
                if (!imageType.matches(uri)) continue;
                final String resource = uri.substring(httpRequest.getContextPath().length(), len - 7) + uri.substring(len - 4);
                FutureTask<Image> futureImg = (FutureTask<Image>)this.mirroredImageCache.get(resource);
                if (futureImg == null && (futureImg = this.mirroredImageCache.putIfAbsent(resource, tmp = new FutureTask<Image>(new Callable<Image>(){

                    @Override
                    public Image call() throws Exception {
                        InputStream in = ResourceRequestFilter.this.cfg.getServletContext().getResourceAsStream(resource);
                        if (in == null) {
                            return null;
                        }
                        BufferedImage img = ImageIO.read(in);
                        log.debug((Object)("Read image " + uri + " (" + img.getWidth() + "," + img.getHeight() + ")"));
                        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
                        tx.translate(-img.getWidth(null), 0.0);
                        AffineTransformOp op = new AffineTransformOp(tx, 1);
                        img = op.filter(img, null);
                        log.debug((Object)("Mirrored image " + uri + " (" + img.getWidth() + "," + img.getHeight() + ")"));
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
                        ImageIO.write((RenderedImage)img, imageType.getFormat(), baos);
                        baos.close();
                        return new Image(imageType, baos.toByteArray());
                    }
                }))) == null) {
                    futureImg = tmp;
                    futureImg.run();
                }
                try {
                    Image img = (Image)futureImg.get();
                    if (img != null) {
                        long imgLastModified = img.getLastModified();
                        if (this.isNotModified(ifModifiedSince, imgLastModified)) {
                            httpResponse.setStatus(304);
                            return;
                        }
                        httpResponse.setContentType(img.type.getMimeType());
                        httpResponse.setContentLength(img.bytes.length);
                        httpResponse.setHeader("Cache-Control", "max-age=2592000,s-maxage=2592000");
                        this.processIfModified(imgLastModified, httpResponse);
                        ServletOutputStream out = httpResponse.getOutputStream();
                        out.write(img.bytes);
                        out.close();
                    } else {
                        this.mirroredImageCache.remove(resource);
                        httpResponse.setStatus(404);
                    }
                    return;
                }
                catch (InterruptedException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (ExecutionException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    this.mirroredImageCache.remove(resource);
                }
            }
        }
        if (!PropertyManager.isDevelopping()) {
            httpResponse.addHeader("Cache-Control", "max-age=2592000,s-maxage=2592000");
            httpResponse.setDateHeader(EXPIRES, System.currentTimeMillis() + ResourceRequestHandler.MAX_AGE * 1000L);
        } else {
            if (uri.endsWith(".jstmpl") || uri.endsWith(".js")) {
                httpResponse.setHeader("Cache-Control", "no-cache");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Load Resource: " + uri));
            }
        }
        chain.doFilter(request, response);
    }

    public void processIfModified(long lastModified, HttpServletResponse httpResponse) {
        httpResponse.setDateHeader(LAST_MODIFIED, lastModified);
    }

    private boolean isNotModified(long ifModifedSince, long lastModified) {
        return !PropertyManager.isDevelopping() && ifModifedSince >= lastModified;
    }

    public void destroy() {
    }
}

