/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class TemplateService {
    private static TemplateService instance = new TemplateService();
    private final VelocityEngine engine = new VelocityEngine();

    public static TemplateService getInstance() {
        return instance;
    }

    private TemplateService() {
        this.engine.setProperty("resource.loader", (Object)"classpath");
        this.engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        this.engine.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String output(String templatePath, Map<String, Object> contextParams) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            this.write(templatePath, writer, contextParams);
        }
        finally {
            writer.flush();
            writer.close();
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String templatePath, File outputFile, Map<String, Object> contextParams) throws IOException {
        outputFile.getAbsoluteFile().getParentFile().mkdirs();
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
        try {
            this.write(templatePath, writer, contextParams);
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String templatePath, Writer output, Map<String, Object> contextParams) throws IOException {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(templatePath);
        try {
            if (input == null) {
                throw new IOException("Template file " + templatePath + " doesn't exist");
            }
            VelocityContext context = new VelocityContext();
            if (contextParams != null) {
                for (Map.Entry<String, Object> entry : contextParams.entrySet()) {
                    context.put(entry.getKey(), entry.getValue());
                }
            }
            Template template = this.engine.getTemplate(templatePath, "UTF-8");
            template.merge((Context)context, output);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }
}

