/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.selector;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.social.core.storage.cache.model.data.ActivityData;
import org.exoplatform.social.core.storage.cache.model.key.ActivityKey;
import org.exoplatform.social.core.storage.cache.selector.CacheSelector;

public class ActivityAttachmentCacheSelector
extends CacheSelector<ActivityKey, ActivityData> {
    private String attachmentId;

    public ActivityAttachmentCacheSelector(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    @Override
    public boolean select(ActivityKey key, ObjectCacheInfo<? extends ActivityData> ocinfo) {
        if (!super.select(key, ocinfo)) {
            return false;
        }
        ActivityData data = (ActivityData)ocinfo.get();
        return !CollectionUtils.isEmpty(data.getFiles()) && data.getFiles().stream().anyMatch(file -> StringUtils.equals((CharSequence)file.getId(), (CharSequence)this.attachmentId));
    }

    @Override
    public void onSelect(ExoCache<? extends ActivityKey, ? extends ActivityData> exoCache, ActivityKey key, ObjectCacheInfo<? extends ActivityData> ocinfo) throws Exception {
        super.onSelect(exoCache, key, ocinfo);
    }
}

