/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.user.HttpUserPortalContext;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;

@Path(value="/v1/navigations")
@Api(tags={"/v1/navigations"}, value="/v1/navigations", description="Retrieve sites navigations")
public class NavigationRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(NavigationRest.class);
    private static final Visibility[] DEFAULT_VISIBILITIES = Visibility.values();
    private static final UserNodeFilterConfig USER_FILTER_CONFIG = NavigationRest.getUserFilterConfig(DEFAULT_VISIBILITIES);
    private UserPortalConfigService portalConfigService;

    public NavigationRest(UserPortalConfigService portalConfigService) {
        this.portalConfigService = portalConfigService;
    }

    @Path(value="/{siteType}")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets navigations of one or multiple site navigations", httpMethod="GET", response=Response.class, notes="This returns the requested site navigations")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Navigation does not exist"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSiteTypeNavigations(@Context HttpServletRequest request, @ApiParam(value="Portal site type, possible values: PORTAL, GROUP or USER", required=true) @PathParam(value="siteType") String siteTypeName, @ApiParam(value="Site names regex to exclude from results", required=false) @QueryParam(value="exclude") String excludedSiteName, @ApiParam(value="Portal site name", required=true) @QueryParam(value="siteName") String siteName, @ApiParam(value="Scope of navigations tree to retrieve, possible values: ALL, CHILDREN, GRANDCHILDREN, SINGLE", defaultValue="ALL", required=false) @QueryParam(value="scope") String scopeName, @ApiParam(value="Multivalued visibilities of navigation nodes to retrieve, possible values: DISPLAYED, HIDDEN, SYSTEM or TEMPORAL. If empty, all visibilities will be used.", defaultValue="All possible values combined", required=false) @QueryParam(value="visibility") List<String> visibilityNames) {
        if (StringUtils.isBlank((String)siteTypeName)) {
            return Response.status((int)400).build();
        }
        return this.getNavigations(request, siteTypeName, siteName, excludedSiteName, scopeName, visibilityNames);
    }

    private Response getNavigations(HttpServletRequest request, String siteTypeName, String siteName, String excludedSiteName, String scopeName, List<String> visibilityNames) {
        String username;
        ConversationState state = ConversationState.getCurrent();
        Identity userIdentity = state == null ? null : state.getIdentity();
        String string = username = userIdentity == null ? null : userIdentity.getUserId();
        if (StringUtils.equals((String)username, (String)IdentityConstants.ANONIM)) {
            username = null;
        }
        SiteType siteType = null;
        try {
            siteType = SiteType.valueOf((String)StringUtils.upperCase((String)siteTypeName));
        }
        catch (Exception e) {
            return Response.status((int)400).entity((Object)("Bad site type: " + siteTypeName)).build();
        }
        Scope scope = null;
        try {
            scope = this.getScope(scopeName);
        }
        catch (Exception e) {
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
        Visibility[] visibilities = null;
        try {
            visibilities = this.convertVisibilities(visibilityNames);
        }
        catch (Exception e) {
            return Response.status((int)400).entity((Object)("Bad visibility names: " + visibilityNames + ". should be one of " + DEFAULT_VISIBILITIES)).build();
        }
        UserNodeFilterConfig userFilterConfig = USER_FILTER_CONFIG;
        if (visibilities.length > 0) {
            userFilterConfig = NavigationRest.getUserFilterConfig(visibilities);
        }
        String portalName = siteName;
        if (siteType != SiteType.PORTAL || StringUtils.isBlank((String)siteName)) {
            portalName = this.portalConfigService.getDefaultPortal();
        }
        try {
            HttpUserPortalContext userPortalContext = new HttpUserPortalContext(request);
            UserPortalConfig userPortalConfig = this.portalConfigService.getUserPortalConfig(portalName, username, userPortalContext);
            if (userPortalConfig == null) {
                return Response.status((int)404).build();
            }
            UserPortal userPortal = userPortalConfig.getUserPortal();
            Collection<UserNode> nodes = null;
            if (siteType == SiteType.PORTAL || StringUtils.isBlank((String)siteName)) {
                nodes = userPortal.getNodes(siteType, excludedSiteName, scope, userFilterConfig);
            } else {
                UserNavigation navigation = userPortal.getNavigation(new SiteKey(siteType, siteName));
                if (navigation == null) {
                    return Response.status((int)404).build();
                }
                UserNode rootNode = userPortal.getNode(navigation, scope, userFilterConfig, null);
                nodes = rootNode.getChildren();
            }
            List<ResultUserNode> resultNodes = this.convertNodes(nodes);
            return Response.ok(resultNodes).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error retrieving ");
            return Response.status((int)500).build();
        }
    }

    private List<ResultUserNode> convertNodes(Collection<UserNode> nodes) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        ArrayList<ResultUserNode> result = new ArrayList<ResultUserNode>();
        for (UserNode userNode : nodes) {
            if (userNode == null) continue;
            ResultUserNode resultNode = new ResultUserNode(userNode);
            resultNode.setChildren(this.convertNodes(userNode.getChildren()));
            result.add(resultNode);
        }
        return result;
    }

    private static UserNodeFilterConfig getUserFilterConfig(Visibility[] visibilities) {
        UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder();
        builder.withReadWriteCheck().withVisibility(visibilities).withTemporalCheck().withReadCheck();
        return builder.build();
    }

    private Visibility[] convertVisibilities(List<String> visibilityNames) {
        if (visibilityNames == null) {
            return new Visibility[0];
        }
        return visibilityNames.stream().map(visibilityName -> Visibility.valueOf((String)StringUtils.upperCase((String)visibilityName))).collect(Collectors.toList()).toArray(new Visibility[0]);
    }

    private Scope getScope(String scopeName) {
        Scope scope = null;
        if (StringUtils.isBlank((String)scopeName)) {
            scope = Scope.ALL;
        } else {
            switch (StringUtils.upperCase((String)scopeName)) {
                case "SINGLE": {
                    scope = Scope.SINGLE;
                    break;
                }
                case "CHILDREN": {
                    scope = Scope.CHILDREN;
                    break;
                }
                case "GRANDCHILDREN": {
                    scope = Scope.GRANDCHILDREN;
                    break;
                }
                case "ALL": {
                    scope = Scope.ALL;
                    break;
                }
                default: {
                    throw new IllegalStateException("Bad scope name: " + scopeName);
                }
            }
        }
        return scope;
    }

    public static final class ResultUserNode {
        private UserNode userNode;
        private List<ResultUserNode> subNodes;

        public ResultUserNode(UserNode userNode) {
            this.userNode = userNode;
        }

        public void setChildren(List<ResultUserNode> subNodes) {
            this.subNodes = subNodes;
        }

        public List<ResultUserNode> getChildren() {
            return this.subNodes;
        }

        public String getLabel() {
            return this.userNode.getResolvedLabel();
        }

        public String getLabelKey() {
            return this.userNode.getLabel();
        }

        public String getIcon() {
            return this.userNode.getIcon();
        }

        public String getId() {
            return this.userNode.getId();
        }

        public String getUri() {
            return this.userNode.getURI();
        }

        public Visibility getVisibility() {
            return this.userNode.getVisibility();
        }

        public String getName() {
            return this.userNode.getName();
        }

        public long getStartPublicationTime() {
            return this.userNode.getStartPublicationTime();
        }

        public long getEndPublicationTime() {
            return this.userNode.getEndPublicationTime();
        }

        public SiteKey getSiteKey() {
            return this.userNode.getNavigation().getKey();
        }

        public PageKey getPageKey() {
            return this.userNode.getPageRef();
        }
    }
}

