/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.jpa.storage.dao.SpaceMemberDAO;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;

public class SpaceMemberDAOImpl
extends GenericDAOJPAImpl<SpaceMemberEntity, Long>
implements SpaceMemberDAO {
    private static final Log LOG = ExoLogger.getLogger(SpaceMemberDAOImpl.class);

    @Override
    public void deleteBySpace(SpaceEntity entity) {
        Query query = this.getEntityManager().createNamedQuery("SpaceMember.deleteBySpace");
        query.setParameter("spaceId", (Object)entity.getId());
        query.executeUpdate();
    }

    @Override
    public List<String> sortSpaceMembers(List<String> userNames, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection, boolean filterDisabled) {
        if (userNames == null || userNames.isEmpty()) {
            return Collections.emptyList();
        }
        String dbBoolFalse = this.isOrcaleDialect() || this.isMSSQLDialect() ? "0" : "FALSE";
        String dbBoolTrue = this.isOrcaleDialect() || this.isMSSQLDialect() ? "1" : "TRUE";
        StringBuilder queryStringBuilder = null;
        queryStringBuilder = this.isOrcaleDialect() ? new StringBuilder("SELECT to_char(identity_1.remote_id), identity_1.identity_id \n") : (this.isMSSQLDialect() ? new StringBuilder("SELECT try_convert(varchar(200), identity_1.remote_id) as remote_id , identity_1.identity_id, try_convert(varchar(200) \n") : new StringBuilder("SELECT identity_1.remote_id, identity_1.identity_id \n"));
        queryStringBuilder.append(" FROM SOC_IDENTITIES identity_1 \n");
        if (StringUtils.isNotBlank((CharSequence)firstCharacterFieldName) && firstCharacter > '\u0000') {
            queryStringBuilder.append(" INNER JOIN SOC_IDENTITY_PROPERTIES identity_prop_first_char \n");
            queryStringBuilder.append("   ON identity_1.identity_id = identity_prop_first_char.identity_id \n");
            queryStringBuilder.append("       AND identity_prop_first_char.name = '").append(firstCharacterFieldName).append("' \n");
            queryStringBuilder.append("       AND (lower(identity_prop_first_char.value) like '" + Character.toLowerCase(firstCharacter) + "%')\n");
        }
        if (StringUtils.isNotBlank((CharSequence)sortField) && StringUtils.isNotBlank((CharSequence)sortDirection)) {
            queryStringBuilder.append(" LEFT JOIN SOC_IDENTITY_PROPERTIES identity_prop \n");
            queryStringBuilder.append("   ON identity_1.identity_id = identity_prop.identity_id \n");
            queryStringBuilder.append("       AND identity_prop.name = '").append(sortField).append("' \n");
        }
        queryStringBuilder.append(" WHERE identity_1.remote_id IN (");
        for (int i = 0; i < userNames.size(); ++i) {
            if (i > 0) {
                queryStringBuilder.append(",");
            }
            queryStringBuilder.append("'").append(userNames.get(i)).append("'");
        }
        queryStringBuilder.append(")\n");
        if (filterDisabled) {
            queryStringBuilder.append(" AND identity_1.deleted = ").append(dbBoolFalse).append(" \n");
            queryStringBuilder.append(" AND identity_1.enabled = ").append(dbBoolTrue).append(" \n");
        }
        if (StringUtils.isNotBlank((CharSequence)sortField) && StringUtils.isNotBlank((CharSequence)sortDirection)) {
            queryStringBuilder.append(" ORDER BY lower(identity_prop.value) " + sortDirection);
        }
        Query query = this.getEntityManager().createNativeQuery(queryStringBuilder.toString());
        List resultList = query.getResultList();
        ArrayList<String> result = new ArrayList<String>();
        for (Object object : resultList) {
            Object[] resultEntry = (Object[])object;
            if (resultEntry[0] == null) continue;
            String username = resultEntry[0].toString();
            result.add(username);
        }
        return result;
    }

    @Override
    public List<String> getSpaceMembers(Long spaceId, SpaceMemberEntity.Status status, int offset, int limit) {
        if (status == null) {
            throw new IllegalArgumentException("Status is null");
        }
        if (spaceId == null || spaceId == 0L) {
            throw new IllegalArgumentException("spaceId is null or equals to 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be positive");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be > 0");
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.getSpaceMembersByStatus", String.class);
        query.setParameter("status", (Object)status);
        query.setParameter("spaceId", (Object)spaceId);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public int countSpaceMembers(Long spaceId, SpaceMemberEntity.Status status) {
        if (status == null) {
            throw new IllegalArgumentException("Status is null");
        }
        if (spaceId == null || spaceId == 0L) {
            throw new IllegalArgumentException("spaceId is null or equals to 0");
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.countSpaceMembersByStatus", Long.class);
        query.setParameter("status", (Object)status);
        query.setParameter("spaceId", (Object)spaceId);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public SpaceMemberEntity getSpaceMemberShip(String remoteId, Long spaceId, SpaceMemberEntity.Status status) throws IllegalArgumentException {
        if (status == null) {
            TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.getSpaceMemberShip", SpaceMemberEntity.class);
            query.setParameter("userId", (Object)remoteId);
            query.setParameter("spaceId", (Object)spaceId);
            try {
                List memberEntities = query.getResultList();
                if (memberEntities.size() > 1) {
                    LOG.warn((Object)"we have found more than one result");
                    return (SpaceMemberEntity)memberEntities.get(0);
                }
                return (SpaceMemberEntity)query.getSingleResult();
            }
            catch (NoResultException ex) {
                return null;
            }
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.getMember", SpaceMemberEntity.class);
        query.setParameter("userId", (Object)remoteId);
        query.setParameter("spaceId", (Object)spaceId);
        query.setParameter("status", (Object)status);
        try {
            List memberEntities = query.getResultList();
            if (memberEntities.size() > 1) {
                LOG.warn((Object)"we have found more than one result");
                return (SpaceMemberEntity)memberEntities.get(0);
            }
            return (SpaceMemberEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public List<Long> getSpacesIdsByUserName(String userId, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.getSpaceIdentitiesIdByMemberId", Long.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("status", (Object)SpaceMemberEntity.Status.MEMBER);
        try {
            if (limit > 0) {
                query.setFirstResult(offset);
                query.setMaxResults(limit);
            }
            return query.getResultList();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public List<Tuple> getPendingSpaceRequestsToManage(String username, int offset, int limit) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be positive");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be > 0");
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.getPendingSpaceRequestsToManage", Tuple.class);
        query.setParameter("userId", (Object)username);
        query.setParameter("status", (Object)SpaceMemberEntity.Status.PENDING);
        query.setParameter("user_status", (Object)SpaceMemberEntity.Status.MANAGER);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        try {
            return query.getResultList();
        }
        catch (NoResultException ex) {
            return Collections.emptyList();
        }
    }

    @Override
    public int countPendingSpaceRequestsToManage(String username) {
        TypedQuery query = this.getEntityManager().createNamedQuery("SpaceMember.countPendingSpaceRequestsToManage", Long.class);
        query.setParameter("userId", (Object)username);
        query.setParameter("status", (Object)SpaceMemberEntity.Status.PENDING);
        query.setParameter("user_status", (Object)SpaceMemberEntity.Status.MANAGER);
        return ((Long)query.getSingleResult()).intValue();
    }
}

