/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.cdi.contexts;

import java.io.Serializable;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

public class SerializableContextual<T>
implements Contextual<T>,
Serializable {
    private transient Contextual<T> contextual;
    private Contextual<T> serializable;

    public SerializableContextual(Contextual<T> contextual) {
        this.contextual = contextual;
        if (contextual instanceof Serializable) {
            this.serializable = contextual;
        }
    }

    public T create(CreationalContext<T> creationalContext) {
        return (T)this.get().create(creationalContext);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        this.get().destroy(instance, creationalContext);
    }

    private Contextual<T> get() {
        if (this.contextual == null && this.serializable == null) {
            throw new IllegalStateException("No support for non-serializable contexual.");
        }
        if (this.serializable != null) {
            this.contextual = this.serializable;
        }
        return this.contextual;
    }
}

