/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MockServletContext
implements ServletContext {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.test.MockServletContext");
    private String name_;
    private Map<String, String> initParams_;
    private Map<String, Object> attributes_;
    private String contextPath_;
    private StringBuffer logBuffer = new StringBuffer();

    public MockServletContext() {
        this("portlet_app_1");
    }

    public MockServletContext(String name) {
        this(name, "/" + name);
    }

    public MockServletContext(String name, String path) {
        this.name_ = name;
        this.contextPath_ = path;
        this.initParams_ = new HashMap<String, String>();
        this.attributes_ = new HashMap<String, Object>();
        this.attributes_.put("javax.servlet.context.tempdir", path);
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getLogBuffer() {
        try {
            String string = this.logBuffer.toString();
            return string;
        }
        finally {
            this.logBuffer = new StringBuffer();
        }
    }

    public ServletContext getContext(String s) {
        return null;
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getMimeType(String s) {
        return "text/html";
    }

    public Set<String> getResourcePaths(String s) {
        HashSet<String> set = new HashSet<String>();
        set.add("/test1");
        set.add("/WEB-INF");
        set.add("/test2");
        return set;
    }

    public URL getResource(String s) throws MalformedURLException {
        String path = "file:" + this.contextPath_ + s;
        URL url = new URL(path);
        return url;
    }

    public InputStream getResourceAsStream(String s) {
        try {
            return this.getResource(s).openStream();
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String s) {
        return null;
    }

    public Servlet getServlet(String s) throws ServletException {
        return null;
    }

    public Enumeration<Servlet> getServlets() {
        return null;
    }

    public Enumeration<String> getServletNames() {
        return null;
    }

    public void log(String s) {
        this.logBuffer.append(s);
    }

    public void log(Exception e, String s) {
        this.logBuffer.append(s + e.getMessage());
    }

    public void log(String s, Throwable throwable) {
        this.logBuffer.append(s + throwable.getMessage());
    }

    public void setContextPath(String s) {
        this.contextPath_ = s;
    }

    public String getRealPath(String s) {
        return this.contextPath_ + s;
    }

    public String getServerInfo() {
        return null;
    }

    public boolean setInitParameter(String name, String value) {
        this.initParams_.put(name, value);
        return true;
    }

    public String getInitParameter(String name) {
        return this.initParams_.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        Vector<String> keys = new Vector<String>(this.initParams_.keySet());
        return keys.elements();
    }

    public Object getAttribute(String name) {
        return this.attributes_.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        Vector<String> keys = new Vector<String>(this.attributes_.keySet());
        return keys.elements();
    }

    public void setAttribute(String name, Object value) {
        this.attributes_.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes_.remove(name);
    }

    public String getServletContextName() {
        return this.name_;
    }

    public String getContextPath() {
        return this.contextPath_;
    }

    public int getEffectiveMajorVersion() {
        return 3;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return null;
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        return null;
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return null;
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return null;
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return null;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public void addListener(String className) {
    }

    public <T extends EventListener> void addListener(T t) {
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public void declareRoles(String ... roleNames) {
    }

    public String getVirtualServerName() {
        return null;
    }
}

