/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import org.jgroups.Address;
import org.jgroups.util.Bits;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class ViewId
implements Comparable<ViewId>,
Streamable {
    protected Address creator;
    protected long id = 0L;

    public ViewId() {
    }

    public ViewId(Address creator) {
        this.creator = creator;
        if (this.creator == null) {
            throw new IllegalArgumentException("creator cannot be null");
        }
    }

    public ViewId(Address creator, long id) {
        this(creator);
        this.id = id;
    }

    public Address getCreator() {
        return this.creator;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return "[" + this.creator + '|' + this.id + ']';
    }

    public ViewId copy() {
        return new ViewId(this.creator, this.id);
    }

    @Override
    public int compareTo(ViewId other) {
        return this.id > other.id ? 1 : (this.id < other.id ? -1 : this.creator.compareTo(other.creator));
    }

    public int compareToIDs(ViewId other) {
        return this.id > other.id ? 1 : (this.id < other.id ? -1 : 0);
    }

    public boolean equals(Object other) {
        return other instanceof ViewId && (this == other || this.compareTo((ViewId)other) == 0);
    }

    public int hashCode() {
        return (int)((long)this.creator.hashCode() + this.id);
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        Util.writeAddress(this.creator, out);
        Bits.writeLong(this.id, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.creator = Util.readAddress(in);
        this.id = Bits.readLong(in);
    }

    public int serializedSize() {
        return Bits.size(this.id) + Util.size(this.creator);
    }
}

