/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mfa.impl.otp;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;

public class CodeGenerator {
    private static final String ALGORITHM = "HmacSHA1";
    private final int digits;

    public CodeGenerator() {
        this(6);
    }

    public CodeGenerator(int digits) {
        if (digits < 1) {
            throw new InvalidParameterException("Number of digits must be higher than 0.");
        }
        this.digits = digits;
    }

    public String generate(String key, long counter) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] hash = this.generateHash(key, counter);
        return this.getDigitsFromHash(hash);
    }

    private byte[] generateHash(String key, long counter) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] data = new byte[8];
        long value = counter;
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)value;
            value >>>= 8;
        }
        Base32 codec = new Base32();
        byte[] decodedKey = codec.decode(key);
        SecretKeySpec signKey = new SecretKeySpec(decodedKey, ALGORITHM);
        Mac mac = Mac.getInstance(ALGORITHM);
        mac.init(signKey);
        return mac.doFinal(data);
    }

    private String getDigitsFromHash(byte[] hash) {
        int offset = hash[hash.length - 1] & 0xF;
        long truncatedHash = 0L;
        for (int i = 0; i < 4; ++i) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[offset + i] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        truncatedHash = (long)((double)truncatedHash % Math.pow(10.0, this.digits));
        String format = "%0" + this.digits + "d";
        return String.format(format, truncatedHash);
    }
}

