/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.MarshallerPool;

public final class XML
extends Static {
    public static final String LOCALE = "org.apache.sis.xml.locale";
    public static final String TIMEZONE = "org.apache.sis.xml.timezone";
    public static final String SCHEMAS = "org.apache.sis.xml.schemas";
    @Deprecated
    public static final String DEFAULT_NAMESPACE = "org.apache.sis.xml.defaultNamespace";
    public static final String GML_VERSION = "org.apache.sis.gml.version";
    public static final String METADATA_VERSION = "org.apache.sis.xml.version.metadata";
    public static final String LENIENT_UNMARSHAL = "org.apache.sis.xml.lenient";
    public static final String RESOLVER = "org.apache.sis.xml.resolver";
    public static final String CONVERTER = "org.apache.sis.xml.converter";
    public static final String STRING_SUBSTITUTES = "org.apache.sis.xml.stringSubstitutes";
    public static final String WARNING_FILTER = "org.apache.sis.xml.warningFilter";
    @Deprecated
    public static final String WARNING_LISTENER = "org.apache.sis.xml.warningListener";
    private static volatile MarshallerPool POOL;

    private XML() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MarshallerPool getPool() throws JAXBException {
        MarshallerPool marshallerPool = POOL;
        if (marshallerPool != null) return marshallerPool;
        Class<XML> clazz = XML.class;
        synchronized (XML.class) {
            marshallerPool = POOL;
            if (marshallerPool != null) return marshallerPool;
            POOL = marshallerPool = new MarshallerPool(Collections.singletonMap(LENIENT_UNMARSHAL, Boolean.TRUE));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return marshallerPool;
        }
    }

    public static String marshal(Object object) throws JAXBException {
        ArgumentChecks.ensureNonNull((String)"object", (Object)object);
        StringWriter stringWriter = new StringWriter();
        MarshallerPool marshallerPool = XML.getPool();
        Marshaller marshaller = marshallerPool.acquireMarshaller();
        marshaller.marshal(object, (Writer)stringWriter);
        marshallerPool.recycle(marshaller);
        return stringWriter.toString();
    }

    public static void marshal(Object object, OutputStream outputStream) throws JAXBException {
        ArgumentChecks.ensureNonNull((String)"object", (Object)object);
        ArgumentChecks.ensureNonNull((String)"output", (Object)outputStream);
        MarshallerPool marshallerPool = XML.getPool();
        Marshaller marshaller = marshallerPool.acquireMarshaller();
        marshaller.marshal(object, outputStream);
        marshallerPool.recycle(marshaller);
    }

    public static void marshal(Object object, File file) throws JAXBException {
        ArgumentChecks.ensureNonNull((String)"object", (Object)object);
        ArgumentChecks.ensureNonNull((String)"output", (Object)file);
        MarshallerPool marshallerPool = XML.getPool();
        Marshaller marshaller = marshallerPool.acquireMarshaller();
        marshaller.marshal(object, file);
        marshallerPool.recycle(marshaller);
    }

    public static void marshal(Object object, Path path) throws JAXBException {
        ArgumentChecks.ensureNonNull((String)"object", (Object)object);
        ArgumentChecks.ensureNonNull((String)"output", (Object)path);
        try (OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            MarshallerPool marshallerPool = XML.getPool();
            Marshaller marshaller = marshallerPool.acquireMarshaller();
            marshaller.marshal(object, outputStream);
            marshallerPool.recycle(marshaller);
        }
        catch (IOException iOException) {
            throw new JAXBException(Errors.format((short)9, (Object)path), (Throwable)iOException);
        }
    }

    public static void marshal(Object object, Result result, Map<String, ?> map) throws JAXBException {
        ArgumentChecks.ensureNonNull((String)"object", (Object)object);
        ArgumentChecks.ensureNonNull((String)"output", (Object)result);
        MarshallerPool marshallerPool = XML.getPool();
        Marshaller marshaller = marshallerPool.acquireMarshaller();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                marshaller.setProperty((String)entry.getKey(), entry.getValue());
            }
        }
        if (result instanceof StAXResult) {
            XMLStreamWriter xMLStreamWriter = ((StAXResult)result).getXMLStreamWriter();
            if (xMLStreamWriter != null) {
                marshaller.marshal(object, xMLStreamWriter);
            } else {
                marshaller.marshal(object, ((StAXResult)result).getXMLEventWriter());
            }
        } else {
            marshaller.marshal(object, result);
        }
        marshallerPool.recycle(marshaller);
    }

    public static Object unmarshal(String string) throws JAXBException {
        ArgumentChecks.ensureNonNull((String)"input", (Object)string);
        StringReader stringReader = new StringReader(string);
        MarshallerPool marshallerPool = XML.getPool();
        Unmarshaller unmarshaller = marshallerPool.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal((Reader)stringReader);
        marshallerPool.recycle(unmarshaller);
        return object;
    }

    public static Object unmarshal(InputStream inputStream) throws JAXBException {
        ArgumentChecks.ensureNonNull((String)"input", (Object)inputStream);
        MarshallerPool marshallerPool = XML.getPool();
        Unmarshaller unmarshaller = marshallerPool.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal(inputStream);
        marshallerPool.recycle(unmarshaller);
        return object;
    }

    public static Object unmarshal(URL uRL) throws JAXBException {
        ArgumentChecks.ensureNonNull((String)"input", (Object)uRL);
        MarshallerPool marshallerPool = XML.getPool();
        Unmarshaller unmarshaller = marshallerPool.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal(uRL);
        marshallerPool.recycle(unmarshaller);
        return object;
    }

    public static Object unmarshal(File file) throws JAXBException {
        ArgumentChecks.ensureNonNull((String)"input", (Object)file);
        MarshallerPool marshallerPool = XML.getPool();
        Unmarshaller unmarshaller = marshallerPool.acquireUnmarshaller();
        Object object = unmarshaller.unmarshal(file);
        marshallerPool.recycle(unmarshaller);
        return object;
    }

    public static Object unmarshal(Path path) throws JAXBException {
        Object object;
        ArgumentChecks.ensureNonNull((String)"input", (Object)path);
        try (InputStream inputStream = Files.newInputStream(path, StandardOpenOption.READ);){
            MarshallerPool marshallerPool = XML.getPool();
            Unmarshaller unmarshaller = marshallerPool.acquireUnmarshaller();
            object = unmarshaller.unmarshal(inputStream);
            marshallerPool.recycle(unmarshaller);
        }
        catch (IOException iOException) {
            throw new JAXBException(Errors.format((short)12, (Object)path), (Throwable)iOException);
        }
        return object;
    }

    public static Object unmarshal(Source source, Map<String, ?> map) throws JAXBException {
        XMLStreamReader xMLStreamReader;
        ArgumentChecks.ensureNonNull((String)"input", (Object)source);
        MarshallerPool marshallerPool = XML.getPool();
        Unmarshaller unmarshaller = marshallerPool.acquireUnmarshaller(map);
        Object object = source instanceof StAXSource ? ((xMLStreamReader = ((StAXSource)source).getXMLStreamReader()) != null ? unmarshaller.unmarshal(xMLStreamReader) : unmarshaller.unmarshal(((StAXSource)source).getXMLEventReader())) : unmarshaller.unmarshal(source);
        marshallerPool.recycle(unmarshaller);
        return object;
    }

    public static <T> JAXBElement<T> unmarshal(Source source, Class<T> clazz, Map<String, ?> map) throws JAXBException {
        XMLStreamReader xMLStreamReader;
        ArgumentChecks.ensureNonNull((String)"input", (Object)source);
        ArgumentChecks.ensureNonNull((String)"declaredType", clazz);
        MarshallerPool marshallerPool = XML.getPool();
        Unmarshaller unmarshaller = marshallerPool.acquireUnmarshaller(map);
        JAXBElement jAXBElement = source instanceof StAXSource ? ((xMLStreamReader = ((StAXSource)source).getXMLStreamReader()) != null ? unmarshaller.unmarshal(xMLStreamReader, clazz) : unmarshaller.unmarshal(((StAXSource)source).getXMLEventReader(), clazz)) : unmarshaller.unmarshal(source, clazz);
        marshallerPool.recycle(unmarshaller);
        return jAXBElement;
    }

    static {
        SystemListener.add((SystemListener)new SystemListener("org.apache.sis.util"){

            protected void classpathChanged() {
                POOL = null;
            }
        });
    }
}

