/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.util.Iterator;
import java.util.NoSuchElementException;
import juzu.impl.common.Tools;
import juzu.request.RequestParameter;

public abstract class AbstractParameterParser
implements Iterable<RequestParameter> {
    private final CharSequence s;
    private final int from;
    private final int to;

    public AbstractParameterParser(CharSequence s, int from, int to) {
        this.s = s;
        this.from = from;
        this.to = to;
    }

    @Override
    public Iterator<RequestParameter> iterator() {
        return new Iterator<RequestParameter>(){
            int current;
            RequestParameter next;
            {
                this.current = AbstractParameterParser.this.from;
                this.next = null;
            }

            private RequestParameter parse(int from, int to) {
                String name;
                String decodedName;
                String value;
                String decodedValue;
                int pos = Tools.indexOf(AbstractParameterParser.this.s, '=', from, to);
                if (pos == -1) {
                    String name2 = AbstractParameterParser.this.s.subSequence(from, to).toString();
                    String decodeName = AbstractParameterParser.this.safeDecodeName(name2);
                    if (decodeName != null) {
                        return RequestParameter.create(decodeName, "");
                    }
                } else if (pos > 0 && (decodedValue = AbstractParameterParser.this.safeDecodeValue(value = AbstractParameterParser.this.s.subSequence(pos + 1, to).toString())) != null && (decodedName = AbstractParameterParser.this.safeDecodeName(name = AbstractParameterParser.this.s.subSequence(from, pos).toString())) != null) {
                    return RequestParameter.create(decodedName, value, decodedValue);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                while (this.next == null && this.current < AbstractParameterParser.this.to) {
                    int pos = Tools.indexOf(AbstractParameterParser.this.s, '&', this.current, AbstractParameterParser.this.to);
                    if (pos == 0) {
                        throw new UnsupportedOperationException("todo");
                    }
                    if (pos == -1) {
                        this.next = this.parse(this.current, AbstractParameterParser.this.to);
                        this.current = AbstractParameterParser.this.to;
                        continue;
                    }
                    this.next = this.parse(this.current, pos);
                    this.current = pos + 1;
                }
                return this.next != null;
            }

            @Override
            public RequestParameter next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                RequestParameter tmp = this.next;
                this.next = null;
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected abstract String safeDecodeName(String var1);

    protected abstract String safeDecodeValue(String var1);
}

