/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa.query;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import org.exoplatform.commons.persistence.impl.EntityManagerHolder;
import org.exoplatform.social.core.jpa.search.XSpaceFilter;
import org.exoplatform.social.core.jpa.storage.entity.AppEntity_;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceEntity_;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity_;
import org.exoplatform.social.core.search.Sorting;

public final class SpaceQueryBuilder {
    private long offset;
    private long limit;
    private XSpaceFilter spaceFilter;

    public static SpaceQueryBuilder builder() {
        return new SpaceQueryBuilder();
    }

    public SpaceQueryBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    public SpaceQueryBuilder limit(long limit) {
        this.limit = limit;
        return this;
    }

    public SpaceQueryBuilder filter(XSpaceFilter spaceFilter) {
        this.spaceFilter = spaceFilter;
        return this;
    }

    public TypedQuery<Tuple> build() {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Tuple.class);
        Root spaceEntity = criteria.from(SpaceEntity.class);
        ArrayList selections = new ArrayList();
        selections.add((Selection<?>)spaceEntity.get(SpaceEntity_.id));
        Order[] orderBy = this.buildOrder((Root<SpaceEntity>)spaceEntity, cb, selections);
        Predicate predicateFilter = this.buildPredicateFilter((Root<SpaceEntity>)spaceEntity, criteria, cb, (Root<SpaceEntity>)spaceEntity);
        CriteriaQuery select = criteria.select((Selection)cb.tuple(selections.toArray(new Selection[0]))).distinct(true);
        if (predicateFilter.getExpressions().size() > 0) {
            select.where((Expression)predicateFilter);
        }
        select.orderBy(orderBy);
        TypedQuery typedQuery = em.createQuery(select);
        if (this.limit > 0L) {
            typedQuery.setFirstResult((int)this.offset);
            typedQuery.setMaxResults((int)this.limit);
        }
        return typedQuery;
    }

    public TypedQuery<Long> buildCount() {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Long.class);
        Root spaceEntity = criteria.from(SpaceEntity.class);
        CriteriaQuery select = criteria.select((Selection)cb.countDistinct((Expression)spaceEntity.get(SpaceEntity_.id)));
        Predicate predicateFilter = this.buildPredicateFilter((Root<SpaceEntity>)spaceEntity, criteria, cb, (Root<SpaceEntity>)spaceEntity);
        if (predicateFilter.getExpressions().size() > 0) {
            select.where((Expression)predicateFilter);
        }
        return em.createQuery(select);
    }

    private Predicate buildPredicateFilter(Root<SpaceEntity> root, CriteriaQuery<?> criteria, CriteriaBuilder cb, Root<SpaceEntity> connection) {
        boolean notHidden;
        char first;
        String search;
        String app;
        LinkedList<Object> predicates = new LinkedList<Object>();
        if (!this.spaceFilter.getStatus().isEmpty()) {
            Join<SpaceEntity, SpaceMemberEntity> join = this.getMembersJoin(root, JoinType.INNER);
            LinkedList<Predicate> pStatusList = new LinkedList<Predicate>();
            for (SpaceMemberEntity.Status status : this.spaceFilter.getStatus()) {
                pStatusList.add(cb.equal((Expression)join.get(SpaceMemberEntity_.status), (Object)status));
            }
            Predicate tmp = cb.and((Expression)cb.or(pStatusList.toArray(new Predicate[pStatusList.size()])), (Expression)cb.equal((Expression)join.get(SpaceMemberEntity_.userId), (Object)this.spaceFilter.getRemoteId()));
            boolean includePrivate = this.spaceFilter.isIncludePrivate();
            if (includePrivate) {
                predicates.add(cb.or((Expression)cb.equal((Expression)root.get(SpaceEntity_.visibility), (Object)SpaceEntity.VISIBILITY.PRIVATE), (Expression)tmp));
            } else {
                predicates.add(tmp);
            }
        }
        if (this.spaceFilter.isPublic()) {
            Subquery sub = criteria.subquery(Long.class);
            Root spaceSub = sub.from(SpaceEntity.class);
            SetJoin join = spaceSub.join(SpaceEntity_.members);
            sub.select((Expression)spaceSub.get(SpaceEntity_.id));
            sub.where((Expression)cb.equal((Expression)join.get(SpaceMemberEntity_.userId), (Object)this.spaceFilter.getRemoteId()));
            predicates.add(cb.not((Expression)cb.in((Expression)root.get(SpaceEntity_.id)).value((Expression)sub)));
        }
        if ((app = this.spaceFilter.getAppId()) != null && !(app = app.trim()).isEmpty()) {
            Subquery sub = criteria.subquery(Long.class);
            Root spaceSub = sub.from(SpaceEntity.class);
            sub.select((Expression)spaceSub.get(SpaceEntity_.id));
            Path appPath = spaceSub.join(SpaceEntity_.app).get(AppEntity_.appId);
            LinkedList<Predicate> appCond = new LinkedList<Predicate>();
            for (String appId : app.split(",")) {
                appCond.add(cb.like(cb.lower((Expression)appPath), this.buildSearchCondition(appId, true)));
            }
            sub.where((Expression)cb.or(appCond.toArray(new Predicate[appCond.size()])));
            predicates.add(cb.in((Expression)root.get(SpaceEntity_.id)).value((Expression)sub));
        }
        if ((search = this.spaceFilter.getSpaceNameSearchCondition()) != null && !(search = search.trim()).isEmpty()) {
            String searchCondition = this.buildSearchCondition(search, true);
            Predicate prettyName = cb.like(cb.lower((Expression)root.get(SpaceEntity_.prettyName)), searchCondition);
            Predicate displayName = cb.like(cb.lower((Expression)root.get(SpaceEntity_.displayName)), searchCondition);
            Predicate description = cb.like(cb.lower((Expression)root.get(SpaceEntity_.description)), searchCondition);
            predicates.add(cb.or(new Predicate[]{prettyName, displayName, description}));
        }
        if (!Character.isDigit(first = this.spaceFilter.getFirstCharacterOfSpaceName()) && first != '\u0000') {
            predicates.add(cb.like(cb.lower((Expression)root.get(SpaceEntity_.prettyName)), this.buildSearchCondition(String.valueOf(first), false)));
        }
        if (notHidden = this.spaceFilter.isNotHidden()) {
            predicates.add(cb.notEqual((Expression)root.get(SpaceEntity_.visibility), (Object)SpaceEntity.VISIBILITY.HIDDEN));
        }
        return cb.and(predicates.toArray(new Predicate[predicates.size()]));
    }

    private Join<SpaceEntity, SpaceMemberEntity> getMembersJoin(Root<SpaceEntity> root, JoinType joinType) {
        if (root.getJoins() == null || root.getJoins().isEmpty()) {
            SetJoin join = root.join(SpaceEntity_.members, joinType);
            join.alias("mem");
            return join;
        }
        return (Join)root.getJoins().iterator().next();
    }

    private String buildSearchCondition(String app, boolean searchBack) {
        StringBuilder builder = new StringBuilder(app);
        this.removeAll(builder, "*");
        this.removeAll(builder, "%");
        this.removeAll(builder, "  ");
        if (searchBack) {
            builder.insert(0, "%");
        }
        builder.append("%");
        return builder.toString().toLowerCase();
    }

    private void removeAll(StringBuilder builder, String string) {
        int i;
        while ((i = builder.indexOf(string)) >= 0) {
            builder.deleteCharAt(i);
        }
    }

    private Order[] buildOrder(Root<SpaceEntity> spaceEntity, CriteriaBuilder cb, List<Selection<?>> selections) {
        LinkedList<Order> orders = new LinkedList<Order>();
        if (this.spaceFilter.isLastAccess()) {
            Join<SpaceEntity, SpaceMemberEntity> join = this.getMembersJoin(spaceEntity, JoinType.LEFT);
            Path field = join.get(SpaceMemberEntity_.lastAccess);
            orders.add(cb.desc((Expression)field));
            selections.add((Selection<?>)field);
        } else if (this.spaceFilter.isVisited()) {
            Join<SpaceEntity, SpaceMemberEntity> join = this.getMembersJoin(spaceEntity, JoinType.LEFT);
            Path visitedField = join.get(SpaceMemberEntity_.visited);
            Path displayNameField = spaceEntity.get(SpaceEntity_.displayName);
            orders.add(cb.desc((Expression)visitedField));
            orders.add(cb.asc((Expression)displayNameField));
            selections.add((Selection<?>)visitedField);
            selections.add((Selection<?>)displayNameField);
        } else {
            Sorting sorting = this.spaceFilter.getSorting();
            Expression<?> shortField = this.getShortField(spaceEntity, sorting.sortBy);
            if (sorting.orderBy.equals((Object)Sorting.OrderBy.DESC)) {
                orders.add(cb.desc(shortField));
            } else {
                orders.add(cb.asc(shortField));
            }
            selections.add((Selection<?>)shortField);
        }
        return orders.toArray(new Order[orders.size()]);
    }

    private Expression<?> getShortField(Root<SpaceEntity> spaceEntity, Sorting.SortBy sortBy) {
        if (sortBy.equals((Object)Sorting.SortBy.DATE)) {
            return spaceEntity.get(SpaceEntity_.createdDate);
        }
        return spaceEntity.get(SpaceEntity_.prettyName);
    }
}

