/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.common.lifecycle.LifeCycleListener;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.ActivitiesRealtimeListAccess;
import org.exoplatform.social.core.activity.ActivityLifeCycle;
import org.exoplatform.social.core.activity.ActivityListener;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.ActivitySystemTypePlugin;
import org.exoplatform.social.core.activity.CommentsRealtimeListAccess;
import org.exoplatform.social.core.activity.model.ActivityShareAction;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;

public class ActivityManagerImpl
implements ActivityManager {
    private static final Log LOG = ExoLogger.getLogger(ActivityManagerImpl.class);
    protected ActivityStorage activityStorage;
    protected IdentityManager identityManager;
    protected RelationshipManager relationshipManager;
    private UserACL userACL;
    protected SpaceService spaceService;
    protected ActivityLifeCycle activityLifeCycle = new ActivityLifeCycle();
    private static Map<String, Boolean> activityTypesRegistry = new HashMap<String, Boolean>();
    private static final String ACTIVITY_TYPE_PROPERTY_PATTERN = "exo\\.activity-type\\..*\\.enabled";
    private static final String PREFIX = "exo.activity-type.";
    private static final String SUFFIX = ".enabled";
    public static final String ENABLE_EDIT_ACTIVITY = "exo.edit.activity.enabled";
    public static final String ENABLE_EDIT_COMMENT = "exo.edit.comment.enabled";
    public static final String ENABLE_USER_COMPOSER = "userStreamComposer.enabled";
    public static final String ENABLE_MANAGER_EDIT_ACTIVITY = "exo.manager.edit.activity.enabled";
    public static final String ENABLE_MANAGER_EDIT_COMMENT = "exo.manager.edit.comment.enabled";
    private Set<String> systemActivityTypes = new HashSet<String>();
    private Set<String> systemActivityTitleIds = new HashSet<String>(Arrays.asList("has_joined", "space_avatar_edited", "space_description_edited", "space_renamed", "manager_role_revoked", "manager_role_granted"));
    private int maxUploadSize = 10;
    private boolean enableEditActivity = true;
    private boolean enableEditComment = true;
    private boolean enableUserComposer = true;
    public static final String SEPARATOR_REGEX = "\\|@\\|";
    public static final String ID = "id";
    public static final String STORAGE = "storage";
    public static final String FILE = "file";

    public ActivityManagerImpl(ActivityStorage activityStorage, IdentityManager identityManager, SpaceService spaceService, RelationshipManager relationshipManager, UserACL userACL, InitParams params) {
        this.activityStorage = activityStorage;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.relationshipManager = relationshipManager;
        this.userACL = userACL;
        this.initActivityTypes();
        if (params != null) {
            if (params.containsKey((Object)"upload.limit.size") && StringUtils.isNotBlank((CharSequence)params.getValueParam("upload.limit.size").getValue())) {
                this.maxUploadSize = Integer.parseInt(params.getValueParam("upload.limit.size").getValue());
            }
            if (params.containsKey((Object)ENABLE_EDIT_ACTIVITY)) {
                this.enableEditActivity = Boolean.parseBoolean(params.getValueParam(ENABLE_EDIT_ACTIVITY).getValue());
            }
            if (params.containsKey((Object)ENABLE_EDIT_COMMENT)) {
                this.enableEditComment = Boolean.parseBoolean(params.getValueParam(ENABLE_EDIT_COMMENT).getValue());
            }
            if (params.containsKey((Object)ENABLE_USER_COMPOSER)) {
                this.enableUserComposer = Boolean.parseBoolean(params.getValueParam(ENABLE_USER_COMPOSER).getValue());
            }
        } else {
            String maxUploadString = System.getProperty("wcm.connector.drives.uploadLimit");
            if (StringUtils.isNotBlank((CharSequence)maxUploadString)) {
                this.maxUploadSize = Integer.parseInt(maxUploadString);
            }
        }
    }

    public ActivityManagerImpl(ActivityStorage activityStorage, IdentityManager identityManager, SpaceService spaceService, UserACL userACL, InitParams params) {
        this(activityStorage, identityManager, spaceService, null, userACL, params);
    }

    public void saveActivityNoReturn(org.exoplatform.social.core.identity.model.Identity streamOwner, ExoSocialActivity newActivity) {
        if (!streamOwner.isEnable()) {
            LOG.warn((Object)"Activity could not be saved. Owner has been disabled.");
            return;
        }
        if (newActivity.getType() != null && activityTypesRegistry.get(newActivity.getType()) != null && !activityTypesRegistry.get(newActivity.getType()).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activity could not be saved. Activity Type {} has been disabled.", new Object[]{newActivity.getType()});
            }
            return;
        }
        ExoSocialActivity savedActivity = this.activityStorage.saveActivity(streamOwner, newActivity);
        newActivity.setId(savedActivity.getId());
        this.activityLifeCycle.saveActivity(newActivity);
    }

    public void saveActivityNoReturn(ExoSocialActivity newActivity) {
        org.exoplatform.social.core.identity.model.Identity owner = this.getStreamOwner(newActivity);
        this.saveActivityNoReturn(owner, newActivity);
    }

    public List<ExoSocialActivity> shareActivity(ExoSocialActivity activityTemplate, String activityId, List<String> targetSpaces, Identity viewer) throws ObjectNotFoundException, IllegalAccessException {
        ActivityShareAction activityShareAction = new ActivityShareAction();
        activityShareAction.setActivityId(Long.parseLong(activityId));
        activityShareAction.setSpaceIds(targetSpaces.stream().map(prettyName -> {
            Space space = this.spaceService.getSpaceByPrettyName(prettyName);
            if (space == null) {
                LOG.warn("Can't find space with pretty name {}", new Object[]{prettyName});
                return null;
            }
            return Long.parseLong(space.getId());
        }).collect(Collectors.toSet()));
        return this.shareActivity(activityTemplate, activityShareAction, viewer);
    }

    public List<ExoSocialActivity> shareActivity(ExoSocialActivity activityTemplate, ActivityShareAction activityShareAction, Identity viewer) throws ObjectNotFoundException, IllegalAccessException {
        if (activityShareAction == null) {
            throw new IllegalArgumentException("activityShareAction is mandatory");
        }
        long activityId = activityShareAction.getActivityId();
        if (activityId <= 0L) {
            throw new IllegalArgumentException("activityId is mandatory");
        }
        ExoSocialActivity activity = this.getActivity(String.valueOf(activityId));
        if (activity == null) {
            throw new ObjectNotFoundException("Activity with id " + activityId + " wasn't found");
        }
        Set spaceIds = activityShareAction.getSpaceIds();
        if (CollectionUtils.isEmpty((Collection)spaceIds)) {
            throw new IllegalArgumentException("spaceIds is mandatory");
        }
        if (viewer == null) {
            throw new IllegalAccessException("viewer is mandatory");
        }
        String userId = viewer.getUserId();
        org.exoplatform.social.core.identity.model.Identity viewerIdentity = this.identityManager.getOrCreateUserIdentity(userId);
        if (viewerIdentity == null || !this.isActivityViewable(activity, viewer)) {
            throw new IllegalAccessException("User " + userId + " can't access activity");
        }
        this.checkCanShareActivityToSpaces(spaceIds, viewer);
        activityShareAction.setUserIdentityId(Long.parseLong(viewerIdentity.getId()));
        List<ExoSocialActivity> sharedActivities = this.createShareActivities(activityTemplate, activityShareAction, viewerIdentity.getId());
        Set sharedActivityIds = sharedActivities.stream().map(tmpActivity -> Long.parseLong(tmpActivity.getId())).collect(Collectors.toSet());
        activityShareAction.setSharedActivityIds(sharedActivityIds);
        this.activityStorage.createShareActivityAction(activityShareAction);
        for (ExoSocialActivity sharedActivity : sharedActivities) {
            this.activityLifeCycle.shareActivity(sharedActivity);
        }
        return sharedActivities;
    }

    public ExoSocialActivity getActivity(String activityId) {
        return this.activityStorage.getActivity(activityId);
    }

    public ExoSocialActivity getParentActivity(ExoSocialActivity comment) {
        return this.activityStorage.getParentActivity(comment);
    }

    public List<ExoSocialActivity> getSubComments(ExoSocialActivity comment) {
        return this.activityStorage.getSubComments(comment);
    }

    public void updateActivity(ExoSocialActivity existingActivity) {
        this.updateActivity(existingActivity, true);
    }

    public void updateActivity(ExoSocialActivity existingActivity, boolean broadcast) {
        String activityId = existingActivity.getId();
        CharSequence[] previousMentions = this.getActivity(activityId).getMentionedIds();
        this.activityStorage.updateActivity(existingActivity);
        if (previousMentions.length > 0) {
            String mentions = String.join((CharSequence)",", previousMentions);
            Map mentionsTemplateParams = existingActivity.getTemplateParams() != null ? existingActivity.getTemplateParams() : new HashMap();
            mentionsTemplateParams.put("PreviousMentions", mentions);
            existingActivity.setTemplateParams(mentionsTemplateParams);
        }
        if (broadcast) {
            if (existingActivity.isComment() || StringUtils.isNotBlank((CharSequence)existingActivity.getParentId())) {
                this.activityLifeCycle.updateComment(existingActivity);
            } else {
                this.activityLifeCycle.updateActivity(existingActivity);
            }
        }
    }

    public void deleteActivity(ExoSocialActivity existingActivity) {
        Validate.notNull((Object)existingActivity, (String)"existingActivity must not be null!");
        Validate.notNull((Object)existingActivity.getId(), (String)"existingActivity.getId() must not be null!");
        if (existingActivity.isComment() || existingActivity.getParentId() != null) {
            this.activityStorage.deleteComment(existingActivity.getParentId(), existingActivity.getId());
            this.activityLifeCycle.deleteComment(existingActivity);
        } else {
            this.activityStorage.deleteActivity(existingActivity.getId());
            this.activityLifeCycle.deleteActivity(existingActivity);
        }
    }

    public void deleteActivity(String activityId) {
        Validate.notNull((Object)activityId, (String)"activityId must not be null!");
        this.deleteActivity(this.getActivity(activityId));
    }

    public ExoSocialActivity hideActivity(String activityId) {
        if (StringUtils.isBlank((CharSequence)activityId)) {
            throw new IllegalArgumentException("activityId is mandatory");
        }
        ExoSocialActivity activity = this.activityStorage.hideActivity(activityId);
        this.activityLifeCycle.hideActivity(activity);
        return activity;
    }

    public void saveComment(ExoSocialActivity existingActivity, ExoSocialActivity comment) {
        boolean activityTypeDisabled;
        if (existingActivity == null) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_SAVE_COMMENT, "Activity cannot be NULL");
        }
        if (existingActivity.getId() == null) {
            LOG.debug((Object)"Comment could not be saved because activity id is null.");
            return;
        }
        String activityType = existingActivity.getType();
        String commentActivityType = comment.getType();
        String commentId = comment.getId();
        boolean commentActivityTypeDisabled = commentActivityType != null && activityTypesRegistry.containsKey(commentActivityType) && activityTypesRegistry.get(commentActivityType) == Boolean.FALSE;
        boolean bl = activityTypeDisabled = activityType != null && activityTypesRegistry.containsKey(activityType) && activityTypesRegistry.get(activityType) == Boolean.FALSE;
        if (commentActivityTypeDisabled || activityTypeDisabled) {
            if (LOG.isDebugEnabled()) {
                if (activityTypeDisabled) {
                    LOG.debug("Comment could not be saved. Activity Type {} is disabled.", new Object[]{activityType});
                }
                if (commentActivityTypeDisabled) {
                    LOG.debug("Comment could not be saved. Comment activity Type {} is disabled.", new Object[]{commentActivityType});
                }
            }
            return;
        }
        CharSequence[] previousMentions = StringUtils.isEmpty((CharSequence)commentId) ? new String[]{} : this.getActivity(commentId).getMentionedIds();
        this.activityStorage.saveComment(existingActivity, comment);
        if (StringUtils.isEmpty((CharSequence)commentId)) {
            this.activityLifeCycle.saveComment(comment);
        } else {
            if (previousMentions.length > 0) {
                String mentions = String.join((CharSequence)",", previousMentions);
                Map mentionsTemplateParams = comment.getTemplateParams() != null ? comment.getTemplateParams() : new HashMap();
                mentionsTemplateParams.put("PreviousMentions", mentions);
                comment.setTemplateParams(mentionsTemplateParams);
            }
            this.activityLifeCycle.updateComment(comment);
        }
    }

    public RealtimeListAccess<ExoSocialActivity> getCommentsWithListAccess(ExoSocialActivity existingActivity, boolean loadSubComments, boolean sortDescending) {
        return new CommentsRealtimeListAccess(this.activityStorage, existingActivity, loadSubComments, sortDescending);
    }

    public RealtimeListAccess<ExoSocialActivity> getCommentsWithListAccess(ExoSocialActivity existingActivity, boolean loadSubComments) {
        return new CommentsRealtimeListAccess(this.activityStorage, existingActivity, loadSubComments);
    }

    public RealtimeListAccess<ExoSocialActivity> getCommentsWithListAccess(ExoSocialActivity existingActivity) {
        return new CommentsRealtimeListAccess(this.activityStorage, existingActivity);
    }

    public void deleteComment(String activityId, String commentId) {
        Validate.notNull((Object)activityId, (String)"activityId must not be null!");
        Validate.notNull((Object)commentId, (String)"commentId must not be null!");
        this.deleteComment(this.getActivity(activityId), this.getActivity(commentId));
    }

    public void deleteComment(ExoSocialActivity existingActivity, ExoSocialActivity existingComment) {
        Validate.notNull((Object)existingActivity, (String)"existingActivity must not be null!");
        Validate.notNull((Object)existingActivity.getId(), (String)"existingActivity.getId() must not be null!");
        Validate.notNull((Object)existingComment, (String)"existingComment must not be null!");
        Validate.notNull((Object)existingComment.getId(), (String)"existingComment.getId() must not be null!");
        this.activityStorage.deleteComment(existingActivity.getId(), existingComment.getId());
        this.activityLifeCycle.deleteComment(existingComment);
    }

    public void saveLike(ExoSocialActivity existingActivity, org.exoplatform.social.core.identity.model.Identity identity) {
        existingActivity.setTitle(null);
        existingActivity.setBody(null);
        existingActivity.setTemplateParams(null);
        Object[] identityIds = existingActivity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            LOG.warn((Object)("activity is already liked by identity: " + identity));
            return;
        }
        identityIds = (String[])ArrayUtils.add((Object[])identityIds, (Object)identity.getId());
        existingActivity.setLikeIdentityIds((String[])identityIds);
        this.updateActivity(existingActivity, false);
        if (existingActivity.isComment()) {
            this.activityLifeCycle.likeComment(existingActivity);
        } else {
            this.activityLifeCycle.likeActivity(existingActivity);
        }
    }

    public void deleteLike(ExoSocialActivity activity, org.exoplatform.social.core.identity.model.Identity identity) {
        activity.setTitle(null);
        activity.setBody(null);
        activity.setTemplateParams(null);
        Object[] identityIds = activity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            identityIds = (String[])ArrayUtils.removeElement((Object[])identityIds, (Object)identity.getId());
            activity.setLikeIdentityIds((String[])identityIds);
            this.updateActivity(activity, false);
        }
    }

    public void addActivityEventListener(ActivityListenerPlugin activityListenerPlugin) {
        this.registerActivityListener((ActivityListener)activityListenerPlugin);
    }

    public void registerActivityListener(ActivityListener listener) {
        this.activityLifeCycle.addListener((LifeCycleListener)listener);
    }

    public void unregisterActivityListener(ActivityListener listener) {
        this.activityLifeCycle.removeListener((LifeCycleListener)listener);
    }

    public RealtimeListAccess<ExoSocialActivity> getActivitiesWithListAccess(org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.USER_ACTIVITIES, existingIdentity);
    }

    public RealtimeListAccess<ExoSocialActivity> getActivitiesWithListAccess(org.exoplatform.social.core.identity.model.Identity ownerIdentity, org.exoplatform.social.core.identity.model.Identity viewerIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.VIEW_USER_ACTIVITIES, ownerIdentity, viewerIdentity);
    }

    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfConnectionsWithListAccess(org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.CONNECTIONS_ACTIVITIES, existingIdentity);
    }

    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfUserSpacesWithListAccess(org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.USER_SPACE_ACTIVITIES, existingIdentity);
    }

    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfSpaceWithListAccess(org.exoplatform.social.core.identity.model.Identity existingSpaceIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.SPACE_ACTIVITIES, existingSpaceIdentity);
    }

    public RealtimeListAccess<ExoSocialActivity> getActivityFeedWithListAccess(org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.ACTIVITY_FEED, existingIdentity);
    }

    public RealtimeListAccess<ExoSocialActivity> getActivitiesByPoster(org.exoplatform.social.core.identity.model.Identity posterIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.POSTER_ACTIVITIES, posterIdentity);
    }

    public RealtimeListAccess<ExoSocialActivity> getActivitiesByPoster(org.exoplatform.social.core.identity.model.Identity posterIdentity, String ... activityTypes) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.POSTER_AND_TYPES_ACTIVITIES, posterIdentity, activityTypes);
    }

    public void addProcessor(ActivityProcessor processor) {
        this.activityStorage.getActivityProcessors().add(processor);
        LOG.debug((Object)("added activity processor " + processor.getClass()));
    }

    public void addProcessorPlugin(BaseActivityProcessorPlugin plugin) {
        this.addProcessor((ActivityProcessor)plugin);
    }

    public void addSystemActivityDefinition(ActivitySystemTypePlugin activitySystemTypePlugin) {
        if (CollectionUtils.isNotEmpty((Collection)activitySystemTypePlugin.getSystemActivityTitleIds())) {
            this.systemActivityTitleIds.addAll(activitySystemTypePlugin.getSystemActivityTitleIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)activitySystemTypePlugin.getSystemActivityTypes())) {
            this.systemActivityTypes.addAll(activitySystemTypePlugin.getSystemActivityTypes());
        }
    }

    public boolean isEnableUserComposer() {
        return this.enableUserComposer;
    }

    public void initActivityTypes() {
        Properties properties = PropertyManager.getPropertiesByPattern((String)ACTIVITY_TYPE_PROPERTY_PATTERN);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String value = properties.getProperty(k.toString());
            String name = k.toString().substring(PREFIX.length(), k.toString().lastIndexOf(SUFFIX));
            if (value != null && value.equalsIgnoreCase("false")) {
                LOG.info("Activity Type key:  {},  registration status: disabled", new Object[]{name});
                activityTypesRegistry.putIfAbsent(name, false);
            } else {
                LOG.info("Activity Type key:  {},  registration status: enabled", new Object[]{name});
                activityTypesRegistry.putIfAbsent(name, true);
            }
        }));
    }

    private org.exoplatform.social.core.identity.model.Identity getStreamOwner(ExoSocialActivity newActivity) {
        Validate.notNull((Object)newActivity.getUserId(), (String)"activity.getUserId() must not be null!");
        return this.identityManager.getIdentity(newActivity.getUserId());
    }

    public RealtimeListAccess<ExoSocialActivity> getAllActivitiesWithListAccess() {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.ALL);
    }

    public int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public List<ExoSocialActivity> getActivities(List<String> activityIdList) {
        return this.activityStorage.getActivities(activityIdList);
    }

    public boolean isActivityExists(String activityId) {
        return this.activityStorage.isActivityExists(activityId);
    }

    public boolean isActivityViewable(ExoSocialActivity activity, Identity viewer) {
        String username = viewer.getUserId();
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity(username);
        if (identity == null) {
            return false;
        }
        if (StringUtils.equals((CharSequence)identity.getId(), (CharSequence)activity.getPosterId()) || StringUtils.equals((CharSequence)identity.getId(), (CharSequence)activity.getUserId())) {
            return true;
        }
        ActivityStream activityStream = null;
        if (activity.isComment()) {
            ExoSocialActivity parentActivity = this.getActivity(activity.getParentId());
            if (parentActivity == null) {
                return false;
            }
            return this.isActivityViewable(parentActivity, viewer);
        }
        activityStream = activity.getActivityStream();
        if (activityStream != null) {
            if (ActivityStream.Type.SPACE.equals((Object)activityStream.getType())) {
                return this.isSpaceMember(viewer, activityStream.getPrettyId());
            }
            if (ActivityStream.Type.USER.equals((Object)activityStream.getType()) && (StringUtils.equals((CharSequence)activityStream.getPrettyId(), (CharSequence)username) || this.isConnectedWithUserWithName(activityStream.getPrettyId(), username))) {
                return true;
            }
        }
        return StringUtils.equals((CharSequence)this.userACL.getSuperUser(), (CharSequence)username) || viewer.isMemberOf(this.userACL.getAdminGroups()) || this.hasMentioned(activity, username) || this.isConnectedWithUserWithId(activity.getPosterId(), username) || this.spaceService.isSuperManager(username);
    }

    public boolean isActivityEditable(ExoSocialActivity activity, Identity viewer) {
        if (activity != null) {
            boolean enableEdit = activity.isComment() ? this.enableEditComment : this.enableEditActivity;
            org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", viewer.getUserId());
            if (enableEdit && identity != null && StringUtils.equals((CharSequence)identity.getId(), (CharSequence)activity.getPosterId())) {
                return !this.isAutomaticActivity(activity);
            }
        }
        return false;
    }

    public boolean isActivityDeletable(ExoSocialActivity activity, Identity viewer) {
        ExoSocialActivity parentActivity;
        String username = viewer.getUserId();
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", username);
        if (identity == null) {
            return false;
        }
        if (StringUtils.equals((CharSequence)identity.getId(), (CharSequence)activity.getPosterId())) {
            return true;
        }
        ActivityStream activityStream = null;
        activityStream = activity.isComment() ? ((parentActivity = this.getActivity(activity.getParentId())) == null ? null : parentActivity.getActivityStream()) : activity.getActivityStream();
        if (activityStream != null && ActivityStream.Type.SPACE.equals((Object)activityStream.getType())) {
            return this.isManagerOrSpaceManager(viewer, activityStream.getPrettyId());
        }
        return StringUtils.equals((CharSequence)this.userACL.getSuperUser(), (CharSequence)username) || viewer.isMemberOf(this.userACL.getAdminGroups()) || this.spaceService.isSuperManager(username);
    }

    public boolean isActivityTypeEnabled(String activityType) {
        return activityTypesRegistry.get(activityType) == null || activityTypesRegistry.get(activityType) != false;
    }

    public boolean canPostActivityInStream(Identity viewer, org.exoplatform.social.core.identity.model.Identity streamOwner) {
        if (viewer == null) {
            throw new IllegalArgumentException("currentUserIdentity is mandatory");
        }
        if (streamOwner == null) {
            throw new IllegalArgumentException("streamOwner is mandatory");
        }
        if (streamOwner.isSpace()) {
            String spacePrettyName = streamOwner.getRemoteId();
            Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
            return space != null && this.spaceService.canRedactOnSpace(space, viewer);
        }
        if (streamOwner.isUser()) {
            return this.isEnableUserComposer() && StringUtils.equals((CharSequence)viewer.getUserId(), (CharSequence)streamOwner.getRemoteId());
        }
        return false;
    }

    public boolean isAutomaticActivity(ExoSocialActivity activity) {
        return activity != null && (activity.getType() != null && this.systemActivityTypes.contains(activity.getType()) || activity.getTitleId() != null && this.systemActivityTitleIds.contains(activity.getTitleId()));
    }

    private boolean isManagerOrSpaceManager(Identity viewer, String spacePrettyName) {
        String username = viewer.getUserId();
        if (viewer.isMemberOf(this.userACL.getAdminGroups()) || StringUtils.equals((CharSequence)this.userACL.getSuperUser(), (CharSequence)username)) {
            return true;
        }
        if (this.spaceService.isSuperManager(username)) {
            return true;
        }
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        return space != null && this.spaceService.isManager(space, username);
    }

    private boolean isSpaceMember(Identity viewer, String spacePrettyName) {
        String username = viewer.getUserId();
        if (StringUtils.equals((CharSequence)this.userACL.getSuperUser(), (CharSequence)username) || viewer.isMemberOf(this.userACL.getAdminGroups())) {
            return true;
        }
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        boolean isSpacesManager = this.spaceService.isSuperManager(username);
        if (space == null) {
            return isSpacesManager;
        }
        return isSpacesManager || this.spaceService.isMember(space, username);
    }

    private boolean hasMentioned(ExoSocialActivity activity, String username) {
        return activity.getMentionedIds() != null && Arrays.stream(activity.getMentionedIds()).anyMatch(mentionedId -> StringUtils.equals((CharSequence)mentionedId, (CharSequence)username) || StringUtils.startsWith((CharSequence)mentionedId, (CharSequence)(username + "@")));
    }

    private boolean isConnectedWithUserWithName(String posterName, String username) {
        org.exoplatform.social.core.identity.model.Identity poster = this.identityManager.getOrCreateIdentity("organization", posterName);
        return this.isConnectedWithUser(poster, username);
    }

    private boolean isConnectedWithUserWithId(String posterId, String username) {
        org.exoplatform.social.core.identity.model.Identity poster = this.identityManager.getIdentity(posterId);
        return this.isConnectedWithUser(poster, username);
    }

    private boolean isConnectedWithUser(org.exoplatform.social.core.identity.model.Identity poster, String username) {
        org.exoplatform.social.core.identity.model.Identity user = this.identityManager.getOrCreateUserIdentity(username);
        Relationship.Type status = this.relationshipManager.getStatus(poster, user);
        return Relationship.Type.CONFIRMED.equals((Object)status);
    }

    private List<ExoSocialActivity> createShareActivities(ExoSocialActivity activityTemplate, ActivityShareAction activityShareAction, String viewerIdentityId) {
        String title = activityTemplate == null || activityTemplate.getTitle() == null ? "" : activityTemplate.getTitle();
        String type = activityTemplate == null ? null : activityTemplate.getType();
        Map<String, String> templateParams = activityTemplate == null || activityTemplate.getTemplateParams() == null ? new HashMap() : activityTemplate.getTemplateParams();
        templateParams.put("originalActivityId", String.valueOf(activityShareAction.getActivityId()));
        if (StringUtils.isBlank((CharSequence)activityShareAction.getMessage())) {
            activityShareAction.setMessage(title);
        } else if (StringUtils.isBlank((CharSequence)title)) {
            title = activityShareAction.getMessage();
        }
        ArrayList<ExoSocialActivity> sharedActivities = new ArrayList<ExoSocialActivity>();
        for (Long spaceId : activityShareAction.getSpaceIds()) {
            Space space = this.spaceService.getSpaceById(String.valueOf(spaceId));
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
            ExoSocialActivityImpl sharedActivity = new ExoSocialActivityImpl();
            sharedActivity.setTitle(title);
            sharedActivity.setType(type);
            sharedActivity.setUserId(viewerIdentityId);
            sharedActivity.setTemplateParams(templateParams);
            this.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)sharedActivity);
            sharedActivities.add((ExoSocialActivity)sharedActivity);
        }
        return sharedActivities;
    }

    private void checkCanShareActivityToSpaces(Set<Long> spaceIds, Identity viewer) throws ObjectNotFoundException, IllegalAccessException {
        for (Long spaceId : spaceIds) {
            if (spaceId == null || spaceId == 0L) {
                throw new ObjectNotFoundException("Space id can't be null");
            }
            Space space = this.spaceService.getSpaceById(String.valueOf(spaceId));
            if (space == null) {
                throw new ObjectNotFoundException("Space with id " + spaceId + " wasn't found");
            }
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
            if (spaceIdentity == null) {
                throw new ObjectNotFoundException("Space identity " + space.getDisplayName() + " wasn't found");
            }
            if (this.canPostActivityInStream(viewer, spaceIdentity)) continue;
            throw new IllegalAccessException("User " + viewer.getUserId() + " can't post an activity on space " + space.getDisplayName());
        }
    }
}

