/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.info;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.net.media.MediaTypeMapImpl;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.info.CapabilitiesInfo;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.WindowStateInfo;
import org.gatein.pc.portlet.impl.info.ContainerModeInfo;
import org.gatein.pc.portlet.impl.info.ContainerWindowStateInfo;

public class ContainerCapabilitiesInfo
implements CapabilitiesInfo {
    private static final Logger log = LoggerFactory.getLogger(ContainerCapabilitiesInfo.class);
    private final MediaTypeMapImpl<ModeInfo> supportedModes;
    private final MediaTypeMapImpl<WindowStateInfo> supportedWindowStates;
    private final Set<Locale> supportedLocales;

    public ContainerCapabilitiesInfo() {
        MediaTypeMapImpl supportedModes = new MediaTypeMapImpl();
        supportedModes.put((Object)new ContainerModeInfo(Mode.VIEW));
        MediaTypeMapImpl supportedWindowStates = new MediaTypeMapImpl();
        supportedWindowStates.put((Object)new ContainerWindowStateInfo(WindowState.MAXIMIZED));
        supportedWindowStates.put((Object)new ContainerWindowStateInfo(WindowState.NORMAL));
        supportedWindowStates.put((Object)new ContainerWindowStateInfo(WindowState.MINIMIZED));
        this.supportedLocales = new HashSet<Locale>();
        this.supportedModes = supportedModes;
        this.supportedWindowStates = supportedWindowStates;
    }

    public void addLocale(Locale locale) {
        this.supportedLocales.add(locale);
    }

    public void add(String contentType, Mode mode) {
        this.add(contentType, new ContainerModeInfo(mode));
    }

    public void add(String contentType, ContainerModeInfo mode) {
        try {
            this.supportedModes.put(contentType, (Object)mode);
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)("'" + contentType + "' is not a valid MIME type: ignoring!"), (Throwable)e);
        }
    }

    public void add(String contentType, WindowState windowState) {
        this.add(contentType, new ContainerWindowStateInfo(windowState));
    }

    public void add(String contentType, ContainerWindowStateInfo windowState) {
        try {
            this.supportedWindowStates.put(contentType, (Object)windowState);
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)("'" + contentType + "' is not a valid MIME type: ignoring!"), (Throwable)e);
        }
    }

    public Set<ModeInfo> getModes(MediaType mimeType) {
        return this.supportedModes.resolve(mimeType);
    }

    public Set<WindowStateInfo> getWindowStates(MediaType mimeType) {
        return this.supportedWindowStates.resolve(mimeType);
    }

    public Set<Locale> getLocales(MediaType mimeType) {
        return this.supportedLocales;
    }

    public Set<MediaType> getMediaTypes() {
        return this.supportedModes.getMediaTypes();
    }

    public Set<ModeInfo> getAllModes() {
        return this.supportedModes.getValues();
    }

    public ModeInfo getMode(Mode value) {
        for (ModeInfo mode : this.getAllModes()) {
            if (!mode.getMode().equals((Object)value)) continue;
            return mode;
        }
        return null;
    }

    public Set<WindowStateInfo> getAllWindowStates() {
        return this.supportedWindowStates.getValues();
    }

    public WindowStateInfo getWindowState(WindowState value) {
        for (WindowStateInfo windowState : this.getAllWindowStates()) {
            if (!windowState.getWindowState().equals((Object)value)) continue;
            return windowState;
        }
        return null;
    }

    public Set<Locale> getAllLocales() {
        return this.supportedLocales;
    }
}

