/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.storage.dao.ConnectionDAO;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.relationship.model.Relationship;

public class ProfileIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    public static final String TYPE = "profile";
    private static final Log LOG = ExoLogger.getLogger(ProfileIndexingServiceConnector.class);
    private final IdentityManager identityManager;
    private final ConnectionDAO connectionDAO;
    private final IdentityDAO identityDAO;

    public ProfileIndexingServiceConnector(InitParams initParams, IdentityManager identityManager, IdentityDAO identityDAO, ConnectionDAO connectionDAO) {
        super(initParams);
        this.identityManager = identityManager;
        this.identityDAO = identityDAO;
        this.connectionDAO = connectionDAO;
    }

    public Document create(String id) {
        return this.getDocument(id);
    }

    public Document update(String id) {
        return this.getDocument(id);
    }

    public String getConnectorName() {
        return TYPE;
    }

    private List<String> buildConnectionString(Identity identity, Relationship.Type type) {
        int offset;
        int limit = 200;
        ArrayList<String> list = new ArrayList<String>();
        long id = Long.parseLong(identity.getId());
        boolean inSender = true;
        boolean inReceiver = true;
        if (type == Relationship.Type.OUTGOING) {
            inSender = false;
            type = Relationship.Type.PENDING;
        } else if (type == Relationship.Type.INCOMING) {
            inReceiver = false;
            type = Relationship.Type.PENDING;
        }
        if (inSender) {
            offset = 0;
            do {
                list.addAll(this.connectionDAO.getSenderIds(id, type, offset, 200).stream().map(senderId -> senderId.toString()).collect(Collectors.toList()));
                offset += 200;
            } while (list.size() >= 200);
        }
        if (inReceiver) {
            offset = 0;
            do {
                list.addAll(this.connectionDAO.getReceiverIds(id, type, offset, 200).stream().map(receiverId -> receiverId.toString()).collect(Collectors.toList()));
                offset += 200;
            } while (list.size() >= 200);
        }
        return list;
    }

    public List<String> getAllIds(int offset, int limit) {
        List<Long> ids = this.identityDAO.getAllIdsByProvider("organization", offset, limit);
        if (ids == null || ids.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>(ids.size());
        for (Long id : ids) {
            result.add(String.valueOf(id));
        }
        return result;
    }

    public String getMapping() {
        StringBuilder mapping = new StringBuilder().append("{").append("  \"properties\" : {\n").append("    \"userName\" : {\"type\" : \"keyword\"},\n").append("    \"name\" : {").append("      \"type\" : \"text\",").append("      \"index_options\": \"offsets\",").append("      \"fields\": {").append("        \"raw\": {").append("          \"type\": \"keyword\"").append("        },").append("        \"whitespace\": {").append("          \"type\": \"text\",").append("          \"analyzer\": \"whitespace_lowercase_asciifolding\"").append("        }").append("      }").append("    },\n").append("    \"firstName\" : {").append("      \"type\" : \"text\",").append("      \"index_options\": \"offsets\",").append("      \"fields\": {").append("        \"raw\": {").append("          \"type\": \"keyword\"").append("        },").append("        \"whitespace\": {").append("          \"type\": \"text\",").append("          \"analyzer\": \"whitespace_lowercase_asciifolding\"").append("        }").append("      }").append("    },\n").append("    \"lastName\" : {").append("      \"type\" : \"text\",").append("      \"index_options\": \"offsets\",").append("      \"fields\": {").append("        \"raw\": {").append("          \"type\": \"keyword\"").append("        },").append("        \"whitespace\": {").append("          \"type\": \"text\",").append("          \"analyzer\": \"whitespace_lowercase_asciifolding\"").append("        }").append("      }").append("    },\n").append("    \"email\" : {\"type\" : \"keyword\"},\n").append("    \"avatarUrl\" : {\"type\" : \"text\", \"index\": false},\n").append("    \"position\" : {\"type\" : \"text\", \"index_options\": \"offsets\"},\n").append("    \"skills\" : {\"type\" : \"text\", \"index_options\": \"offsets\"},\n").append("    \"aboutMe\" : {\"type\" : \"text\", \"index_options\": \"offsets\"},\n").append("    \"lastUpdatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"}\n").append("  }\n").append("}");
        return mapping.toString();
    }

    private Document getDocument(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        long ts = System.currentTimeMillis();
        LOG.debug("get profile document for identity id={}", new Object[]{id});
        Identity identity = this.identityManager.getIdentity(id);
        Profile profile = identity.getProfile();
        boolean isExternal = profile.getProperty("external") != null && profile.getProperty("external").equals("true");
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("name", ProfileIndexingServiceConnector.removeAccents(profile.getFullName()));
        fields.put("firstName", ProfileIndexingServiceConnector.removeAccents((String)profile.getProperty("firstName")));
        fields.put("lastName", ProfileIndexingServiceConnector.removeAccents((String)profile.getProperty("lastName")));
        fields.put("position", ProfileIndexingServiceConnector.removeAccents(profile.getPosition()));
        fields.put("aboutMe", ProfileIndexingServiceConnector.removeAccents(profile.getAboutMe()));
        fields.put("skills", ProfileIndexingServiceConnector.removeAccents((String)profile.getProperty("skills")));
        fields.put("avatarUrl", profile.getAvatarUrl());
        fields.put("userName", identity.getRemoteId());
        fields.put("email", profile.getEmail());
        fields.put("external", String.valueOf(isExternal));
        if (profile.getProperty("lastLoginTime") != null) {
            fields.put("lastLoginTime", profile.getProperty("lastLoginTime").toString());
        }
        if (profile.getProperty("enrollmentDate") != null) {
            fields.put("enrollmentDate", profile.getProperty("enrollmentDate").toString());
        }
        Date createdDate = new Date(profile.getCreatedTime());
        HashMap<String, List<String>> listFields = new HashMap<String, List<String>>();
        List<String> connectionsStr = this.buildConnectionString(identity, Relationship.Type.CONFIRMED);
        if (!connectionsStr.isEmpty()) {
            listFields.put("connections", connectionsStr);
        }
        if (!(connectionsStr = this.buildConnectionString(identity, Relationship.Type.OUTGOING)).isEmpty()) {
            listFields.put("outgoings", connectionsStr);
        }
        if (!(connectionsStr = this.buildConnectionString(identity, Relationship.Type.INCOMING)).isEmpty()) {
            listFields.put("incomings", connectionsStr);
        }
        Document document = new Document(id, null, createdDate, (Set)null, fields);
        document.setListFields(listFields);
        LOG.info("profile document generated for identity id={} remote_id={} duration_ms={}", new Object[]{id, identity.getRemoteId(), System.currentTimeMillis() - ts});
        return document;
    }

    private static String removeAccents(String string) {
        if (StringUtils.isNotBlank((String)string)) {
            string = Normalizer.normalize(string, Normalizer.Form.NFD);
            string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        }
        return string;
    }
}

