/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import org.apache.sis.index.tree.NodeType;
import org.apache.sis.index.tree.QuadTreeData;
import org.apache.sis.index.tree.Quadrant;

final class QuadTreeNode {
    private QuadTreeData[] data;
    private QuadTreeNode nw;
    private QuadTreeNode ne;
    private QuadTreeNode se;
    private QuadTreeNode sw;
    private NodeType type;
    private int id;
    private int capacity;
    private int dataCount;
    private static final int MIN_CAPACITY = 10;

    public QuadTreeNode(int n, int n2) {
        this.capacity = n2 > 0 ? n2 : 10;
        this.dataCount = 0;
        this.data = new QuadTreeData[this.capacity];
        this.type = NodeType.BLACK;
        this.nw = null;
        this.ne = null;
        this.sw = null;
        this.se = null;
        this.id = n;
    }

    public QuadTreeNode(NodeType nodeType, int n) {
        this.type = nodeType;
        this.nw = null;
        this.ne = null;
        this.sw = null;
        this.se = null;
        this.data = null;
        this.id = n;
    }

    public void addData(QuadTreeData quadTreeData) {
        if (this.dataCount < this.capacity) {
            this.data[this.dataCount] = quadTreeData;
            ++this.dataCount;
        }
    }

    public int getCount() {
        return this.dataCount;
    }

    public NodeType getNodeType() {
        return this.type;
    }

    public void setChild(QuadTreeNode quadTreeNode, Quadrant quadrant) {
        switch (quadrant) {
            case NW: {
                this.nw = quadTreeNode;
                break;
            }
            case NE: {
                this.ne = quadTreeNode;
                break;
            }
            case SW: {
                this.sw = quadTreeNode;
                break;
            }
            case SE: {
                this.se = quadTreeNode;
            }
        }
    }

    public QuadTreeNode getChild(Quadrant quadrant) {
        switch (quadrant) {
            case NW: {
                return this.nw;
            }
            case NE: {
                return this.ne;
            }
            case SW: {
                return this.sw;
            }
            case SE: {
                return this.se;
            }
        }
        return null;
    }

    public QuadTreeData[] getData() {
        return this.data;
    }

    public int getId() {
        return this.id;
    }

    public int getCapacity() {
        return this.capacity;
    }
}

