/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.RejectedExecutionException;
import javax.servlet.AsyncContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import juzu.HttpMethod;
import juzu.impl.bridge.spi.ScopedContext;
import juzu.impl.bridge.spi.servlet.ServletBridge;
import juzu.impl.bridge.spi.servlet.ServletRequestContext;
import juzu.impl.bridge.spi.servlet.ServletScopedContext;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.common.JUL;
import juzu.impl.common.Logger;
import juzu.impl.common.Tools;
import juzu.request.ApplicationContext;
import juzu.request.ClientContext;
import juzu.request.HttpContext;
import juzu.request.SecurityContext;
import juzu.request.UserContext;

public class ServletWebBridge
extends WebBridge
implements HttpContext,
ClientContext,
UserContext,
SecurityContext {
    private final ServletRequestContext ctx;
    private final HttpMethod method;
    private final ServletBridge servlet;

    public ServletWebBridge(ServletBridge servlet, ServletRequestContext ctx) {
        this.ctx = ctx;
        this.method = HttpMethod.valueOf(ctx.req.getMethod());
        this.servlet = servlet;
    }

    @Override
    public Logger getLogger(String name) {
        return JUL.getLogger(name);
    }

    @Override
    public ServletRequestContext getRequestContext() {
        return this.ctx;
    }

    public HttpServletResponse getResponse() {
        return this.ctx.resp;
    }

    @Override
    public void execute(final Runnable runnable) {
        if (!this.ctx.req.isAsyncSupported()) {
            throw new RejectedExecutionException("Async not enabled currently for this servlet");
        }
        AsyncContext context = this.ctx.beginAsync();
        ServletRequestContext.log.trace("Scheduling runnable " + runnable);
        context.start(new Runnable(){

            @Override
            public void run() {
                ServletRequestContext.log.trace("Starting runnable " + runnable);
                try {
                    runnable.run();
                    ServletRequestContext.log.trace("Ended runnable " + runnable);
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    ServletRequestContext.log.trace("Failure of runnable " + runnable, e);
                }
            }
        });
    }

    @Override
    public void renderRequestURL(Appendable appendable) throws IOException {
        appendable.append(this.ctx.req.getScheme());
        appendable.append("://");
        appendable.append(this.ctx.req.getServerName());
        int port = this.ctx.req.getServerPort();
        if (port != 80) {
            appendable.append(':').append(Integer.toString(port));
        }
        appendable.append(this.ctx.req.getContextPath());
        appendable.append(this.ctx.path);
    }

    @Override
    public ClientContext getClientContext() {
        return this;
    }

    @Override
    public HttpContext getHttpContext() {
        return this;
    }

    @Override
    public UserContext getUserContext() {
        return this;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.servlet.applicationContext;
    }

    @Override
    public ScopedContext getRequestScope(boolean create) {
        ScopedContext context = (ScopedContext)this.ctx.req.getAttribute("juzu.request_scope");
        if (context == null && create) {
            context = new ServletScopedContext(this.getLogger(ServletScopedContext.class.getName()));
            this.ctx.req.setAttribute("juzu.request_scope", (Object)context);
        }
        return context;
    }

    @Override
    public ScopedContext getFlashScope(boolean create) {
        ScopedContext context = null;
        HttpSession session = this.ctx.req.getSession(create);
        if (session != null && (context = (ScopedContext)session.getAttribute("juzu.flash_scope")) == null && create) {
            context = new ServletScopedContext(this.getLogger(ServletScopedContext.class.getName()));
            session.setAttribute("juzu.flash_scope", (Object)context);
        }
        return context;
    }

    @Override
    public ScopedContext getSessionScope(boolean create) {
        ScopedContext context = null;
        HttpSession session = this.ctx.req.getSession(create);
        if (session != null && (context = (ScopedContext)session.getAttribute("juzu.session_scope")) == null && create) {
            context = new ServletScopedContext(this.getLogger(ServletScopedContext.class.getName()));
            session.setAttribute("juzu.session_scope", (Object)context);
        }
        return context;
    }

    @Override
    public void purgeSession() {
        HttpSession session = this.ctx.req.getSession(false);
        if (session != null) {
            for (String key : Tools.list(session.getAttributeNames())) {
                session.removeAttribute(key);
            }
        }
    }

    @Override
    public String getContentType() {
        return this.ctx.req.getContentType();
    }

    @Override
    public String getCharacterEncoding() {
        return this.ctx.req.getCharacterEncoding();
    }

    @Override
    public int getContentLenth() {
        return this.ctx.req.getContentLength();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.ctx.req.getInputStream();
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public Cookie[] getCookies() {
        return this.ctx.req.getCookies();
    }

    @Override
    public String getScheme() {
        return this.ctx.req.getScheme();
    }

    @Override
    public int getServerPort() {
        return this.ctx.req.getServerPort();
    }

    @Override
    public String getServerName() {
        return this.ctx.req.getServerName();
    }

    @Override
    public String getContextPath() {
        return this.ctx.req.getContextPath();
    }

    @Override
    public Locale getLocale() {
        return this.ctx.req.getLocale();
    }

    @Override
    public Iterable<Locale> getLocales() {
        return new Iterable<Locale>(){

            @Override
            public Iterator<Locale> iterator() {
                return new Iterator<Locale>(){
                    Enumeration<Locale> e;
                    {
                        this.e = ((ServletWebBridge)ServletWebBridge.this).ctx.req.getLocales();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.e.hasMoreElements();
                    }

                    @Override
                    public Locale next() {
                        return this.e.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public String getRemoteUser() {
        return this.ctx.req.getRemoteUser();
    }

    @Override
    public Principal getUserPrincipal() {
        return this.ctx.req.getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.ctx.req.isUserInRole(role);
    }
}

