/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import java.io.Serializable;
import org.exoplatform.portal.mop.navigation.NodeChange;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.gatein.api.common.i18n.LocalizedString;
import org.gatein.api.navigation.ApiNode;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.NodeVisitor;
import org.gatein.api.navigation.Nodes;

abstract class ApiNodeChange
implements Serializable {
    protected final NodePath target;
    protected final LocalizedString displayName;
    protected final boolean displayNameChanged;

    protected ApiNodeChange(NodeContext<ApiNode> target) {
        ApiNode node = (ApiNode)target.getNode();
        this.target = node.getNodePath();
        if (node.isDisplayNameChanged()) {
            this.displayName = node.getDisplayNames();
            this.displayNameChanged = true;
        } else {
            this.displayName = null;
            this.displayNameChanged = false;
        }
    }

    public abstract void apply(ApiNode var1);

    public NodePath getTarget() {
        return this.target;
    }

    protected NodePath getNodePath(NodeContext<ApiNode> context) {
        ApiNode node = context == null ? null : (ApiNode)context.getNode();
        return node == null ? null : node.getNodePath();
    }

    protected static ApiNode getNode(ApiNode root, NodePath path) {
        ApiNode node = (ApiNode)root.getNode(path);
        if (node == null) {
            NodeVisitor visitor = Nodes.visitNodes((NodePath)path);
            root.navigation.refreshNode(root, visitor);
            node = (ApiNode)root.getNode(path);
        }
        return node;
    }

    public static final class Updated
    extends ApiNodeChange {
        private final NodeState state;

        public Updated(NodeChange.Updated<NodeContext<ApiNode>> updated) {
            super((NodeContext<ApiNode>)((NodeContext)updated.getTarget()));
            this.state = updated.getState();
        }

        @Override
        public void apply(ApiNode root) {
            ApiNode node = Updated.getNode(root, this.target);
            node.context.setState(this.state);
            if (this.displayNameChanged) {
                node.setDisplayNames(this.displayName);
            }
        }

        public NodeState getState() {
            return this.state;
        }
    }

    public static class Moved
    extends ApiNodeChange {
        private final NodePath from;
        private final NodePath to;
        private final NodePath previous;

        public Moved(NodeChange.Moved<NodeContext<ApiNode>> moved) {
            super((NodeContext<ApiNode>)((NodeContext)moved.getTarget()));
            this.from = this.getNodePath((NodeContext<ApiNode>)((NodeContext)moved.getFrom()));
            this.to = this.getNodePath((NodeContext<ApiNode>)((NodeContext)moved.getTo()));
            this.previous = this.getNodePath((NodeContext<ApiNode>)((NodeContext)moved.getPrevious()));
        }

        @Override
        public void apply(ApiNode root) {
            int index;
            ApiNode toNode = Moved.getNode(root, this.to);
            ApiNode node = Moved.getNode(root, this.from.append(new String[]{this.target.getLastSegment()}));
            int n = index = this.previous == null ? 0 : toNode.indexOf(this.previous.getLastSegment());
            if (index < 0) {
                node.moveTo(toNode);
            } else {
                node.moveTo(index, (Node)toNode);
            }
            if (this.displayNameChanged) {
                node.setDisplayNames(this.displayName);
            }
        }

        public NodePath getFrom() {
            return this.from;
        }

        public NodePath getTo() {
            return this.to;
        }

        public NodePath getPrevious() {
            return this.previous;
        }
    }

    public static class Renamed
    extends ApiNodeChange {
        private final NodePath parent;
        private final String name;

        public Renamed(NodeChange.Renamed<NodeContext<ApiNode>> renamed) {
            super((NodeContext<ApiNode>)((NodeContext)renamed.getTarget()));
            this.parent = this.getNodePath((NodeContext<ApiNode>)((NodeContext)renamed.getParent()));
            this.name = renamed.getName();
        }

        @Override
        public void apply(ApiNode root) {
            ApiNode node = Renamed.getNode(root, this.parent);
            node.context.setName(this.name);
            if (this.displayNameChanged) {
                node.setDisplayNames(this.displayName);
            }
        }

        public NodePath getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Destroyed
    extends ApiNodeChange {
        private final NodePath parent;
        private final String name;

        protected Destroyed(NodeChange.Destroyed<NodeContext<ApiNode>> destroyed) {
            super((NodeContext<ApiNode>)((NodeContext)destroyed.getTarget()));
            this.parent = this.getNodePath((NodeContext<ApiNode>)((NodeContext)destroyed.getParent()));
            this.name = ((NodeContext)destroyed.getTarget()).getName();
        }

        @Override
        public void apply(ApiNode root) {
            ApiNode node = Destroyed.getNode(root, this.parent);
            node.removeChild(this.name);
        }

        public NodePath getParent() {
            return this.parent;
        }
    }

    public static class Created
    extends ApiNodeChange {
        private final NodePath parent;
        private final NodePath previous;
        private final String name;

        public Created(NodeChange.Created<NodeContext<ApiNode>> created) {
            super((NodeContext<ApiNode>)((NodeContext)created.getTarget()));
            this.parent = this.getNodePath((NodeContext<ApiNode>)((NodeContext)created.getParent()));
            this.previous = this.getNodePath((NodeContext<ApiNode>)((NodeContext)created.getPrevious()));
            this.name = created.getName();
        }

        @Override
        public void apply(ApiNode root) {
            ApiNode node = Created.getNode(root, this.parent);
            if (!node.isChildrenLoaded()) {
                node.navigation.refreshNode(node, Nodes.visitChildren());
            }
            int index = this.previous == null ? 0 : node.indexOf(this.previous.getLastSegment()) + 1;
            Node child = index < 0 ? node.addChild(this.name) : node.addChild(index, this.name);
            if (this.displayNameChanged) {
                child.setDisplayNames(this.displayName);
            }
        }

        public NodePath getParent() {
            return this.parent;
        }

        public NodePath getPrevious() {
            return this.previous;
        }

        public String getName() {
            return this.name;
        }
    }
}

