/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

@XmlTransient
public abstract class AbstractProvider
extends DefaultOperationMethod
implements MathTransformProvider {
    private static final long serialVersionUID = 2239172887926695217L;

    AbstractProvider(Map<String, ?> map, int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(map, n, n2, parameterDescriptorGroup);
    }

    AbstractProvider(int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(AbstractProvider.toMap((IdentifiedObject)parameterDescriptorGroup), n, n2, parameterDescriptorGroup);
    }

    private static Map<String, Object> toMap(IdentifiedObject identifiedObject) {
        Collection collection;
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)identifiedObject);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", identifiedObject.getName());
        Set set = identifiedObject.getIdentifiers();
        int n = set.size();
        if (n != 0) {
            hashMap.put("identifiers", set.toArray(new ReferenceIdentifier[n]));
        }
        if ((n = (collection = identifiedObject.getAlias()).size()) != 0) {
            hashMap.put("alias", collection.toArray(new GenericName[n]));
        }
        return hashMap;
    }

    static ParameterBuilder builder() {
        return ((ParameterBuilder)new ParameterBuilder().setCodeSpace((Citation)Citations.EPSG, "EPSG")).setRequired(true);
    }

    static ParameterBuilder addNameAndLegacy(ParameterBuilder parameterBuilder, String string, String string2) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addName(string)).setDeprecated(true)).setRemarks((CharSequence)Vocabulary.formatInternational((short)96, (Object)string))).addName(string2)).setDeprecated(false)).setRemarks(null);
    }

    static ParameterBuilder addIdentifierAndLegacy(ParameterBuilder parameterBuilder, String string, String string2) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addIdentifier(string)).setDeprecated(true)).setRemarks((CharSequence)Vocabulary.formatInternational((short)96, (Object)string))).addIdentifier(string2)).setDeprecated(false)).setRemarks(null);
    }

    static ParameterDescriptor<Double> createZeroConstant(ParameterBuilder parameterBuilder) {
        Double d = 0.0;
        return parameterBuilder.createBounded(MeasurementRange.create((double)-0.0, (boolean)true, (double)d, (boolean)true, (Unit)Units.DEGREE), d);
    }

    static ParameterDescriptor<Double> createMandatoryLatitude(ParameterBuilder parameterBuilder) {
        return parameterBuilder.createBounded(-90.0, 90.0, Double.NaN, Units.DEGREE);
    }

    static ParameterDescriptor<Double> createLatitude(ParameterBuilder parameterBuilder, boolean bl) {
        return parameterBuilder.createBounded(MeasurementRange.create((double)-90.0, (boolean)bl, (double)90.0, (boolean)bl, (Unit)Units.DEGREE), 0.0);
    }

    static ParameterDescriptor<Double> createLongitude(ParameterBuilder parameterBuilder) {
        return parameterBuilder.createBounded(-180.0, 180.0, 0.0, Units.DEGREE);
    }

    static ParameterDescriptor<Double> createScale(ParameterBuilder parameterBuilder) {
        return parameterBuilder.createStrictlyPositive(1.0, Units.UNITY);
    }

    static ParameterDescriptor<Double> createShift(ParameterBuilder parameterBuilder) {
        return parameterBuilder.create(0.0, Units.METRE);
    }

    public String resolveAmbiguity(DefaultMathTransformFactory.Context context) {
        return null;
    }

    public int getEllipsoidsMask() {
        return 0;
    }

    public boolean isInvertible() {
        return false;
    }
}

