/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.DynamicPortalLayoutMatcher;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelUnmarshaller;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.UnmarshalledObject;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DynamicPortalLayoutMatcherPlugin
extends BaseComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger(DynamicPortalLayoutMatcherPlugin.class);
    private boolean enabled;
    private boolean initialized;
    private boolean useCurrentPortalLayout;
    private String layoutTemplatePath;
    private Container layoutTemplate;
    private DynamicPortalLayoutMatcher dynamicLayoutMatcher;

    public DynamicPortalLayoutMatcherPlugin(InitParams params) {
        if (params != null) {
            ValueParam enabledParam = params.getValueParam("enabled");
            this.enabled = enabledParam == null || enabledParam.getValue() == null || Boolean.parseBoolean(enabledParam.getValue().toLowerCase());
            ValueParam useCurrentPortalLayoutParam = params.getValueParam("useCurrentPortalLayout");
            this.useCurrentPortalLayout = useCurrentPortalLayoutParam == null || useCurrentPortalLayoutParam.getValue() == null || Boolean.parseBoolean(useCurrentPortalLayoutParam.getValue().toLowerCase());
            ValueParam layoutTemplatePathParam = params.getValueParam("layoutTemplatePath");
            this.layoutTemplatePath = layoutTemplatePathParam == null ? null : layoutTemplatePathParam.getValue();
            ObjectParameter matcherParam = params.getObjectParam("matcher");
            if (matcherParam == null) {
                this.enabled = false;
                LOG.warn("No matcher found for plugin {}, it will be disabled.", new Object[]{this.getName()});
            } else {
                this.dynamicLayoutMatcher = (DynamicPortalLayoutMatcher)matcherParam.getObject();
            }
        }
    }

    public PortalConfig getPortalConfigWithDynamicLayout(SiteKey siteKey, PortalConfig sitePortalConfig, PortalConfig currentSitePortalConfig) {
        if (!this.isEnabled()) {
            return null;
        }
        if (siteKey == null) {
            throw new IllegalArgumentException("Site key is mandatory");
        }
        if (currentSitePortalConfig == null) {
            LOG.warn((Object)"Current site Portalconfig is null, matcher will not be executed");
            return null;
        }
        String lastPortalSiteName = currentSitePortalConfig.getName();
        if (this.getDynamicLayoutMatcher().matches(siteKey, lastPortalSiteName)) {
            sitePortalConfig = sitePortalConfig.clone();
            if (this.isUseCurrentPortalLayout()) {
                Container portalLayout = currentSitePortalConfig.getPortalLayout();
                if (portalLayout == null) {
                    LOG.warn("Last displayed PORTAL site with name '{}' have a NULL layout. An empty layout will be used instead.", new Object[]{lastPortalSiteName});
                    sitePortalConfig.useDefaultPortalLayout();
                } else {
                    Container portalContainer = portalLayout.clone();
                    portalContainer.resetStorage();
                    sitePortalConfig.setPortalLayout(portalContainer);
                }
            } else if (this.getLayoutTemplate() != null) {
                sitePortalConfig.setPortalLayout(this.getLayoutTemplate().clone());
            }
            return sitePortalConfig;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ConfigurationManager configurationManager) {
        block9: {
            try {
                String layoutTemplateFilePath = this.getLayoutTemplatePath();
                if (StringUtils.isBlank((String)layoutTemplateFilePath)) {
                    return;
                }
                String dynamicLayoutPluginName = this.getName();
                try {
                    InputStream inputStream = configurationManager.getInputStream(layoutTemplateFilePath);
                    if (inputStream == null) {
                        LOG.warn("Can't find portal layout using path '{}'. Matcher '{}' will be ignored.", new Object[]{layoutTemplateFilePath, dynamicLayoutPluginName});
                        this.setEnabled(false);
                        break block9;
                    }
                    UnmarshalledObject obj = ModelUnmarshaller.unmarshall(PortalConfig.class, (InputStream)inputStream);
                    if (obj == null || obj.getObject() == null) {
                        LOG.warn("Can't find portal layout content in file '{}'. Matcher '{}' will be ignored.", new Object[]{layoutTemplateFilePath, dynamicLayoutPluginName});
                        this.setEnabled(false);
                        break block9;
                    }
                    PortalConfig portalConfig = (PortalConfig)obj.getObject();
                    this.setLayoutTemplate(portalConfig.getPortalLayout());
                }
                catch (Exception e) {
                    LOG.warn("An error occurred while parsing portal layout from '{}'. Matcher '{}' will be ignored.", new Object[]{layoutTemplateFilePath, dynamicLayoutPluginName, e});
                    this.setEnabled(false);
                }
            }
            finally {
                this.initialized = true;
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isUseCurrentPortalLayout() {
        return this.useCurrentPortalLayout;
    }

    public void setUseCurrentPortalLayout(boolean useCurrentPortalLayout) {
        this.useCurrentPortalLayout = useCurrentPortalLayout;
    }

    public String getLayoutTemplatePath() {
        return this.layoutTemplatePath;
    }

    public void setLayoutTemplate(Container layoutTemplatePortalConfig) {
        this.layoutTemplate = layoutTemplatePortalConfig;
    }

    public DynamicPortalLayoutMatcher getDynamicLayoutMatcher() {
        return this.dynamicLayoutMatcher;
    }

    public void setDynamicLayoutMatcher(DynamicPortalLayoutMatcher dynamicLayoutMatcher) {
        this.dynamicLayoutMatcher = dynamicLayoutMatcher;
    }

    public Container getLayoutTemplate() {
        return this.layoutTemplate == null ? null : this.layoutTemplate.clone();
    }
}

