/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.entities.domain.configuration;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.addons.gamification.entities.domain.configuration.AbstractAuditingEntity;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="GamificationBadge")
@ExoEntity
@Table(name="GAMIFICATION_BADGES")
@NamedQueries(value={@NamedQuery(name="GamificationBadge.getAllBadges", query="SELECT badge FROM GamificationBadge badge   WHERE badge.isDeleted = false ORDER BY badge.iconFileId ASC "), @NamedQuery(name="GamificationBadge.findBadgeByDomain", query="SELECT badge FROM GamificationBadge badge WHERE badge.domain = :badgeDomain  ORDER BY badge.neededScore ASC"), @NamedQuery(name="GamificationBadge.findEnabledBadgeByDomain", query="SELECT badge FROM GamificationBadge badge WHERE (badge.domain = :badgeDomain) AND (badge.enabled = true) AND badge.isDeleted = false ORDER BY badge.neededScore ASC"), @NamedQuery(name="GamificationBadge.getEnabledBadges", query="SELECT badge FROM GamificationBadge badge where badge.enabled = :isEnabled AND badge.isDeleted = false"), @NamedQuery(name="GamificationBadge.getValidBadges", query="SELECT badge FROM GamificationBadge badge where (badge.startValidityDate BETWEEN :stDate AND :edDate) AND (badge.endValidityDate BETWEEN :stDate AND :edDate) AND badge.isDeleted = 0"), @NamedQuery(name="GamificationBadge.findBadgeByNeededScore", query="SELECT badge FROM GamificationBadge badge where badge.neededScore = :neededScore  AND badge.isDeleted = false"), @NamedQuery(name="GamificationBadge.findBadgeByTitle", query="SELECT badge FROM GamificationBadge badge where badge.title = :badgeTitle"), @NamedQuery(name="GamificationBadge.findBadgeByTitleAndDomain", query="SELECT badge FROM GamificationBadge badge where badge.title = :badgeTitle and badge.domain = :domain"), @NamedQuery(name="GamificationBadge.deleteBadgeByTitle", query="DELETE FROM GamificationBadge badge WHERE badge.title = :badgeTitle"), @NamedQuery(name="GamificationBadge.deleteBadgeById", query="DELETE FROM GamificationBadge badge WHERE badge.id = :badgeId"), @NamedQuery(name="GamificationBadge.getAllBadgesWithNullDomain", query="SELECT badge FROM GamificationBadge badge where badge.domainEntity IS NULL"), @NamedQuery(name="GamificationBadge.getDomainList", query="SELECT badge.domain  FROM GamificationBadge badge GROUP BY badge.domain")})
public class BadgeEntity
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 2L;
    @Id
    @SequenceGenerator(name="SEQ_GAMIFICATION_BADGE_ID", sequenceName="SEQ_GAMIFICATION_BADGE_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_GAMIFICATION_BADGE_ID")
    @Column(name="BADGE_ID")
    protected Long id;
    @Column(name="TITLE", unique=true, nullable=false)
    protected String title;
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="NEEDED_SCORE")
    protected int neededScore;
    @Column(name="ICON_FILE_ID")
    private long iconFileId;
    @Column(name="VALIDITY_DATE_START")
    protected Date startValidityDate;
    @Column(name="VALIDITY_DATE_END")
    protected Date endValidityDate;
    @Column(name="ENABLED", nullable=false)
    protected boolean enabled;
    @Column(name="DOMAIN", nullable=false)
    protected String domain;
    @ManyToOne
    @JoinColumn(name="DOMAIN_ID")
    private DomainEntity domainEntity;
    @Column(name="DELETED", nullable=false)
    protected boolean isDeleted;

    public BadgeEntity() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getNeededScore() {
        return this.neededScore;
    }

    public void setNeededScore(int neededScore) {
        this.neededScore = neededScore;
    }

    public Date getStartValidityDate() {
        return this.startValidityDate;
    }

    public void setStartValidityDate(Date startValidityDate) {
        this.startValidityDate = startValidityDate;
    }

    public Date getEndValidityDate() {
        return this.endValidityDate;
    }

    public void setEndValidityDate(Date endValidityDate) {
        this.endValidityDate = endValidityDate;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public long getIconFileId() {
        return this.iconFileId;
    }

    public void setIconFileId(long iconFileId) {
        this.iconFileId = iconFileId;
    }

    public DomainEntity getDomainEntity() {
        return this.domainEntity;
    }

    public void setDomainEntity(DomainEntity domainEntity) {
        this.domainEntity = domainEntity;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BadgeEntity badgeEntity = (BadgeEntity)o;
        return badgeEntity.getId() != null && this.getId() != null && Objects.equals(this.getId(), badgeEntity.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public String toString() {
        return "Badge{title='" + this.title + "', needed score='" + this.neededScore + "', zone='" + this.domain + "', iconFileId='" + this.iconFileId + "', start validity date='" + this.startValidityDate + "', end validity date='" + this.endValidityDate + "', enable='" + this.enabled + "', description='" + this.description + "'}";
    }

    public BadgeEntity(Long id, String title, String description, int neededScore, long iconFileId, Date startValidityDate, Date endValidityDate, boolean enabled, String domain) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.neededScore = neededScore;
        this.iconFileId = iconFileId;
        this.startValidityDate = startValidityDate;
        this.endValidityDate = endValidityDate;
        this.enabled = enabled;
        this.domain = domain;
    }
}

