/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;

abstract class SequenceVector
extends Vector
implements Serializable {
    private static final long serialVersionUID = 2544089499300079707L;
    final Class<? extends Number> type;
    final int length;

    SequenceVector(Class<? extends Number> clazz, int n) {
        this.type = clazz;
        this.length = n;
        if (n < 0) {
            throw new IllegalArgumentException(Errors.format((short)45, "length", n));
        }
    }

    @Override
    final Vector createTransform(double d, double d2) {
        return new Doubles(Double.class, this.doubleValue(0) * d + d2, this.increment(0.0).doubleValue() * d, this.length);
    }

    @Override
    public final Class<? extends Number> getElementType() {
        return this.type;
    }

    @Override
    public final int size() {
        return this.length;
    }

    @Override
    public final Number set(int n, Number number) {
        throw new UnsupportedOperationException(Errors.format((short)175, number));
    }

    @Override
    public final Vector compress(double d) {
        return this;
    }

    @Override
    public double[] doubleValues() {
        if (this.increment(0.0).doubleValue() == 0.0) {
            double[] dArray = new double[this.size()];
            Arrays.fill(dArray, this.doubleValue(0));
            return dArray;
        }
        return super.doubleValues();
    }

    @Override
    public float[] floatValues() {
        if (this.increment(0.0).doubleValue() == 0.0) {
            float[] fArray = new float[this.size()];
            Arrays.fill(fArray, this.floatValue(0));
            return fArray;
        }
        return super.floatValues();
    }

    static final class Longs
    extends SequenceVector {
        private static final long serialVersionUID = 8959308953555132379L;
        private final long first;
        private final long increment;

        Longs(Class<? extends Number> clazz, Number number, Number number2, int n) {
            super(clazz, n);
            this.first = number.longValue();
            this.increment = number2.longValue();
        }

        @Override
        Vector createSubSampling(int n, int n2, int n3) {
            return new Longs(this.type, this.longValue(n), this.increment * (long)n2, n3);
        }

        @Override
        public boolean isInteger() {
            return true;
        }

        @Override
        public boolean isNaN(int n) {
            return false;
        }

        @Override
        public double doubleValue(int n) {
            return this.longValue(n);
        }

        @Override
        public float floatValue(int n) {
            return this.longValue(n);
        }

        @Override
        public long longValue(int n) {
            ArgumentChecks.ensureValidIndex(this.length, n);
            return this.first + this.increment * (long)n;
        }

        @Override
        public String stringValue(int n) {
            return String.valueOf(this.longValue(n));
        }

        @Override
        public Number get(int n) {
            return Numbers.wrap(this.longValue(n), this.type);
        }

        @Override
        public Number increment(double d) {
            return Numbers.wrap(this.increment, this.type);
        }

        @Override
        public NumberRange<?> range() {
            long l = this.first + this.increment * (long)(this.length - 1);
            long l2 = this.first;
            if (l < l2) {
                l2 = l;
                l = this.first;
            }
            return new NumberRange(this.type, Numbers.wrap(l2, this.type), true, Numbers.wrap(l, this.type), true);
        }
    }

    static final class Floats
    extends Doubles {
        private static final long serialVersionUID = 7972249253456554448L;

        Floats(Class<? extends Number> clazz, Number number, Number number2, int n) {
            super(clazz, number, number2, n);
        }

        @Override
        Vector createSubSampling(int n, int n2, int n3) {
            return new Floats(this.type, this.doubleValue(n), this.increment * (double)n2, n3);
        }

        @Override
        public Number get(int n) {
            return Float.valueOf(this.floatValue(n));
        }

        @Override
        public String stringValue(int n) {
            return String.valueOf(this.floatValue(n));
        }
    }

    static class Doubles
    extends SequenceVector {
        private static final long serialVersionUID = -5222432536264284005L;
        private final double first;
        final double increment;

        Doubles(Class<? extends Number> clazz, Number number, Number number2, int n) {
            super(clazz, n);
            this.first = number.doubleValue();
            this.increment = number2.doubleValue();
        }

        @Override
        Vector createSubSampling(int n, int n2, int n3) {
            return new Doubles(this.type, this.doubleValue(n), this.increment * (double)n2, n3);
        }

        @Override
        public final boolean isInteger() {
            return Math.floor(this.first) == this.first && Math.floor(this.increment) == this.increment;
        }

        @Override
        public final boolean isNaN(int n) {
            return Double.isNaN(this.first) || Double.isNaN(this.increment);
        }

        @Override
        public final double doubleValue(int n) {
            ArgumentChecks.ensureValidIndex(this.length, n);
            return this.first + this.increment * (double)n;
        }

        @Override
        public String stringValue(int n) {
            return String.valueOf(this.doubleValue(n));
        }

        @Override
        public Number get(int n) {
            return Numbers.wrap(this.doubleValue(n), this.type);
        }

        @Override
        public final Number increment(double d) {
            return Numerics.valueOf(this.increment);
        }

        @Override
        public final NumberRange<?> range() {
            Number number = this.get(0);
            Number number2 = this.get(this.length - 1);
            if (((Comparable)((Object)number2)).compareTo((Comparable)((Object)number)) < 0) {
                Number number3 = number;
                number = number2;
                number2 = number3;
            }
            return new NumberRange<Number>(this.type, number, true, number2, true);
        }
    }
}

