/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.RDBMSRelationshipStorageImpl;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.RelationshipStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;
import org.exoplatform.social.core.storage.cache.CacheType;
import org.exoplatform.social.core.storage.cache.CachedIdentityStorage;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;
import org.exoplatform.social.core.storage.cache.loader.ServiceContext;
import org.exoplatform.social.core.storage.cache.model.data.IdentityData;
import org.exoplatform.social.core.storage.cache.model.data.IntegerData;
import org.exoplatform.social.core.storage.cache.model.data.ListActivitiesData;
import org.exoplatform.social.core.storage.cache.model.data.ListIdentitiesData;
import org.exoplatform.social.core.storage.cache.model.data.RelationshipData;
import org.exoplatform.social.core.storage.cache.model.data.SuggestionsData;
import org.exoplatform.social.core.storage.cache.model.key.ActivityCountKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityFilterKey;
import org.exoplatform.social.core.storage.cache.model.key.IdentityKey;
import org.exoplatform.social.core.storage.cache.model.key.ListActivitiesKey;
import org.exoplatform.social.core.storage.cache.model.key.ListRelationshipsKey;
import org.exoplatform.social.core.storage.cache.model.key.RelationshipCountKey;
import org.exoplatform.social.core.storage.cache.model.key.RelationshipIdentityKey;
import org.exoplatform.social.core.storage.cache.model.key.RelationshipKey;
import org.exoplatform.social.core.storage.cache.model.key.RelationshipType;
import org.exoplatform.social.core.storage.cache.model.key.SuggestionKey;
import org.exoplatform.social.core.storage.cache.selector.CacheSelector;
import org.exoplatform.social.core.storage.cache.selector.RelationshipCacheSelector;
import org.exoplatform.social.core.storage.cache.selector.SuggestionCacheSelector;

public class CachedRelationshipStorage
implements RelationshipStorage {
    private static final Log LOG = ExoLogger.getLogger(CachedRelationshipStorage.class);
    private final ExoCache<RelationshipKey, RelationshipData> exoRelationshipCache;
    private final ExoCache<RelationshipIdentityKey, RelationshipKey> exoRelationshipByIdentityCache;
    private final ExoCache<RelationshipCountKey, IntegerData> exoRelationshipCountCache;
    private final ExoCache<ListRelationshipsKey, ListIdentitiesData> exoRelationshipsCache;
    private final ExoCache<SuggestionKey, SuggestionsData> exoSuggestionCache;
    private final ExoCache<ActivityCountKey, IntegerData> exoActivitiesCountCache;
    private final ExoCache<ListActivitiesKey, ListActivitiesData> exoActivitiesCache;
    private final FutureExoCache<RelationshipKey, RelationshipData, ServiceContext<RelationshipData>> relationshipCache;
    private final FutureExoCache<RelationshipIdentityKey, RelationshipKey, ServiceContext<RelationshipKey>> relationshipCacheIdentity;
    private final FutureExoCache<RelationshipCountKey, IntegerData, ServiceContext<IntegerData>> relationshipsCount;
    private final FutureExoCache<ListRelationshipsKey, ListIdentitiesData, ServiceContext<ListIdentitiesData>> relationshipsCache;
    private final FutureExoCache<SuggestionKey, SuggestionsData, ServiceContext<SuggestionsData>> suggestionCache;
    private final ExoCache<IdentityKey, IdentityData> exoIdentityCache;
    private final RelationshipStorage storage;
    private final IdentityStorage identityStorage;
    private static RelationshipKey RELATIONSHIP_NOT_FOUND = new RelationshipKey(null);

    void clearCacheFor(Relationship r) {
        ArrayList<String> identities = new ArrayList<String>();
        if (r.getSender() != null) {
            identities.add(r.getSender().getId());
        }
        if (r.getReceiver() != null) {
            identities.add(r.getReceiver().getId());
        }
        try {
            this.exoRelationshipsCache.select((CachedObjectSelector)new RelationshipCacheSelector(identities.toArray(new String[0])));
            this.exoRelationshipCountCache.select((CachedObjectSelector)new RelationshipCacheSelector(identities.toArray(new String[0])));
            this.exoSuggestionCache.select((CachedObjectSelector)new SuggestionCacheSelector(identities.toArray(new String[0])));
            this.exoActivitiesCache.select(new CacheSelector());
            this.exoActivitiesCountCache.select(new CacheSelector());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public void clearAllRelationshipCache() {
        try {
            this.exoRelationshipsCache.clearCache();
            this.exoRelationshipCountCache.clearCache();
            this.exoSuggestionCache.clearCache();
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    private List<Identity> buildRelationships(ListIdentitiesData data) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        for (IdentityKey k : data.getIds()) {
            Identity gotIdentity = this.identityStorage.findIdentityById(k.getId());
            identities.add(gotIdentity);
        }
        return identities;
    }

    private ListIdentitiesData buildIds(List<Identity> identities) {
        ArrayList<IdentityKey> data = new ArrayList<IdentityKey>();
        for (Identity i : identities) {
            IdentityKey k = new IdentityKey(i);
            if (this.exoIdentityCache.get((Serializable)k) == null) {
                this.exoIdentityCache.putLocal((Serializable)k, (Object)new IdentityData(i));
            }
            data.add(new IdentityKey(i));
        }
        return new ListIdentitiesData((List<IdentityKey>)data);
    }

    private SuggestionsData buildIdMap(Map<Identity, Integer> map) {
        LinkedHashMap<String, Integer> data = new LinkedHashMap<String, Integer>();
        for (Map.Entry<Identity, Integer> item : map.entrySet()) {
            data.put(item.getKey().getId(), item.getValue());
        }
        return new SuggestionsData(data);
    }

    private Map<Identity, Integer> buildSuggestions(SuggestionsData data) {
        LinkedHashMap<Identity, Integer> suggestions = new LinkedHashMap<Identity, Integer>();
        for (Map.Entry<String, Integer> item : data.getMap().entrySet()) {
            Identity gotIdentity = this.identityStorage.findIdentityById(item.getKey());
            suggestions.put(gotIdentity, item.getValue());
        }
        return suggestions;
    }

    private void removeIdentityCache(Identity identity) {
        if (this.identityStorage instanceof CachedIdentityStorage) {
            ((CachedIdentityStorage)this.identityStorage).clearIdentityCache(identity, false);
        }
    }

    public CachedRelationshipStorage(RDBMSRelationshipStorageImpl storage, IdentityStorage identityStorage, SocialStorageCacheService cacheService) {
        this.storage = storage;
        this.identityStorage = identityStorage;
        this.exoRelationshipCache = cacheService.getRelationshipCache();
        this.exoRelationshipByIdentityCache = cacheService.getRelationshipCacheByIdentity();
        this.exoRelationshipCountCache = cacheService.getRelationshipsCount();
        this.exoRelationshipsCache = cacheService.getRelationshipsCache();
        this.exoSuggestionCache = cacheService.getSuggestionCache();
        this.exoActivitiesCountCache = cacheService.getActivitiesCountCache();
        this.exoActivitiesCache = cacheService.getActivitiesCache();
        this.relationshipCache = CacheType.RELATIONSHIP.createFutureCache(this.exoRelationshipCache);
        this.relationshipCacheIdentity = CacheType.RELATIONSHIP_FROM_IDENTITY.createFutureCache(this.exoRelationshipByIdentityCache);
        this.relationshipsCount = CacheType.RELATIONSHIPS_COUNT.createFutureCache(this.exoRelationshipCountCache);
        this.relationshipsCache = CacheType.RELATIONSHIPS.createFutureCache(this.exoRelationshipsCache);
        this.suggestionCache = CacheType.SUGGESTIONS.createFutureCache(this.exoSuggestionCache);
        this.exoIdentityCache = cacheService.getIdentityCache();
    }

    public Relationship saveRelationship(Relationship relationship) throws RelationshipStorageException {
        Relationship r = this.storage.saveRelationship(relationship);
        RelationshipIdentityKey identityKey1 = new RelationshipIdentityKey(r.getSender().getId(), r.getReceiver().getId());
        RelationshipIdentityKey identityKey2 = new RelationshipIdentityKey(r.getReceiver().getId(), r.getSender().getId());
        RelationshipKey key = new RelationshipKey(relationship.getId());
        this.exoRelationshipCache.put((Serializable)key, (Object)new RelationshipData(r));
        this.exoRelationshipByIdentityCache.put((Serializable)identityKey1, (Object)key);
        this.exoRelationshipByIdentityCache.put((Serializable)identityKey2, (Object)key);
        this.removeIdentityCache(r.getSender());
        this.removeIdentityCache(r.getReceiver());
        this.clearCacheFor(relationship);
        return r;
    }

    public void removeRelationship(Relationship relationship) throws RelationshipStorageException {
        this.storage.removeRelationship(relationship);
        this.exoRelationshipCache.remove((Serializable)new RelationshipKey(relationship.getId()));
        if (relationship.getSender() != null && relationship.getReceiver() != null) {
            RelationshipIdentityKey identityKey = new RelationshipIdentityKey(relationship.getSender().getId(), relationship.getReceiver().getId());
            this.relationshipCacheIdentity.remove((Serializable)identityKey);
            identityKey = new RelationshipIdentityKey(relationship.getReceiver().getId(), relationship.getSender().getId());
            this.relationshipCacheIdentity.remove((Serializable)identityKey);
            this.removeIdentityCache(relationship.getSender());
            this.removeIdentityCache(relationship.getReceiver());
        }
        this.clearCacheFor(relationship);
    }

    public Relationship getRelationship(final String uuid) throws RelationshipStorageException {
        RelationshipKey key = new RelationshipKey(uuid);
        RelationshipData data = (RelationshipData)this.relationshipCache.get((Object)new ServiceContext<RelationshipData>(){

            @Override
            public RelationshipData execute() {
                Relationship got = CachedRelationshipStorage.this.storage.getRelationship(uuid);
                if (got != null) {
                    return new RelationshipData(CachedRelationshipStorage.this.storage.getRelationship(uuid));
                }
                return null;
            }
        }, (Object)key);
        if (data != null) {
            return data.build();
        }
        return null;
    }

    public List<Relationship> getSenderRelationships(Identity sender, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        return this.storage.getSenderRelationships(sender, type, listCheckIdentity);
    }

    public List<Relationship> getSenderRelationships(String senderId, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        return this.storage.getSenderRelationships(senderId, type, listCheckIdentity);
    }

    public List<Relationship> getReceiverRelationships(Identity receiver, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        return this.storage.getReceiverRelationships(receiver, type, listCheckIdentity);
    }

    public Relationship getRelationship(Identity identity1, Identity identity2) throws RelationshipStorageException {
        Identity idLast;
        Identity idFirst;
        if (identity1 == null || identity2 == null || StringUtils.isBlank((String)identity1.getId()) || StringUtils.isBlank((String)identity2.getId()) || identity1.getId().trim().equals(identity2.getId().trim())) {
            return null;
        }
        if (identity1.getId().compareTo(identity2.getId()) > 0) {
            idFirst = identity1;
            idLast = identity2;
        } else {
            idFirst = identity2;
            idLast = identity1;
        }
        RelationshipIdentityKey key = new RelationshipIdentityKey(idFirst.getId(), idLast.getId());
        RelationshipKey gotKey = (RelationshipKey)this.relationshipCacheIdentity.get((Object)new ServiceContext<RelationshipKey>(){

            @Override
            public RelationshipKey execute() {
                Relationship got = CachedRelationshipStorage.this.storage.getRelationship(idFirst, idLast);
                if (got != null) {
                    RelationshipKey k = new RelationshipKey(got.getId());
                    return k;
                }
                return RELATIONSHIP_NOT_FOUND;
            }
        }, (Object)key);
        if (gotKey != null && !gotKey.equals(RELATIONSHIP_NOT_FOUND)) {
            return this.getRelationship(gotKey.getId());
        }
        return null;
    }

    public boolean hasRelationship(Identity identity1, Identity identity2, String relationshipPath) throws RelationshipStorageException {
        RelationshipIdentityKey key = new RelationshipIdentityKey(identity2.getId(), identity1.getId());
        RelationshipKey gotKey = (RelationshipKey)this.exoRelationshipByIdentityCache.get((Serializable)key);
        if (gotKey != null && !gotKey.equals(RELATIONSHIP_NOT_FOUND) && this.getRelationship(identity1, identity2).getStatus().equals((Object)Relationship.Type.CONFIRMED)) {
            return true;
        }
        key = new RelationshipIdentityKey(identity1.getId(), identity2.getId());
        gotKey = (RelationshipKey)this.exoRelationshipByIdentityCache.get((Serializable)key);
        if (gotKey != null && !gotKey.equals(RELATIONSHIP_NOT_FOUND) && this.getRelationship(identity1, identity2).getStatus().equals((Object)Relationship.Type.CONFIRMED)) {
            return true;
        }
        return this.storage.hasRelationship(identity1, identity2, relationshipPath);
    }

    public List<Relationship> getRelationships(Identity identity, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        return this.storage.getRelationships(identity, type, listCheckIdentity);
    }

    public List<Identity> getRelationships(final Identity identity, final long offset, final long limit) throws RelationshipStorageException {
        IdentityKey key = new IdentityKey(identity);
        ListRelationshipsKey<IdentityKey> listKey = new ListRelationshipsKey<IdentityKey>(key, RelationshipType.RELATIONSHIP, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.relationshipsCache.get((Object)new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List got = CachedRelationshipStorage.this.storage.getRelationships(identity, offset, limit);
                return CachedRelationshipStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildRelationships(keys);
    }

    public List<Identity> getIncomingRelationships(final Identity receiver, final long offset, final long limit) throws RelationshipStorageException {
        IdentityKey key = new IdentityKey(receiver);
        ListRelationshipsKey<IdentityKey> listKey = new ListRelationshipsKey<IdentityKey>(key, RelationshipType.INCOMMING, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.relationshipsCache.get((Object)new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List got = CachedRelationshipStorage.this.storage.getIncomingRelationships(receiver, offset, limit);
                return CachedRelationshipStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildRelationships(keys);
    }

    public int getIncomingRelationshipsCount(final Identity receiver) throws RelationshipStorageException {
        IdentityKey iKey = new IdentityKey(receiver);
        RelationshipCountKey<IdentityKey> key = new RelationshipCountKey<IdentityKey>(iKey, RelationshipType.INCOMMING);
        return (Integer)((IntegerData)this.relationshipsCount.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedRelationshipStorage.this.storage.getIncomingRelationshipsCount(receiver));
            }
        }, key)).build();
    }

    public List<Identity> getOutgoingRelationships(final Identity sender, final long offset, final long limit) throws RelationshipStorageException {
        IdentityKey key = new IdentityKey(sender);
        ListRelationshipsKey<IdentityKey> listKey = new ListRelationshipsKey<IdentityKey>(key, RelationshipType.OUTGOING, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.relationshipsCache.get((Object)new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List got = CachedRelationshipStorage.this.storage.getOutgoingRelationships(sender, offset, limit);
                return CachedRelationshipStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildRelationships(keys);
    }

    public int getOutgoingRelationshipsCount(final Identity sender) throws RelationshipStorageException {
        IdentityKey iKey = new IdentityKey(sender);
        RelationshipCountKey<IdentityKey> key = new RelationshipCountKey<IdentityKey>(iKey, RelationshipType.OUTGOING);
        return (Integer)((IntegerData)this.relationshipsCount.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedRelationshipStorage.this.storage.getOutgoingRelationshipsCount(sender));
            }
        }, key)).build();
    }

    public int getRelationshipsCount(final Identity identity) throws RelationshipStorageException {
        IdentityKey iKey = new IdentityKey(identity);
        RelationshipCountKey<IdentityKey> key = new RelationshipCountKey<IdentityKey>(iKey, RelationshipType.RELATIONSHIP);
        return (Integer)((IntegerData)this.relationshipsCount.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedRelationshipStorage.this.storage.getRelationshipsCount(identity));
            }
        }, key)).build();
    }

    public List<Identity> getConnections(final Identity identity, final long offset, final long limit) throws RelationshipStorageException {
        IdentityKey key = new IdentityKey(identity);
        ListRelationshipsKey<IdentityKey> listKey = new ListRelationshipsKey<IdentityKey>(key, RelationshipType.CONNECTION, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.relationshipsCache.get((Object)new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List got = CachedRelationshipStorage.this.storage.getConnections(identity, offset, limit);
                return CachedRelationshipStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildRelationships(keys);
    }

    public List<Identity> getConnections(Identity identity) throws RelationshipStorageException {
        return this.storage.getConnections(identity);
    }

    public int getConnectionsCount(final Identity identity) throws RelationshipStorageException {
        IdentityKey iKey = new IdentityKey(identity);
        RelationshipCountKey<IdentityKey> key = new RelationshipCountKey<IdentityKey>(iKey, RelationshipType.CONNECTION);
        return (Integer)((IntegerData)this.relationshipsCount.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedRelationshipStorage.this.storage.getConnectionsCount(identity));
            }
        }, key)).build();
    }

    public List<Identity> getConnectionsByFilter(final Identity existingIdentity, final ProfileFilter profileFilter, final long offset, final long limit) throws RelationshipStorageException {
        IdentityFilterKey key = new IdentityFilterKey(existingIdentity.getProviderId(), existingIdentity.getRemoteId(), profileFilter);
        ListRelationshipsKey<IdentityFilterKey> listKey = new ListRelationshipsKey<IdentityFilterKey>(key, RelationshipType.CONNECTION_WITH_FILTER, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.relationshipsCache.get((Object)new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List got = CachedRelationshipStorage.this.storage.getConnectionsByFilter(existingIdentity, profileFilter, offset, limit);
                return CachedRelationshipStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildRelationships(keys);
    }

    public List<Identity> getIncomingByFilter(final Identity existingIdentity, final ProfileFilter profileFilter, final long offset, final long limit) throws RelationshipStorageException {
        IdentityFilterKey key = new IdentityFilterKey(existingIdentity.getProviderId(), existingIdentity.getRemoteId(), profileFilter);
        ListRelationshipsKey<IdentityFilterKey> listKey = new ListRelationshipsKey<IdentityFilterKey>(key, RelationshipType.INCOMMING_WITH_FILTER, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.relationshipsCache.get((Object)new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List got = CachedRelationshipStorage.this.storage.getIncomingByFilter(existingIdentity, profileFilter, offset, limit);
                return CachedRelationshipStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildRelationships(keys);
    }

    public List<Identity> getOutgoingByFilter(final Identity existingIdentity, final ProfileFilter profileFilter, final long offset, final long limit) throws RelationshipStorageException {
        IdentityFilterKey key = new IdentityFilterKey(existingIdentity.getProviderId(), existingIdentity.getRemoteId(), profileFilter);
        ListRelationshipsKey<IdentityFilterKey> listKey = new ListRelationshipsKey<IdentityFilterKey>(key, RelationshipType.OUTGOING_WITH_FILTER, offset, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.relationshipsCache.get((Object)new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List got = CachedRelationshipStorage.this.storage.getOutgoingByFilter(existingIdentity, profileFilter, offset, limit);
                return CachedRelationshipStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildRelationships(keys);
    }

    public int getConnectionsCountByFilter(final Identity existingIdentity, final ProfileFilter profileFilter) throws RelationshipStorageException {
        IdentityFilterKey iKey = new IdentityFilterKey(existingIdentity.getProviderId(), existingIdentity.getRemoteId(), profileFilter);
        RelationshipCountKey<IdentityFilterKey> key = new RelationshipCountKey<IdentityFilterKey>(iKey, RelationshipType.CONNECTION_WITH_FILTER);
        return (Integer)((IntegerData)this.relationshipsCount.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedRelationshipStorage.this.storage.getConnectionsCountByFilter(existingIdentity, profileFilter));
            }
        }, key)).build();
    }

    public int getIncomingCountByFilter(final Identity existingIdentity, final ProfileFilter profileFilter) throws RelationshipStorageException {
        IdentityFilterKey iKey = new IdentityFilterKey(existingIdentity.getProviderId(), existingIdentity.getRemoteId(), profileFilter);
        RelationshipCountKey<IdentityFilterKey> key = new RelationshipCountKey<IdentityFilterKey>(iKey, RelationshipType.INCOMMING_WITH_FILTER);
        return (Integer)((IntegerData)this.relationshipsCount.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedRelationshipStorage.this.storage.getIncomingCountByFilter(existingIdentity, profileFilter));
            }
        }, key)).build();
    }

    public int getOutgoingCountByFilter(final Identity existingIdentity, final ProfileFilter profileFilter) throws RelationshipStorageException {
        IdentityFilterKey iKey = new IdentityFilterKey(existingIdentity.getProviderId(), existingIdentity.getRemoteId(), profileFilter);
        RelationshipCountKey<IdentityFilterKey> key = new RelationshipCountKey<IdentityFilterKey>(iKey, RelationshipType.OUTGOING_WITH_FILTER);
        return (Integer)((IntegerData)this.relationshipsCount.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedRelationshipStorage.this.storage.getOutgoingCountByFilter(existingIdentity, profileFilter));
            }
        }, key)).build();
    }

    public Map<Identity, Integer> getSuggestions(final Identity identity, final int maxConnections, final int maxConnectionsToLoad, final int maxSuggestions) throws RelationshipStorageException {
        IdentityKey key = new IdentityKey(identity);
        SuggestionKey<IdentityKey> suggestKey = new SuggestionKey<IdentityKey>(key, maxConnections, maxConnectionsToLoad, maxSuggestions);
        SuggestionsData keys = (SuggestionsData)this.suggestionCache.get((Object)new ServiceContext<SuggestionsData>(){

            @Override
            public SuggestionsData execute() {
                Map got = CachedRelationshipStorage.this.storage.getSuggestions(identity, maxConnections, maxConnectionsToLoad, maxSuggestions);
                return CachedRelationshipStorage.this.buildIdMap(got);
            }
        }, suggestKey);
        return this.buildSuggestions(keys);
    }

    public List<Identity> getLastConnections(final Identity identity, final int limit) throws RelationshipStorageException {
        IdentityKey key = new IdentityKey(identity);
        ListRelationshipsKey<IdentityKey> listKey = new ListRelationshipsKey<IdentityKey>(key, RelationshipType.LAST_CONNECTIONS, 0L, limit);
        ListIdentitiesData keys = (ListIdentitiesData)this.relationshipsCache.get((Object)new ServiceContext<ListIdentitiesData>(){

            @Override
            public ListIdentitiesData execute() {
                List got = CachedRelationshipStorage.this.storage.getLastConnections(identity, limit);
                return CachedRelationshipStorage.this.buildIds(got);
            }
        }, listKey);
        return this.buildRelationships(keys);
    }

    public List<Relationship> getRelationshipsByStatus(Identity identity, Relationship.Type type, long offset, long limit) {
        return this.storage.getRelationshipsByStatus(identity, type, offset, limit);
    }

    public int getRelationshipsCountByStatus(Identity identity, Relationship.Type type) {
        return this.storage.getRelationshipsCountByStatus(identity, type);
    }

    public int getConnectionsInCommonCount(Identity identity1, Identity identity2) {
        Identity idLast;
        Identity idFirst;
        if (identity1 == null || identity2 == null || StringUtils.isBlank((String)identity1.getId()) || StringUtils.isBlank((String)identity2.getId()) || identity1.getId().trim().equals(identity2.getId().trim())) {
            return 0;
        }
        if (identity1.getId().compareTo(identity2.getId()) > 0) {
            idFirst = identity1;
            idLast = identity2;
        } else {
            idFirst = identity2;
            idLast = identity1;
        }
        RelationshipIdentityKey identitiesKey = new RelationshipIdentityKey(idFirst.getId(), idLast.getId());
        RelationshipCountKey<RelationshipIdentityKey> key = new RelationshipCountKey<RelationshipIdentityKey>(identitiesKey, RelationshipType.CONNECTION);
        return (Integer)((IntegerData)this.relationshipsCount.get((Object)new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                return new IntegerData(CachedRelationshipStorage.this.storage.getConnectionsInCommonCount(idFirst, idLast));
            }
        }, key)).build();
    }
}

