/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.webui.config.Application;
import org.exoplatform.webui.config.Component;
import org.exoplatform.webui.config.ComponentHandle;
import org.exoplatform.webui.config.Event;
import org.exoplatform.webui.config.EventInterceptor;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.Param;
import org.exoplatform.webui.config.Validator;
import org.exoplatform.webui.config.WebuiConfiguration;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.EventInterceptorConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.config.annotation.ValidatorConfig;
import org.exoplatform.webui.config.metadata.ComponentMetaData;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;

public class ConfigurationManager {
    private Map<String, Component> configs_ = new ConcurrentHashMap<String, Component>();
    private final Logger log = LoggerFactory.getLogger(ConfigurationManager.class);
    private Application application_;

    public ConfigurationManager(InputStream inputStream) throws Exception {
        IBindingFactory bfact = BindingDirectory.getFactory(WebuiConfiguration.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        WebuiConfiguration config = (WebuiConfiguration)uctx.unmarshalDocument(inputStream, null);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (config.getAnnotationClasses() != null) {
            for (String annotationClass : config.getAnnotationClasses()) {
                Component[] components = this.annotationToComponents(cl, annotationClass);
                this.setComponentConfigs(components);
            }
        }
        if (config.getComponents() != null) {
            for (ComponentMetaData componentMetaData : config.getComponents()) {
                Object key = componentMetaData.getType();
                if (componentMetaData.getId() != null) {
                    key = (String)key + ":" + componentMetaData.getId();
                }
                this.configs_.put((String)key, new Component(componentMetaData));
            }
        }
        this.application_ = config.getApplication();
    }

    void setComponentConfigs(Component[] configs) {
        for (Component component : configs) {
            this.configs_.put(component.getKey(), component);
        }
    }

    public List<Component> getComponentConfig(Class<?> clazz) {
        ArrayList<Component> configs = new ArrayList<Component>();
        Collection<Component> values = this.configs_.values();
        String type = clazz.getName();
        for (Component comp : values) {
            if (!comp.getType().equals(type)) continue;
            configs.add(comp);
        }
        return configs;
    }

    public Component getComponentConfig(ComponentHandle handle) {
        Component component = this.configs_.get(handle.getKey());
        if (component == null) {
            Class<?> owner = handle.getOwner();
            this.process(owner);
        }
        return this.configs_.get(handle.getKey());
    }

    private void process(Class<?> owner) {
        if (owner == null) {
            throw new NullPointerException("Cannot process a null owner");
        }
        try {
            Component[] components = this.annotationToComponents(owner);
            this.setComponentConfigs(components);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not create component configuration for owner " + owner.getName()), (Throwable)e);
        }
    }

    public Component getComponentConfig(Class<?> type, String id) {
        Component config;
        Object key = type.getName();
        if (id != null) {
            key = (String)key + ":" + id;
        }
        if ((config = this.configs_.get(key)) != null) {
            return config;
        }
        this.process(type);
        return this.configs_.get(key);
    }

    public Application getApplication() {
        return this.application_;
    }

    Component[] annotationToComponents(ClassLoader cl, String annClass) throws Exception {
        Class<?> clazz = cl.loadClass(annClass);
        return this.annotationToComponents(clazz);
    }

    Component[] annotationToComponents(Class<?> clazz) throws Exception {
        ComponentConfig annotation = clazz.getAnnotation(ComponentConfig.class);
        if (annotation != null) {
            return new Component[]{this.toComponentConfig(annotation, clazz)};
        }
        ComponentConfigs annotations = clazz.getAnnotation(ComponentConfigs.class);
        if (annotations != null) {
            ComponentConfig[] listAnnotations = annotations.value();
            Component[] componentConfigs = new Component[listAnnotations.length];
            for (int i = 0; i < componentConfigs.length; ++i) {
                componentConfigs[i] = this.toComponentConfig(listAnnotations[i], clazz);
            }
            return componentConfigs;
        }
        return new Component[0];
    }

    private Component toComponentConfig(ComponentConfig annotation, Class<?> clazz) throws Exception {
        ArrayList<Validator> validators;
        ValidatorConfig[] validatorAnnotations;
        ArrayList<EventInterceptor> eventInterceptors;
        EventInterceptorConfig[] eventInterceptorAnnotations;
        ArrayList<Event> events;
        EventConfig[] eventAnnotations;
        String template = null;
        if (annotation.template().length() > 0) {
            template = annotation.template();
        }
        String id = null;
        if (annotation.id().length() > 0) {
            id = annotation.id();
        }
        Class type = annotation.type() == Void.TYPE ? clazz : annotation.type();
        String lifecycle = null;
        if (annotation.lifecycle() != Void.TYPE) {
            lifecycle = annotation.lifecycle().getName();
        }
        String decorator = null;
        if (annotation.decorator().length() > 0) {
            decorator = annotation.decorator();
        }
        if ((eventAnnotations = annotation.events()).length != 0) {
            events = new ArrayList<Event>();
            for (EventConfig eventAnnotation : eventAnnotations) {
                events.add(this.toEventConfig(eventAnnotation));
            }
        } else {
            events = new ArrayList();
        }
        if ((eventInterceptorAnnotations = annotation.eventInterceptors()).length != 0) {
            eventInterceptors = new ArrayList<EventInterceptor>();
            for (EventInterceptorConfig eventAnnotation : eventInterceptorAnnotations) {
                eventInterceptors.add(this.toEventInterceptorConfig(eventAnnotation));
            }
        } else {
            eventInterceptors = new ArrayList();
        }
        if ((validatorAnnotations = annotation.validators()).length != 0) {
            validators = new ArrayList<Validator>();
            for (ValidatorConfig ele : validatorAnnotations) {
                validators.add(this.toValidator(ele));
            }
        } else {
            validators = new ArrayList();
        }
        return new Component(clazz, id, type.getName(), lifecycle, template, decorator, this.toInitParams(annotation.initParams()), validators, events, eventInterceptors);
    }

    private Event toEventConfig(EventConfig annotation) {
        Event event = new Event();
        event.setExecutionPhase(annotation.phase());
        event.setConfirm(annotation.confirm());
        event.setInitParams(this.toInitParams(annotation.initParams()));
        ArrayList<String> listeners = new ArrayList<String>();
        for (Class clazz : annotation.listeners()) {
            listeners.add(clazz.getName());
        }
        if (annotation.name().length() > 0) {
            event.setName(annotation.name());
        } else if (annotation.listeners().length > 0) {
            String name = annotation.listeners()[0].getSimpleName();
            int idx = name.indexOf("ActionListener");
            if (idx > -1) {
                name = name.substring(0, idx);
            }
            event.setName(name);
        }
        event.setListeners(listeners);
        event.setCsrfCheck(annotation.csrfCheck());
        return event;
    }

    private EventInterceptor toEventInterceptorConfig(EventInterceptorConfig annotation) {
        EventInterceptor eventInterceptor = new EventInterceptor();
        eventInterceptor.setType(annotation.type().getName());
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, annotation.interceptors());
        eventInterceptor.setInterceptors(list);
        eventInterceptor.setInitParams(this.toInitParams(annotation.initParams()));
        return eventInterceptor;
    }

    private Validator toValidator(ValidatorConfig annotation) {
        Validator validator = new Validator();
        validator.setType(annotation.type().getName());
        validator.setInitParams(this.toInitParams(annotation.initParams()));
        return validator;
    }

    private InitParams toInitParams(ParamConfig[] annotations) {
        if (annotations == null || annotations.length < 1) {
            return null;
        }
        ArrayList<Param> listParam = new ArrayList<Param>();
        for (ParamConfig ele : annotations) {
            Param param = new Param();
            param.setName(ele.name());
            param.setValue(ele.value());
            listParam.add(param);
        }
        InitParams initParams = new InitParams();
        initParams.setParams(listParam);
        return initParams;
    }
}

